/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.generator.p2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Part;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.generator.GeneratorProcessor;
import org.eclipse.packagedrone.repo.generator.p2.CategoryData;
import org.eclipse.packagedrone.repo.generator.p2.FeatureData;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.osgi.framework.FrameworkUtil;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
public class GeneratorController {
    private ChannelService service;
    private final GeneratorProcessor generators = new GeneratorProcessor(FrameworkUtil.getBundle(GeneratorController.class).getBundleContext());

    public void start() {
        this.generators.open();
    }

    public void stop() {
        this.generators.close();
    }

    public void setService(ChannelService service) {
        this.service = service;
    }

    @RequestMapping(value={"/generators/p2.feature/channel/{channelId}/artifact/{artifactId}/editFeature"}, method={RequestMethod.GET})
    public ModelAndView editFeature(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId) throws Exception {
        return Channels.withArtifact((ChannelService)this.service, (String)channelId, (String)artifactId, ReadableChannel.class, (channel, artifact) -> {
            HashMap<String, Object> model = new HashMap<String, Object>(3);
            model.put("artifactId", artifactId);
            FeatureData data = new FeatureData();
            MetaKeys.bind((Object)data, (Map)artifact.getMetaData());
            model.put("command", data);
            model.put("channelId", artifact.getChannelId().getId());
            return new ModelAndView("edit", model);
        });
    }

    @RequestMapping(value={"/generators/p2.feature/channel/{channelId}/artifact/{artifactId}/editFeature"}, method={RequestMethod.POST})
    public ModelAndView editFeaturePost(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId, @Valid @FormData(value="command") FeatureData data, BindingResult result) throws Exception {
        if (result.hasErrors()) {
            ModelAndView mav = new ModelAndView("edit");
            mav.put("artifactId", (Object)artifactId);
            return mav;
        }
        Map providedMetaData = MetaKeys.unbind((Object)data);
        return Channels.withArtifact((ChannelService)this.service, (String)channelId, (String)artifactId, ModifiableChannel.class, (channel, artifact) -> {
            channel.getContext().applyMetaData(artifactId, providedMetaData);
            return Channels.redirectViewArtifact((String)channelId, (String)artifactId);
        });
    }

    @RequestMapping(value={"/generators/p2.feature/channel/{channelId}/createFeature"}, method={RequestMethod.GET})
    public ModelAndView createFeature(@PathVariable(value="channelId") String channelId) {
        ModelAndView mav = new ModelAndView("create");
        mav.put("generators", this.generators.getInformations().values());
        mav.put("channelId", (Object)channelId);
        mav.put("command", (Object)new FeatureData());
        return mav;
    }

    @RequestMapping(value={"/generators/p2.feature/channel/{channelId}/createFeature"}, method={RequestMethod.POST})
    public ModelAndView createFeaturePost(@PathVariable(value="channelId") String channelId, @Valid @FormData(value="command") FeatureData data, BindingResult result) throws Exception {
        if (result.hasErrors()) {
            ModelAndView mav = new ModelAndView("create");
            mav.put("generators", this.generators.getInformations().values());
            mav.put("channelId", (Object)channelId);
            return mav;
        }
        Map providedMetaData = MetaKeys.unbind((Object)data);
        String name = String.format("%s-%s.feature", data.getId(), data.getVersion());
        this.service.accessRun(ChannelService.By.id((String)channelId), ModifiableChannel.class, channel -> channel.getContext().createGeneratorArtifact("p2.feature", (InputStream)new ByteArrayInputStream(new byte[0]), name, providedMetaData));
        return Channels.redirectViewChannel((String)channelId);
    }

    @RequestMapping(value={"/generators/p2.category/channel/{channelId}/artifact/{artifactId}/editCategory"}, method={RequestMethod.GET})
    public ModelAndView editCategory(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId) throws Exception {
        return Channels.withArtifact((ChannelService)this.service, (String)channelId, (String)artifactId, ReadableChannel.class, (channel, artifact) -> {
            HashMap<String, Object> model = new HashMap<String, Object>(3);
            model.put("artifactId", artifactId);
            CategoryData data = new CategoryData();
            MetaKeys.bind((Object)data, (Map)artifact.getMetaData());
            model.put("command", data);
            model.put("channelId", artifact.getChannelId().getId());
            return new ModelAndView("editCategory", model);
        });
    }

    @RequestMapping(value={"/generators/p2.category/channel/{channelId}/artifact/{artifactId}/editCategory"}, method={RequestMethod.POST})
    public ModelAndView editCategoryPost(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId, @Valid @FormData(value="command") CategoryData data, BindingResult result) throws Exception {
        if (result.hasErrors()) {
            ModelAndView mav = new ModelAndView("editCategory");
            mav.put("artifactId", (Object)artifactId);
            return mav;
        }
        Map providedMetaData = MetaKeys.unbind((Object)data);
        return Channels.withArtifact((ChannelService)this.service, (String)channelId, (String)artifactId, ModifiableChannel.class, (channel, artifact) -> {
            channel.getContext().applyMetaData(artifactId, providedMetaData);
            return Channels.redirectViewArtifact((String)channelId, (String)artifactId);
        });
    }

    @RequestMapping(value={"/generators/p2.category/channel/{channelId}/createCategory"}, method={RequestMethod.GET})
    public ModelAndView createCategory(@PathVariable(value="channelId") String channelId) {
        ModelAndView mav = new ModelAndView("createCategory");
        mav.put("generators", this.generators.getInformations().values());
        mav.put("channelId", (Object)channelId);
        mav.put("command", (Object)new CategoryData());
        return mav;
    }

    @RequestMapping(value={"/generators/p2.category/channel/{channelId}/createCategory"}, method={RequestMethod.POST})
    public ModelAndView createCategoryPost(@PathVariable(value="channelId") String channelId, @Valid @FormData(value="command") CategoryData data, BindingResult result) throws Exception {
        if (result.hasErrors()) {
            ModelAndView mav = new ModelAndView("createCategory");
            mav.put("generators", this.generators.getInformations().values());
            mav.put("channelId", (Object)channelId);
            return mav;
        }
        Map providedMetaData = MetaKeys.unbind((Object)data);
        String name = String.format("%s.category", data.getId());
        this.service.accessRun(ChannelService.By.id((String)channelId), ModifiableChannel.class, channel -> channel.getContext().createGeneratorArtifact("p2.category", (InputStream)new ByteArrayInputStream(new byte[0]), name, providedMetaData));
        return Channels.redirectViewChannel((String)channelId);
    }

    @RequestMapping(value={"/generators/p2.category/channel/{channelId}/createCategoryXml"}, method={RequestMethod.GET})
    public ModelAndView createCategoryXml(@PathVariable(value="channelId") String channelId) {
        ModelAndView mav = new ModelAndView("createCategoryXml");
        mav.put("generators", this.generators.getInformations().values());
        mav.put("channelId", (Object)channelId);
        return mav;
    }

    @RequestMapping(value={"/generators/p2.category/channel/{channelId}/createCategoryXml"}, method={RequestMethod.POST})
    public ModelAndView createCategoryXmlPost(@PathVariable(value="channelId") String channelId, @RequestParameter(value="file") Part file, BindingResult result) throws Exception {
        if (result.hasErrors()) {
            ModelAndView mav = new ModelAndView("createCategoryXml");
            mav.put("generators", this.generators.getInformations().values());
            mav.put("channelId", (Object)channelId);
            return mav;
        }
        String name = file.getSubmittedFileName();
        this.service.accessRun(ChannelService.By.id((String)channelId), ModifiableChannel.class, channel -> channel.getContext().createGeneratorArtifact("p2.categoryXml", file.getInputStream(), name, null));
        return Channels.redirectViewChannel((String)channelId);
    }
}

