/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.internal;

import com.google.common.html.HtmlEscapers;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.adapter.maven.ChannelData;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.util.DownloadHelper;
import org.eclipse.scada.utils.str.ExtendedPropertiesReplacer;
import org.eclipse.scada.utils.str.StringReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenHandler {
    private static final Logger logger = LoggerFactory.getLogger(MavenHandler.class);
    private final ChannelData channelData;
    private final ReadableChannel channel;

    public MavenHandler(ReadableChannel channel, ChannelData channelData) {
        this.channel = channel;
        this.channelData = channelData;
    }

    public void handle(String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        LinkedList<String> segs = path != null ? new LinkedList<String>(Arrays.asList(path.split("/+"))) : new LinkedList();
        ChannelData.Node node = this.channelData.findNode(segs);
        if (node == null) {
            response.setStatus(404);
            response.setContentType("text/plain");
            response.getWriter().format("Unable to find: '%s'", path == null ? "" : path);
            return;
        }
        logger.debug("{} : Node - {}", (Object)path, (Object)node);
        if (node instanceof ChannelData.DirectoryNode) {
            if (!request.getPathInfo().endsWith("/")) {
                response.sendRedirect(String.valueOf(request.getRequestURI()) + "/");
                return;
            }
            response.setStatus(200);
            this.renderDir(response, (ChannelData.DirectoryNode)node, path);
        } else if (node instanceof ChannelData.ContentNode) {
            ChannelData.ContentNode dataNode = (ChannelData.ContentNode)node;
            response.setStatus(200);
            response.setContentType(dataNode.getMimeType());
            response.setContentLength(dataNode.getData().length);
            response.getOutputStream().write(dataNode.getData());
        } else if (node instanceof ChannelData.ArtifactNode) {
            response.setStatus(200);
            this.download(response, (ChannelData.ArtifactNode)node);
        } else {
            response.setStatus(500);
            response.setContentType("text/plain");
            response.getWriter().format("Unknown node type: %s", node == null ? "null" : node.getClass().getName());
        }
    }

    private void download(HttpServletResponse response, ChannelData.ArtifactNode node) throws IOException {
        DownloadHelper.streamArtifact((HttpServletResponse)response, (String)node.getArtifactId(), Optional.empty(), (boolean)false, (ReadableChannel)this.channel, null);
    }

    private void renderDir(HttpServletResponse response, ChannelData.DirectoryNode dir, String path) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        PrintWriter w = response.getWriter();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("path", path);
        model.put("dir", new DirRenderer(dir));
        model.put("version", VersionInformation.VERSION);
        w.write(StringReplacer.replace((String)this.loadResource("content/index.html"), (StringReplacer.ReplaceSource)new ExtendedPropertiesReplacer(model), (Pattern)StringReplacer.DEFAULT_PATTERN, (boolean)true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadResource(String name) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream is = MavenHandler.class.getResourceAsStream(name);
            try {
                String string;
                block14: {
                    InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);
                    try {
                        string = CharStreams.toString((Readable)r);
                        return string;
                    }
                    finally {
                        if (r == null) break block14;
                        ((Reader)r).close();
                    }
                }
                if (is != null) {
                    is.close();
                }
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private static class DirRenderer {
        private final ChannelData.DirectoryNode dir;

        public DirRenderer(ChannelData.DirectoryNode dir) {
            this.dir = dir;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.render(pw);
            pw.close();
            return sw.toString();
        }

        private void render(PrintWriter pw) {
            pw.write("<ul>\n");
            pw.write("<li><a href=\"..\">..</a></li>");
            ArrayList<String> dirs = new ArrayList<String>(this.dir.getNodes().keySet());
            Collections.sort(dirs);
            for (String entry : dirs) {
                ChannelData.Node node = this.dir.getNodes().get(entry);
                String esc = HtmlEscapers.htmlEscaper().escape(entry);
                pw.write("<li><a href=\"");
                if (node.isDirectory() && !esc.endsWith("/")) {
                    esc = String.valueOf(esc) + "/";
                }
                pw.write(esc);
                pw.write("\">");
                pw.write(esc);
                pw.write("</a></li>\n");
            }
            pw.write("</ul>\n");
        }
    }
}

