/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.deb.aspect.internal;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.eclipse.packagedrone.repo.Severity;
import org.eclipse.packagedrone.repo.adapter.deb.aspect.DistributionInformation;
import org.eclipse.packagedrone.repo.adapter.deb.aspect.internal.SpoolOutHandler;
import org.eclipse.packagedrone.repo.adapter.deb.aspect.internal.ValidationListener;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.eclipse.packagedrone.repo.utils.HashHelper;
import org.eclipse.packagedrone.utils.deb.Packages;
import org.eclipse.scada.utils.str.StringHelper;

public class RepoBuilder {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM YYYY HH:mm:ss z", Locale.US);
    private final Map<String, Distribution> distributions = new HashMap<String, Distribution>();
    private final SigningService signingService;

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public RepoBuilder(SigningService signingService) {
        this.signingService = signingService;
    }

    public void addDistribution(String name, DistributionInformation information) {
        this.distributions.put(name, new Distribution(name, information));
    }

    public void addPackage(String distribution, String component, String architecture, PackageInformation packageInfo) {
        this.addPackage(distribution, component, architecture, packageInfo, null);
    }

    public void addPackage(String distribution, String component, String architecture, PackageInformation packageInfo, ValidationListener validationListener) {
        Distribution dist = this.distributions.get(distribution);
        if (dist == null) {
            return;
        }
        dist.addPackage(component, architecture, packageInfo, validationListener);
    }

    public void spoolOut(SpoolOutHandler handler) throws IOException {
        for (Distribution dist : this.distributions.values()) {
            TreeMap<String, Checksums> checksums = new TreeMap<String, Checksums>();
            for (Component comp : dist.getComponents().values()) {
                for (SubComponent sub : comp.getSubComponents().values()) {
                    this.spoolOutFile(checksums, "dists/" + dist.getName(), String.format("%s/%s/Release", comp.getName(), sub.getName()), "text/plain", sub.toReleaseFile(dist, comp), handler);
                    byte[] pkgData = sub.toPackageFile();
                    this.spoolOutFile(checksums, "dists/" + dist.getName(), String.format("%s/%s/Packages", comp.getName(), sub.getName()), "text/plain", pkgData, handler);
                    this.spoolOutFile(checksums, "dists/" + dist.getName(), String.format("%s/%s/Packages.gz", comp.getName(), sub.getName()), "application/x-gzip", this.compressGzip(pkgData), handler);
                    this.spoolOutFile(checksums, "dists/" + dist.getName(), String.format("%s/%s/Packages.bz2", comp.getName(), sub.getName()), "application/x-bzip2", this.compressBzip2(pkgData), handler);
                }
            }
            this.spoolOutDistRelease(dist, checksums, handler);
        }
    }

    private byte[] compressGzip(byte[] data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        gos.write(data);
        gos.close();
        return bos.toByteArray();
    }

    private byte[] compressBzip2(byte[] data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BZip2CompressorOutputStream b2os = new BZip2CompressorOutputStream((OutputStream)bos);
        b2os.write(data);
        b2os.close();
        return bos.toByteArray();
    }

    private void spoolOutDistRelease(Distribution dist, SortedMap<String, Checksums> checksums, SpoolOutHandler handler) throws IOException {
        StringWriter sw = new StringWriter();
        DistributionInformation info = dist.getInformation();
        RepoBuilder.writeOptional(sw, "Origin", info.getOrigin());
        RepoBuilder.writeOptional(sw, "Label", info.getLabel());
        RepoBuilder.writeOptional(sw, "Suite", info.getSuite());
        RepoBuilder.writeOptional(sw, "Version", info.getVersion());
        RepoBuilder.writeOptional(sw, "Codename", info.getCodename());
        RepoBuilder.write(sw, "Date", DATE_FORMAT.format(new Date()));
        RepoBuilder.write(sw, "Components", StringHelper.join(dist.getComponents().keySet(), (String)" "));
        RepoBuilder.write(sw, "Architectures", StringHelper.join(info.getArchitectures(), (String)" "));
        RepoBuilder.writeOptional(sw, "Description", info.getDescription());
        StringWriter md5 = new StringWriter();
        StringWriter sha1 = new StringWriter();
        StringWriter sha256 = new StringWriter();
        PrintWriter md5Pw = new PrintWriter(md5);
        PrintWriter sha1Pw = new PrintWriter(sha1);
        PrintWriter sha256Pw = new PrintWriter(sha256);
        for (Map.Entry<String, Checksums> entry : checksums.entrySet()) {
            this.addChecksum(md5Pw, entry.getKey(), entry.getValue(), "MD5Sum");
            this.addChecksum(sha1Pw, entry.getKey(), entry.getValue(), "SHA1");
            this.addChecksum(sha256Pw, entry.getKey(), entry.getValue(), "SHA256");
        }
        RepoBuilder.write(sw, "MD5Sum", md5.toString());
        RepoBuilder.write(sw, "SHA1", sha1.toString());
        RepoBuilder.write(sw, "SHA256", sha256.toString());
        byte[] data = sw.toString().getBytes(StandardCharsets.UTF_8);
        handler.spoolOut(String.format("dists/%s/Release", dist.getName()), "text/plain", new ByteArrayInputStream(data));
        if (this.signingService != null) {
            handler.spoolOut(String.format("dists/%s/Release.gpg", dist.getName()), "text/plain", new ByteArrayInputStream(this.sign(data, false)));
            handler.spoolOut(String.format("dists/%s/InRelease", dist.getName()), "text/plain", new ByteArrayInputStream(this.sign(data, true)));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.signingService.printPublicKey((OutputStream)bos);
            bos.close();
            handler.spoolOut("GPG-KEY", "text/plain", new ByteArrayInputStream(bos.toByteArray()));
        }
    }

    private byte[] sign(byte[] data, boolean inline) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try {
                this.signingService.sign((InputStream)new ByteArrayInputStream(data), (OutputStream)bos, inline);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to sign", e);
            }
        }
        return bos.toByteArray();
    }

    private void addChecksum(PrintWriter writer, String name, Checksums chk, String alg) {
        HashCode hashCode = chk.getCodes().get(alg);
        writer.format("\n %s %16d %s", hashCode.toString(), chk.getSize(), name);
    }

    private void spoolOutFile(Map<String, Checksums> checksums, String prefix, String fileName, String mimeType, byte[] data, SpoolOutHandler handler) throws IOException {
        checksums.put(fileName, Checksums.create(data));
        handler.spoolOut(String.valueOf(prefix) + "/" + fileName, mimeType, new ByteArrayInputStream(data));
    }

    protected static void writeOptional(StringWriter writer, String fieldName, String value) {
        if (value != null) {
            RepoBuilder.write(writer, fieldName, value);
        }
    }

    protected static void write(StringWriter writer, String fieldName, String value) {
        writer.write(String.valueOf(fieldName) + ": " + value + "\n");
    }

    private static class Checksums {
        private final Map<String, HashCode> codes;
        private final int size;

        public Checksums(Map<String, HashCode> result, int length) {
            this.codes = result;
            this.size = length;
        }

        public Map<String, HashCode> getCodes() {
            return this.codes;
        }

        public int getSize() {
            return this.size;
        }

        public static Checksums create(byte[] data) throws IOException {
            HashMap<String, HashFunction> functions = new HashMap<String, HashFunction>();
            functions.put("MD5Sum", Hashing.md5());
            functions.put("SHA1", Hashing.sha1());
            functions.put("SHA256", Hashing.sha256());
            Map result = HashHelper.createChecksums((InputStream)new ByteArrayInputStream(data), functions);
            return new Checksums(result, data.length);
        }
    }

    public static class Component {
        private final String name;
        private final Map<String, SubComponent> subComponents = new HashMap<String, SubComponent>();

        public Component(String name, SortedSet<String> archs) {
            this.name = name;
            for (String arch : archs) {
                String subName = "binary-" + arch;
                this.subComponents.put(subName, new SubComponent(subName, arch));
            }
        }

        public String getName() {
            return this.name;
        }

        public void addPackage(String subComponent, String architecture, PackageInformation packageInfo) {
            SubComponent sub = this.subComponents.get(subComponent);
            if (sub == null) {
                return;
            }
            sub.addPackage(packageInfo);
        }

        public Map<String, SubComponent> getSubComponents() {
            return Collections.unmodifiableMap(this.subComponents);
        }
    }

    public static class Distribution {
        private final String name;
        private final DistributionInformation information;
        private final Map<String, Component> components = new TreeMap<String, Component>();

        public Distribution(String name, DistributionInformation information) {
            this.name = name;
            this.information = information;
            for (String component : information.getComponents()) {
                this.components.put(component, new Component(component, information.getArchitectures()));
            }
        }

        public DistributionInformation getInformation() {
            return this.information;
        }

        public Map<String, Component> getComponents() {
            return Collections.unmodifiableMap(this.components);
        }

        public String getName() {
            return this.name;
        }

        public void addPackage(String component, String architecture, PackageInformation packageInfo, ValidationListener validationListener) {
            Component comp = this.components.get(component);
            if (comp == null) {
                return;
            }
            if ("all".equals(architecture)) {
                for (String arch : this.information.getArchitectures()) {
                    comp.addPackage("binary-" + arch, arch, packageInfo);
                }
            } else {
                if (!this.information.getArchitectures().contains(architecture)) {
                    if (validationListener != null) {
                        validationListener.validationMessage(Severity.WARNING, String.format("Architecture '%s' is not configured. Package will be ignored.", architecture));
                    }
                    return;
                }
                comp.addPackage("binary-" + architecture, architecture, packageInfo);
            }
        }
    }

    public static class PackageInformation {
        private final String poolName;
        private final Map<String, String> control;
        private final long fileSize;
        private final Map<String, String> checksums;

        public PackageInformation(String poolName, long fileSize, Map<String, String> control, Map<String, String> checksums) {
            this.poolName = poolName;
            this.fileSize = fileSize;
            this.control = control;
            this.checksums = checksums;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public Map<String, String> getControl() {
            return this.control;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public Map<String, String> getChecksums() {
            return this.checksums;
        }
    }

    public static class SubComponent {
        private final String name;
        private final StringWriter sw = new StringWriter();
        private final PrintWriter pw = new PrintWriter(this.sw);
        private final String architecture;

        public SubComponent(String name, String architecture) {
            this.name = name;
            this.architecture = architecture;
        }

        public String getName() {
            return this.name;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public void addPackage(PackageInformation packageInfo) {
            HashMap<String, String> values = new HashMap<String, String>(packageInfo.getControl());
            values.put("Filename", packageInfo.getPoolName());
            values.put("Size", Long.toString(packageInfo.getFileSize()));
            if (!values.containsKey("Description-md5")) {
                values.put("Description-md5", Packages.makeDescriptionMd5((String)((String)values.get("Description"))));
            }
            for (Map.Entry<String, String> entry : packageInfo.getChecksums().entrySet()) {
                String v = entry.getValue();
                if (v == null) continue;
                values.put(entry.getKey(), v);
            }
            try {
                Packages.writeBinaryPackageValues((PrintWriter)this.pw, values);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write package stream", e);
            }
            this.pw.print("\n");
        }

        public byte[] toReleaseFile(Distribution dist, Component comp) {
            StringWriter sw = new StringWriter();
            DistributionInformation info = dist.getInformation();
            RepoBuilder.writeOptional(sw, "Version", info.getVersion());
            RepoBuilder.writeOptional(sw, "Origin", info.getOrigin());
            RepoBuilder.writeOptional(sw, "Label", info.getLabel());
            RepoBuilder.writeOptional(sw, "Archive", info.getSuite());
            sw.write("Component: " + comp.getName() + "\n");
            sw.write("Architecture: " + this.architecture + "\n");
            return sw.toString().getBytes(StandardCharsets.UTF_8);
        }

        public byte[] toPackageFile() {
            return this.sw.toString().getBytes(StandardCharsets.UTF_8);
        }
    }
}

