/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.search.stream;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.search.ArtifactLocator;
import org.eclipse.packagedrone.repo.channel.search.Predicate;
import org.eclipse.packagedrone.repo.channel.search.SearchOptions;
import org.eclipse.packagedrone.repo.channel.search.stream.PredicateFilterBuilder;

public class StreamArtifactLocator
implements ArtifactLocator {
    private final Supplier<Stream<? extends ArtifactInformation>> informationSupplier;

    public StreamArtifactLocator(Supplier<Stream<? extends ArtifactInformation>> informationSupplier) {
        this.informationSupplier = informationSupplier;
    }

    @Override
    public <R> R process(Predicate predicate, SearchOptions options, Function<Stream<? extends ArtifactInformation>, R> function) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<? extends ArtifactInformation> stream = this.informationSupplier.get();){
            return function.apply(StreamArtifactLocator.search(stream, predicate, options));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T extends ArtifactInformation> Stream<T> search(Stream<T> stream, Predicate predicate, SearchOptions options) {
        Objects.requireNonNull(stream);
        SearchOptions searchOptions = options = options != null ? options : SearchOptions.DEFAULT_OPTIONS;
        if (predicate != null) {
            stream = stream.filter(StreamArtifactLocator.compilePredicate(predicate));
        }
        stream = StreamArtifactLocator.applyOptions(stream, options);
        return stream;
    }

    public static java.util.function.Predicate<ArtifactInformation> compilePredicate(Predicate predicate) {
        Objects.requireNonNull(predicate);
        return new PredicateFilterBuilder(predicate).build();
    }

    private static <T extends ArtifactInformation> Stream<T> applyOptions(Stream<T> stream, SearchOptions options) {
        if (options.getSkip() > 0L) {
            stream = stream.skip(options.getSkip());
        }
        if (options.getLimit() > 0L) {
            stream = stream.limit(options.getLimit());
        }
        return stream;
    }
}

