/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.api.conditions.evaluation;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;

public final class Emission {
    private final ConditionPack pack;
    private final Collection<Permission> permissions;

    public Emission(ConditionPack pack) {
        this(pack, Collections.emptyList());
    }

    public Emission(ConditionPack pack, Permission permission) {
        this(pack, Collections.singleton(permission));
    }

    public Emission(ConditionPack pack, Collection<Permission> permissions) {
        Objects.requireNonNull(pack, "Emission::pack");
        Objects.requireNonNull(permissions, "Emission::permissions");
        this.pack = pack;
        this.permissions = permissions;
        if (permissions.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Null permissions have no sence");
        }
    }

    public final ConditionPack conditionPack() {
        return this.pack;
    }

    public Collection<Permission> permissions() {
        return this.permissions;
    }
}

