/*******************************************************************************
 * Copyright (c) 2006, 2016 Soyatec (http://www.soyatec.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Soyatec - initial API and implementation
 *******************************************************************************/
package org.eclipse.pmf.pim.ui.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.pmf.pim.ui.util.UiAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * @generated
 */
public class UiItemProviderAdapterFactory extends UiAdapterFactory implements
		ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement
	 * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public UiItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Text} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TextItemProvider textItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Text}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTextAdapter() {
		if (textItemProvider == null) {
			textItemProvider = new TextItemProvider(this);
		}

		return textItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.StackPanel} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected StackPanelItemProvider stackPanelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.StackPanel}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStackPanelAdapter() {
		if (stackPanelItemProvider == null) {
			stackPanelItemProvider = new StackPanelItemProvider(this);
		}

		return stackPanelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Separator} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected SeparatorItemProvider separatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Separator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSeparatorAdapter() {
		if (separatorItemProvider == null) {
			separatorItemProvider = new SeparatorItemProvider(this);
		}

		return separatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Label} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelItemProvider labelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Label}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createLabelAdapter() {
		if (labelItemProvider == null) {
			labelItemProvider = new LabelItemProvider(this);
		}

		return labelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Image} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageItemProvider imageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Image}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createImageAdapter() {
		if (imageItemProvider == null) {
			imageItemProvider = new ImageItemProvider(this);
		}

		return imageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Window} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WindowItemProvider windowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Window}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createWindowAdapter() {
		if (windowItemProvider == null) {
			windowItemProvider = new WindowItemProvider(this);
		}

		return windowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Button} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ButtonItemProvider buttonItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Button}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createButtonAdapter() {
		if (buttonItemProvider == null) {
			buttonItemProvider = new ButtonItemProvider(this);
		}

		return buttonItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Combo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComboItemProvider comboItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Combo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComboAdapter() {
		if (comboItemProvider == null) {
			comboItemProvider = new ComboItemProvider(this);
		}

		return comboItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.GroupBox} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected GroupBoxItemProvider groupBoxItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.GroupBox}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGroupBoxAdapter() {
		if (groupBoxItemProvider == null) {
			groupBoxItemProvider = new GroupBoxItemProvider(this);
		}

		return groupBoxItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.ui.BooleanButton} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected BooleanButtonItemProvider booleanButtonItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.BooleanButton}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanButtonAdapter() {
		if (booleanButtonItemProvider == null) {
			booleanButtonItemProvider = new BooleanButtonItemProvider(this);
		}

		return booleanButtonItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Selector} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected SelectorItemProvider selectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Selector}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSelectorAdapter() {
		if (selectorItemProvider == null) {
			selectorItemProvider = new SelectorItemProvider(this);
		}

		return selectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.ListView} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ListViewItemProvider listViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.ListView}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createListViewAdapter() {
		if (listViewItemProvider == null) {
			listViewItemProvider = new ListViewItemProvider(this);
		}

		return listViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Finder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FinderItemProvider finderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Finder}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createFinderAdapter() {
		if (finderItemProvider == null) {
			finderItemProvider = new FinderItemProvider(this);
		}

		return finderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.MenuItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MenuItemItemProvider menuItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.MenuItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMenuItemAdapter() {
		if (menuItemItemProvider == null) {
			menuItemItemProvider = new MenuItemItemProvider(this);
		}

		return menuItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Container} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ContainerItemProvider containerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Container}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContainerAdapter() {
		if (containerItemProvider == null) {
			containerItemProvider = new ContainerItemProvider(this);
		}

		return containerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.ViewPart} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ViewPartItemProvider viewPartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.ViewPart}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createViewPartAdapter() {
		if (viewPartItemProvider == null) {
			viewPartItemProvider = new ViewPartItemProvider(this);
		}

		return viewPartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.SashFrom} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected SashFromItemProvider sashFromItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.SashFrom}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSashFromAdapter() {
		if (sashFromItemProvider == null) {
			sashFromItemProvider = new SashFromItemProvider(this);
		}

		return sashFromItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.UIEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UIEventItemProvider uiEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.UIEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUIEventAdapter() {
		if (uiEventItemProvider == null) {
			uiEventItemProvider = new UIEventItemProvider(this);
		}

		return uiEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Color} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ColorItemProvider colorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Color}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createColorAdapter() {
		if (colorItemProvider == null) {
			colorItemProvider = new ColorItemProvider(this);
		}

		return colorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Font} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FontItemProvider fontItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Font}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createFontAdapter() {
		if (fontItemProvider == null) {
			fontItemProvider = new FontItemProvider(this);
		}

		return fontItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Part} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PartItemProvider partItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Part}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPartAdapter() {
		if (partItemProvider == null) {
			partItemProvider = new PartItemProvider(this);
		}

		return partItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.ui.PropertiesPart} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PropertiesPartItemProvider propertiesPartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.PropertiesPart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertiesPartAdapter() {
		if (propertiesPartItemProvider == null) {
			propertiesPartItemProvider = new PropertiesPartItemProvider(this);
		}

		return propertiesPartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.PropertyTab} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyTabItemProvider propertyTabItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.PropertyTab}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyTabAdapter() {
		if (propertyTabItemProvider == null) {
			propertyTabItemProvider = new PropertyTabItemProvider(this);
		}

		return propertyTabItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Tab} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TabItemProvider tabItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Tab}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTabAdapter() {
		if (tabItemProvider == null) {
			tabItemProvider = new TabItemProvider(this);
		}

		return tabItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.TabSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TabSetItemProvider tabSetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.TabSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTabSetAdapter() {
		if (tabSetItemProvider == null) {
			tabSetItemProvider = new TabSetItemProvider(this);
		}

		return tabSetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Table} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableItemProvider tableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Table}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTableAdapter() {
		if (tableItemProvider == null) {
			tableItemProvider = new TableItemProvider(this);
		}

		return tableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.RichText} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RichTextItemProvider richTextItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.RichText}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRichTextAdapter() {
		if (richTextItemProvider == null) {
			richTextItemProvider = new RichTextItemProvider(this);
		}

		return richTextItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.DateTimePicker} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DateTimePickerItemProvider dateTimePickerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.DateTimePicker}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDateTimePickerAdapter() {
		if (dateTimePickerItemProvider == null) {
			dateTimePickerItemProvider = new DateTimePickerItemProvider(this);
		}

		return dateTimePickerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Hyperlink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HyperlinkItemProvider hyperlinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Hyperlink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHyperlinkAdapter() {
		if (hyperlinkItemProvider == null) {
			hyperlinkItemProvider = new HyperlinkItemProvider(this);
		}

		return hyperlinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.Page} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PageItemProvider pageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.Page}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPageAdapter() {
		if (pageItemProvider == null) {
			pageItemProvider = new PageItemProvider(this);
		}

		return pageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.WizardPage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WizardPageItemProvider wizardPageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.WizardPage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWizardPageAdapter() {
		if (wizardPageItemProvider == null) {
			wizardPageItemProvider = new WizardPageItemProvider(this);
		}

		return wizardPageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.MessageDialog} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageDialogItemProvider messageDialogItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.MessageDialog}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMessageDialogAdapter() {
		if (messageDialogItemProvider == null) {
			messageDialogItemProvider = new MessageDialogItemProvider(this);
		}

		return messageDialogItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.RadioButton} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RadioButtonItemProvider radioButtonItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.RadioButton}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRadioButtonAdapter() {
		if (radioButtonItemProvider == null) {
			radioButtonItemProvider = new RadioButtonItemProvider(this);
		}

		return radioButtonItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.GridLayout} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GridLayoutItemProvider gridLayoutItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.GridLayout}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGridLayoutAdapter() {
		if (gridLayoutItemProvider == null) {
			gridLayoutItemProvider = new GridLayoutItemProvider(this);
		}

		return gridLayoutItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ui.GridData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GridDataItemProvider gridDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ui.GridData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGridDataAdapter() {
		if (gridDataItemProvider == null) {
			gridDataItemProvider = new GridDataItemProvider(this);
		}

		return gridDataItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory
				.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>)
					|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to
	 * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		if (textItemProvider != null)
			textItemProvider.dispose();
		if (stackPanelItemProvider != null)
			stackPanelItemProvider.dispose();
		if (separatorItemProvider != null)
			separatorItemProvider.dispose();
		if (labelItemProvider != null)
			labelItemProvider.dispose();
		if (imageItemProvider != null)
			imageItemProvider.dispose();
		if (windowItemProvider != null)
			windowItemProvider.dispose();
		if (buttonItemProvider != null)
			buttonItemProvider.dispose();
		if (comboItemProvider != null)
			comboItemProvider.dispose();
		if (groupBoxItemProvider != null)
			groupBoxItemProvider.dispose();
		if (booleanButtonItemProvider != null)
			booleanButtonItemProvider.dispose();
		if (selectorItemProvider != null)
			selectorItemProvider.dispose();
		if (listViewItemProvider != null)
			listViewItemProvider.dispose();
		if (finderItemProvider != null)
			finderItemProvider.dispose();
		if (menuItemItemProvider != null)
			menuItemItemProvider.dispose();
		if (containerItemProvider != null)
			containerItemProvider.dispose();
		if (viewPartItemProvider != null)
			viewPartItemProvider.dispose();
		if (sashFromItemProvider != null)
			sashFromItemProvider.dispose();
		if (uiEventItemProvider != null)
			uiEventItemProvider.dispose();
		if (colorItemProvider != null)
			colorItemProvider.dispose();
		if (fontItemProvider != null)
			fontItemProvider.dispose();
		if (partItemProvider != null)
			partItemProvider.dispose();
		if (propertiesPartItemProvider != null)
			propertiesPartItemProvider.dispose();
		if (propertyTabItemProvider != null)
			propertyTabItemProvider.dispose();
		if (tabItemProvider != null)
			tabItemProvider.dispose();
		if (tabSetItemProvider != null)
			tabSetItemProvider.dispose();
		if (tableItemProvider != null)
			tableItemProvider.dispose();
		if (richTextItemProvider != null)
			richTextItemProvider.dispose();
		if (dateTimePickerItemProvider != null)
			dateTimePickerItemProvider.dispose();
		if (hyperlinkItemProvider != null)
			hyperlinkItemProvider.dispose();
		if (pageItemProvider != null)
			pageItemProvider.dispose();
		if (wizardPageItemProvider != null)
			wizardPageItemProvider.dispose();
		if (messageDialogItemProvider != null)
			messageDialogItemProvider.dispose();
		if (radioButtonItemProvider != null)
			radioButtonItemProvider.dispose();
		if (gridLayoutItemProvider != null)
			gridLayoutItemProvider.dispose();
		if (gridDataItemProvider != null)
			gridDataItemProvider.dispose();
	}

}
