/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.junit.JUnitMessages;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

public class JUnit5TestFinder
implements ITestFinder {
    @Override
    public void findTestsInContainer(IJavaElement element, Set<IType> result, IProgressMonitor pm) throws CoreException {
        IType type;
        if (element == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (element instanceof IType && this.internalIsTest(type = (IType)element, pm)) {
            result.add(type);
            return;
        }
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        try {
            IType[] allClasses;
            pm.beginTask(JUnitMessages.JUnit5TestFinder_searching_description, 4);
            IRegion region = CoreTestSearchEngine.getRegion(element);
            ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IType[] iTypeArray = allClasses = hierarchy.getAllClasses();
            int n = allClasses.length;
            int n2 = 0;
            while (n2 < n) {
                IType type2 = iTypeArray[n2];
                if (this.internalIsTest(type2, pm) && region.contains((IJavaElement)type2)) {
                    this.addTypeAndSubtypes(type2, result, hierarchy);
                }
                ++n2;
            }
            IType testInterface = element.getJavaProject().findType("junit.framework.Test");
            if (testInterface != null) {
                CoreTestSearchEngine.findTestImplementorClasses(hierarchy, testInterface, region, result);
            }
            CoreTestSearchEngine.findSuiteMethods(element, result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        finally {
            pm.done();
        }
    }

    private void addTypeAndSubtypes(IType type, Set<IType> result, ITypeHierarchy hierarchy) {
        if (result.add(type)) {
            IType[] subclasses = hierarchy.getSubclasses(type);
            int i = 0;
            while (i < subclasses.length) {
                this.addTypeAndSubtypes(subclasses[i], result, hierarchy);
                ++i;
            }
        }
    }

    @Override
    public boolean isTest(IType type) throws JavaModelException {
        return this.internalIsTest(type, null);
    }

    private boolean internalIsTest(IType type, IProgressMonitor monitor) throws JavaModelException {
        if (CoreTestSearchEngine.isAccessibleClass(type, "org.eclipse.jdt.junit.loader.junit5")) {
            ITypeBinding binding;
            if (CoreTestSearchEngine.hasSuiteMethod(type)) {
                return true;
            }
            ASTParser parser = ASTParser.newParser((int)12);
            if (type.getCompilationUnit() != null) {
                parser.setSource(type.getCompilationUnit());
            } else {
                if (!JUnit5TestFinder.isAvailable(type.getSourceRange())) {
                    parser.setProject(type.getJavaProject());
                    IBinding[] bindings = parser.createBindings(new IJavaElement[]{type}, monitor);
                    if (bindings.length == 1 && bindings[0] instanceof ITypeBinding) {
                        ITypeBinding binding2 = (ITypeBinding)bindings[0];
                        return this.isTest(binding2);
                    }
                    return false;
                }
                parser.setSource((IClassFile)type.getClassFile());
            }
            parser.setFocalPosition(0);
            parser.setResolveBindings(true);
            CompilationUnit root = (CompilationUnit)parser.createAST(monitor);
            ASTNode node = root.findDeclaringNode(type.getKey());
            if (node instanceof TypeDeclaration && (binding = ((TypeDeclaration)node).resolveBinding()) != null) {
                return this.isTest(binding);
            }
        }
        return false;
    }

    private static boolean isAvailable(ISourceRange range) {
        return range != null && range.getOffset() != -1;
    }

    private boolean isTest(ITypeBinding binding) {
        if (Modifier.isAbstract((int)binding.getModifiers())) {
            return false;
        }
        if (Annotation.RUN_WITH.annotatesTypeOrSuperTypes(binding) || Annotation.TEST_4.annotatesAtLeastOneMethod(binding) || Annotation.TESTABLE.annotatesAtLeastOneMethod(binding) || Annotation.TESTABLE.annotatesTypeOrSuperTypes(binding) || Annotation.NESTED.annotatesAtLeastOneInnerClass(binding)) {
            return true;
        }
        return CoreTestSearchEngine.isTestImplementor(binding);
    }

    private static class Annotation {
        private static final Annotation RUN_WITH = new Annotation("org.junit.runner.RunWith");
        private static final Annotation TEST_4 = new Annotation("org.junit.Test");
        private static final Annotation TESTABLE = new Annotation("org.junit.platform.commons.annotation.Testable");
        private static final Annotation NESTED = new Annotation("org.junit.jupiter.api.Nested");
        private final String fName;

        private Annotation(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        public boolean annotatesAtLeastOneInnerClass(ITypeBinding type) {
            if (type == null) {
                return false;
            }
            if (this.annotatesDeclaredTypes(type)) {
                return true;
            }
            ITypeBinding superClass = type.getSuperclass();
            if (this.annotatesAtLeastOneInnerClass(superClass)) {
                return true;
            }
            ITypeBinding[] interfaces = type.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (this.annotatesAtLeastOneInnerClass(interfaces[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean annotatesDeclaredTypes(ITypeBinding type) {
            ITypeBinding[] declaredTypes = type.getDeclaredTypes();
            int i = 0;
            while (i < declaredTypes.length) {
                if (this.isNestedClass(declaredTypes[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isNestedClass(ITypeBinding type) {
            int modifiers = type.getModifiers();
            if (type.isInterface() || Modifier.isPrivate((int)modifiers) || Modifier.isStatic((int)modifiers)) {
                return false;
            }
            return this.annotates(type.getAnnotations());
        }

        public boolean annotatesTypeOrSuperTypes(ITypeBinding type) {
            while (type != null) {
                if (this.annotates(type.getAnnotations())) {
                    return true;
                }
                type = type.getSuperclass();
            }
            return false;
        }

        public boolean annotatesAtLeastOneMethod(ITypeBinding type) {
            if (type == null) {
                return false;
            }
            if (this.annotatesDeclaredMethods(type)) {
                return true;
            }
            ITypeBinding superClass = type.getSuperclass();
            if (this.annotatesAtLeastOneMethod(superClass)) {
                return true;
            }
            ITypeBinding[] interfaces = type.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (this.annotatesAtLeastOneMethod(interfaces[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean annotatesDeclaredMethods(ITypeBinding type) {
            IMethodBinding[] declaredMethods = type.getDeclaredMethods();
            int i = 0;
            while (i < declaredMethods.length) {
                IMethodBinding curr = declaredMethods[i];
                if (this.annotates(curr.getAnnotations())) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean annotates(IAnnotationBinding[] annotations) {
            IAnnotationBinding[] iAnnotationBindingArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                if (annotation != null) {
                    HashSet<ITypeBinding> hierarchy;
                    if (this.matchesName(annotation.getAnnotationType())) {
                        return true;
                    }
                    if ((TESTABLE.getName().equals(this.fName) || NESTED.getName().equals(this.fName)) && this.matchesNameInAnnotationHierarchy(annotation, hierarchy = new HashSet<ITypeBinding>())) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }

        private boolean matchesName(ITypeBinding annotationType) {
            String qualifiedName;
            return annotationType != null && (qualifiedName = annotationType.getQualifiedName()).equals(this.fName);
        }

        private boolean matchesNameInAnnotationHierarchy(IAnnotationBinding annotation, Set<ITypeBinding> hierarchy) {
            ITypeBinding type = annotation.getAnnotationType();
            if (type != null) {
                IAnnotationBinding[] iAnnotationBindingArray = type.getAnnotations();
                int n = iAnnotationBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding annotationType;
                    IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
                    if (annotationBinding != null && (annotationType = annotationBinding.getAnnotationType()) != null && hierarchy.add(annotationType) && (this.matchesName(annotationType) || this.matchesNameInAnnotationHierarchy(annotationBinding, hierarchy))) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

