/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.cache;

import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.model.Openable;
import org.eclipse.rcptt.internal.core.model.cache.LRUCache;
import org.eclipse.rcptt.internal.core.model.cache.OverflowingLRUCache;

public class ElementCache
extends OverflowingLRUCache {
    private IQ7Element spaceLimitParent = null;

    public ElementCache(int size) {
        super(size);
    }

    public ElementCache(int size, int overflow) {
        super(size, overflow);
    }

    @Override
    protected boolean close(Object key, Object value) {
        Openable element;
        block3: {
            element = (Openable)key;
            try {
                if (element.canBeRemovedFromCache()) break block3;
                return false;
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        element.close();
        return true;
    }

    public void ensureSpaceLimit(int childrenSize, IQ7Element parent) {
        int spaceNeeded = 1 + (int)((1.0 + this.fLoadFactor) * (double)(childrenSize + this.fOverflow));
        if (this.fSpaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    @Override
    protected LRUCache newInstance(int size, int overflow) {
        return new ElementCache(size, overflow);
    }

    public void resetSpaceLimit(int defaultLimit, IQ7Element parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }

    @Override
    public Object put(Object key, Object value) {
        return super.put(key, value);
    }
}

