/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collections;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class SetBinding<M, T>
extends Binding {
    private UpdateSetStrategy<? super T, ? extends M> targetToModel;
    private UpdateSetStrategy<? super M, ? extends T> modelToTarget;
    private IObservableValue<IStatus> validationStatusObservable;
    private IObservableSet<T> target;
    private IObservableSet<M> model;
    private boolean updatingTarget;
    private boolean updatingModel;
    private ISetChangeListener<T> targetChangeListener = event -> {
        if (!this.updatingTarget) {
            this.doUpdate(this.target, this.model, event.diff, this.targetToModel, false, false);
        }
    };
    private ISetChangeListener<M> modelChangeListener = event -> {
        if (!this.updatingModel) {
            this.doUpdate(this.model, this.target, event.diff, this.modelToTarget, false, false);
        }
    };

    public SetBinding(IObservableSet<T> target, IObservableSet<M> model, UpdateSetStrategy<? super T, ? extends M> targetToModelStrategy, UpdateSetStrategy<? super M, ? extends T> modelToTargetStrategy) {
        super((IObservable)target, (IObservable)model);
        this.target = target;
        this.model = model;
        this.targetToModel = targetToModelStrategy;
        this.modelToTarget = modelToTargetStrategy;
    }

    @Override
    public IObservableValue<IStatus> getValidationStatus() {
        return this.validationStatusObservable;
    }

    @Override
    protected void preInit() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.validationStatusObservable = new WritableValue(this.context.getValidationRealm(), (Object)Status.OK_STATUS, IStatus.class);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    @Override
    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateSetStrategy.POLICY_UPDATE) {
            this.model.getRealm().exec(() -> {
                this.model.addSetChangeListener(this.modelChangeListener);
                this.updateModelToTarget();
            });
        } else {
            this.modelChangeListener = null;
        }
        if (this.targetToModel.getUpdatePolicy() == UpdateSetStrategy.POLICY_UPDATE) {
            this.target.getRealm().exec(() -> {
                this.target.addSetChangeListener(this.targetChangeListener);
                if (this.modelToTarget.getUpdatePolicy() == UpdateSetStrategy.POLICY_NEVER) {
                    this.updateTargetToModel();
                } else {
                    this.validateTargetToModel();
                }
            });
        } else {
            this.targetChangeListener = null;
        }
    }

    @Override
    public void updateModelToTarget() {
        this.model.getRealm().exec(() -> {
            SetDiff diff = Diffs.computeSetDiff(Collections.emptySet(), this.model);
            this.doUpdate(this.model, this.target, diff, this.modelToTarget, true, true);
        });
    }

    @Override
    public void updateTargetToModel() {
        this.target.getRealm().exec(() -> {
            SetDiff diff = Diffs.computeSetDiff(Collections.emptySet(), this.target);
            this.doUpdate(this.target, this.model, diff, this.targetToModel, true, true);
        });
    }

    @Override
    public void validateModelToTarget() {
    }

    @Override
    public void validateTargetToModel() {
    }

    private <S, D1, D2 extends D1> void doUpdate(IObservableSet<S> source, IObservableSet<D1> destination, SetDiff<? extends S> diff, UpdateSetStrategy<? super S, D2> updateSetStrategy, boolean explicit, boolean clearDestination) {
        int policy = updateSetStrategy.getUpdatePolicy();
        if (policy == UpdateSetStrategy.POLICY_NEVER) {
            return;
        }
        if (policy == UpdateSetStrategy.POLICY_ON_REQUEST && !explicit) {
            return;
        }
        if (!destination.getRealm().isCurrent()) {
            diff.getAdditions();
            diff.getRemovals();
        }
        destination.getRealm().exec(() -> {
            block13: {
                if (destination == this.target) {
                    this.updatingTarget = true;
                } else {
                    this.updatingModel = true;
                }
                BindingStatus multiStatus = BindingStatus.ok();
                try {
                    try {
                        if (clearDestination) {
                            destination.clear();
                        }
                        for (Object element : diff.getRemovals()) {
                            IStatus setterStatus1 = updateSetStrategy.doRemove(destination, updateSetStrategy.convert(element));
                            this.mergeStatus(multiStatus, setterStatus1);
                        }
                        for (Object element : diff.getAdditions()) {
                            IStatus setterStatus2 = updateSetStrategy.doAdd(destination, updateSetStrategy.convert(element));
                            this.mergeStatus(multiStatus, setterStatus2);
                        }
                    }
                    catch (Exception ex) {
                        String message = ex.getMessage() != null ? ex.getMessage() : "";
                        multiStatus.add((IStatus)new Status(4, "org.eclipse.core.databinding", 4, message, (Throwable)ex));
                        this.setValidationStatus((IStatus)multiStatus);
                        if (destination == this.target) {
                            this.updatingTarget = false;
                            break block13;
                        }
                        this.updatingModel = false;
                    }
                }
                finally {
                    this.setValidationStatus((IStatus)multiStatus);
                    if (destination == this.target) {
                        this.updatingTarget = false;
                    } else {
                        this.updatingModel = false;
                    }
                }
            }
        });
    }

    private void setValidationStatus(IStatus status) {
        this.validationStatusObservable.getRealm().exec(() -> this.validationStatusObservable.setValue((Object)status));
    }

    void mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
        }
    }

    @Override
    public void dispose() {
        if (this.targetChangeListener != null) {
            this.target.removeSetChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            this.model.removeSetChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        super.dispose();
    }
}

