/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.runner.junit3;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jdt.internal.junit.runner.FailuresFirstPrioritizer;
import org.eclipse.jdt.internal.junit.runner.ITestLoader;
import org.eclipse.jdt.internal.junit.runner.ITestPrioritizer;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.JUnitMessages;
import org.eclipse.jdt.internal.junit.runner.NullPrioritizer;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.junit3.JUnit3TestReference;

public class JUnit3TestLoader
implements ITestLoader {
    private static final String SUITE_METHODNAME = "suite";
    public static final String SET_UP_TEST_METHOD_NAME = "setUpTest";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ITestReference[] loadTests(Class[] testClasses, String testName, String[] failureNames, String[] packages, String[][] includeExcludeTags, String uniqueId, RemoteTestRunner listener) {
        ITestReference[] suites = new ITestReference[testClasses.length];
        ITestPrioritizer prioritizer = failureNames != null ? new FailuresFirstPrioritizer(failureNames) : new NullPrioritizer();
        int i = 0;
        while (i < suites.length) {
            Class testClassName = testClasses[i];
            Test test = this.getTest(testClassName, testName, listener);
            prioritizer.prioritize(test);
            suites[i] = new JUnit3TestReference(test);
            ++i;
        }
        return suites;
    }

    private Test createTest(String testName, Class testClass) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classArgs = classArray;
        Constructor constructor = null;
        try {
            Test test;
            block13: {
                try {
                    constructor = testClass.getConstructor(classArgs);
                    test = (Test)constructor.newInstance(testName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    constructor = testClass.getConstructor(new Class[0]);
                    test = (Test)constructor.newInstance(new Object[0]);
                    if (!(test instanceof TestCase)) break block13;
                    ((TestCase)test).setName(testName);
                }
            }
            if (test != null) {
                return test;
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassCastException classCastException) {}
        return this.error(testName, "Could not create test '" + testName + "' ");
    }

    public Test getTest(Class testClass, String testName, RemoteTestRunner failureListener) {
        if (testName != null) {
            return this.setupTest(testClass, this.createTest(testName, testClass), testName);
        }
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            return new TestSuite(testClass);
        }
        if (!Modifier.isStatic(suiteMethod.getModifiers())) {
            return this.error(JUnitMessages.getString("RemoteTestRunner.error"), JUnitMessages.getString("RemoteTestRunner.error.suite.notstatic"));
        }
        try {
            Test test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            if (test != null) {
                return test;
            }
            return this.error(JUnitMessages.getString("RemoteTestRunner.error"), JUnitMessages.getString("RemoteTestRunner.error.suite.nullreturn"));
        }
        catch (InvocationTargetException e) {
            String message = JUnitMessages.getFormattedString("RemoteTestRunner.error.invoke", e.getTargetException().toString());
            failureListener.runFailed(message, e);
            return new TestSuite(testClass);
        }
        catch (IllegalAccessException e) {
            String message = JUnitMessages.getFormattedString("RemoteTestRunner.error.invoke", e.toString());
            failureListener.runFailed(message, e);
            return new TestSuite(testClass);
        }
    }

    private Test setupTest(Class reloadedTestClass, Test reloadedTest, String testName) {
        if (reloadedTestClass == null) {
            return reloadedTest;
        }
        Method setup = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("junit.framework.Test");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            setup = reloadedTestClass.getMethod(SET_UP_TEST_METHOD_NAME, classArray);
        }
        catch (SecurityException securityException) {
            return reloadedTest;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return reloadedTest;
        }
        Class<?> clazz = setup.getReturnType();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("junit.framework.Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz != clazz2) {
            return this.error(testName, JUnitMessages.getString("RemoteTestRunner.error.notestreturn"));
        }
        if (!Modifier.isPublic(setup.getModifiers())) {
            return this.error(testName, JUnitMessages.getString("RemoteTestRunner.error.shouldbepublic"));
        }
        if (!Modifier.isStatic(setup.getModifiers())) {
            return this.error(testName, JUnitMessages.getString("RemoteTestRunner.error.shouldbestatic"));
        }
        try {
            Test test = (Test)setup.invoke(null, reloadedTest);
            if (test == null) {
                return this.error(testName, JUnitMessages.getString("RemoteTestRunner.error.nullreturn"));
            }
            return test;
        }
        catch (IllegalArgumentException e) {
            return this.error(testName, JUnitMessages.getFormattedString("RemoteTestRunner.error.couldnotinvoke", e));
        }
        catch (IllegalAccessException e) {
            return this.error(testName, JUnitMessages.getFormattedString("RemoteTestRunner.error.couldnotinvoke", e));
        }
        catch (InvocationTargetException e) {
            return this.error(testName, JUnitMessages.getFormattedString("RemoteTestRunner.error.invocationexception", e.getTargetException()));
        }
    }

    private Test error(String testName, final String message) {
        return new TestCase(testName){

            protected void runTest() {
                1.fail((String)message);
            }
        };
    }
}

