/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.ArrayList;
import java.util.EventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientRule;
import org.eclipse.scout.rt.client.ClientSessionThreadLocal;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.IClientSessionProvider;
import org.eclipse.scout.rt.client.IJobChangeListenerEx;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class ClientJob
extends JobEx
implements IClientSessionProvider {
    private final IClientSession m_session;
    private final EventListenerList m_listeners;
    private final Object m_waitForLock;
    private boolean m_waitFor;

    public ClientJob(String name, IClientSession session, boolean sync) {
        this(name, session, sync, true);
    }

    public ClientJob(String name, IClientSession session, boolean sync, boolean system) {
        super(name);
        if (session == null) {
            throw new IllegalArgumentException("session is null");
        }
        this.m_session = session;
        this.m_listeners = new EventListenerList();
        this.setUser(false);
        this.setSystem(system);
        this.setProperty(ScoutTexts.JOB_PROPERTY_NAME, this.m_session.getNlsTexts());
        this.m_waitForLock = new Object();
        if (sync) {
            this.setRule(new ClientRule(session));
        }
    }

    @Override
    public IClientSession getClientSession() {
        return this.m_session;
    }

    public boolean belongsTo(Object family) {
        return family == ClientJob.class;
    }

    public final boolean isSync() {
        return this.getRule() instanceof ClientRule;
    }

    public final void setSync(boolean sync) {
        if (sync != this.isSync()) {
            if (this.getState() != 0) {
                throw new IllegalStateException("sync property cannot be changed once the job is scheduled");
            }
            if (sync) {
                this.setRule(new ClientRule(this.m_session));
            } else {
                this.setRule(null);
            }
        }
    }

    public final boolean isWaitFor() {
        return this.m_waitFor;
    }

    public boolean shouldSchedule() {
        if (this.getClientSession() != null && this.getClientSession().isSingleThreadSession()) {
            this.runNow((IProgressMonitor)new NullProgressMonitor());
            return false;
        }
        return super.shouldSchedule();
    }

    public final IStatus runNow(IProgressMonitor monitor) {
        IStatus status = null;
        try {
            ClientSessionThreadLocal.set(this.getClientSession());
            status = super.runNow(monitor);
        }
        finally {
            ClientSessionThreadLocal.set(null);
        }
        return status;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.runVoid(monitor);
            return Status.OK_STATUS;
        }
        catch (Throwable t) {
            return new Status(4, "<none>", 0, t.getMessage(), t);
        }
    }

    protected void runVoid(IProgressMonitor monitor) throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitFor() throws InterruptedException {
        ClientRule rule = this.getRule() instanceof ClientRule ? (ClientRule)this.getRule() : null;
        this.fireBlockingConditionStart();
        Object object = this.m_waitForLock;
        synchronized (object) {
            if (rule != null) {
                rule.setEnabled(false);
                this.rescheduleWaitingSyncJobs();
            }
            this.m_waitFor = true;
            this.scheduleDummyJob();
            this.m_waitForLock.wait();
        }
        this.m_waitFor = false;
        this.fireBlockingConditionEnd();
        this.scheduleDummyJob();
    }

    void releaseWaitFor() throws InterruptedException {
        ClientRule rule;
        ClientRule clientRule = rule = this.getRule() instanceof ClientRule ? (ClientRule)this.getRule() : null;
        if (rule != null) {
            ClientSyncJob proxyJob = new ClientSyncJob("release waitFor lock on \"" + this + "\"", this.m_session){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void runVoid(IProgressMonitor arg0) throws Throwable {
                    rule.setEnabled(true);
                    ClientJob.this.rescheduleWaitingSyncJobs();
                    Object object = ClientJob.this.m_waitForLock;
                    synchronized (object) {
                        ClientJob.this.m_waitForLock.notifyAll();
                    }
                }
            };
            proxyJob.schedule();
        }
    }

    private void rescheduleWaitingSyncJobs() {
        ArrayList<Job> jobList = new ArrayList<Job>();
        Job[] jobArray = Job.getJobManager().find(ClientJob.class);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientJob c;
            Job j = jobArray[n2];
            if (j instanceof ClientJob && (c = (ClientJob)j).isSync() && !c.isWaitFor() && c.getState() == 2) {
                jobList.add(j);
            }
            ++n2;
        }
        int i = jobList.size() - 1;
        while (i >= 0) {
            Job j = (Job)jobList.get(i);
            if (!j.sleep()) {
                jobList.remove(i);
            }
            --i;
        }
        for (Job j : jobList) {
            j.wakeUp();
        }
    }

    private void scheduleDummyJob() {
        new ClientAsyncJob("Dummy", this.m_session).schedule();
    }

    public final void addJobChangeListenerEx(IJobChangeListenerEx listener) {
        this.addJobChangeListener(listener);
        this.m_listeners.add(IJobChangeListenerEx.class, (EventListener)listener);
    }

    public final void removeJobChangeListenerEx(IJobChangeListenerEx listener) {
        this.removeJobChangeListener(listener);
        this.m_listeners.remove(IJobChangeListenerEx.class, (EventListener)listener);
    }

    private void fireBlockingConditionStart() {
        JobChangeEventEx e = new JobChangeEventEx((Job)this);
        IJobChangeListenerEx[] iJobChangeListenerExArray = (IJobChangeListenerEx[])this.m_listeners.getListeners(IJobChangeListenerEx.class);
        int n = iJobChangeListenerExArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJobChangeListenerEx listener = iJobChangeListenerExArray[n2];
            try {
                listener.blockingConditionStart(e);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++n2;
        }
    }

    private void fireBlockingConditionEnd() {
        JobChangeEventEx e = new JobChangeEventEx((Job)this);
        IJobChangeListenerEx[] iJobChangeListenerExArray = (IJobChangeListenerEx[])this.m_listeners.getListeners(IJobChangeListenerEx.class);
        int n = iJobChangeListenerExArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJobChangeListenerEx listener = iJobChangeListenerExArray[n2];
            try {
                listener.blockingConditionEnd(e);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++n2;
        }
    }

    public static final IClientSession getCurrentSession() {
        return ClientJob.getCurrentSession(IClientSession.class);
    }

    public static final boolean isSyncClientJob() {
        Job j = Job.getJobManager().currentJob();
        return j instanceof ClientJob && ((ClientJob)j).isSync();
    }

    public static final <T extends IClientSession> T getCurrentSession(Class<T> type) {
        IClientSession s;
        Job job = ClientJob.getJobManager().currentJob();
        if (job instanceof IClientSessionProvider && (s = ((IClientSessionProvider)job).getClientSession()) != null && type.isAssignableFrom(s.getClass())) {
            return (T)s;
        }
        return (T)ClientSessionThreadLocal.get();
    }

    private static class JobChangeEventEx
    implements IJobChangeEvent {
        Job job = null;

        public JobChangeEventEx(Job job) {
            this.job = job;
        }

        public long getDelay() {
            return 0L;
        }

        public Job getJob() {
            return this.job;
        }

        public IStatus getResult() {
            return null;
        }
    }
}

