/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.test;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.BlockingCondition;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractSearchForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.AbstractBigDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.osgi.framework.Bundle;

public final class ClientTestUtility {
    private ClientTestUtility() {
    }

    public static void sleep(int seconds) {
        if (seconds <= 0) {
            return;
        }
        final BlockingCondition bc = new BlockingCondition(true);
        new ClientSyncJob("sleep", ClientSyncJob.getCurrentSession()){

            @Override
            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                bc.release();
            }
        }.schedule(1000L * (long)seconds);
        try {
            bc.waitFor();
        }
        catch (InterruptedException interruptedException) {}
    }

    public static String getNowAsString() {
        return "" + new Date();
    }

    public static Date getNowAsDate() {
        return new Date();
    }

    public static void searchEntityInOutline(AbstractPageWithTable<?> p, String formDataFieldId, long value) throws ProcessingException {
        AbstractSearchForm searchForm = (AbstractSearchForm)p.getSearchFormInternal();
        searchForm.rebuildSearchFilter();
        SearchFilter f = searchForm.getSearchFilter();
        f.clear();
        ((AbstractValueFieldData)f.getFormData().getFieldById(formDataFieldId)).setValue((Object)value);
        f.setCompleted(true);
        p.getSearchFormInternal().doReset();
        p.reloadPage();
    }

    public static void searchEntityInOutline(AbstractPageWithTable<?> p, String formDataFieldId, String value) throws ProcessingException {
        AbstractSearchForm searchForm = (AbstractSearchForm)p.getSearchFormInternal();
        searchForm.rebuildSearchFilter();
        SearchFilter f = searchForm.getSearchFilter();
        f.clear();
        ((AbstractValueFieldData)f.getFormData().getFieldById(formDataFieldId)).setValue((Object)value);
        f.setCompleted(true);
        p.getSearchFormInternal().doReset();
        p.reloadPage();
    }

    public static IClientSession getClientSession() {
        return ClientSyncJob.getCurrentSession();
    }

    public static Bundle getClientBundle() {
        return ClientSyncJob.getCurrentSession().getBundle();
    }

    public static IDesktop getDesktop() {
        return ClientSyncJob.getCurrentSession().getDesktop();
    }

    public static String getFormsPackage() {
        return String.valueOf(ClientTestUtility.getClientBundle().getSymbolicName()) + ".ui.forms";
    }

    public static IPage gotoOutline(Class<? extends AbstractOutline> outlineClass) {
        IOutline[] availableOutlines;
        IPage rootPage = null;
        IOutline[] iOutlineArray = availableOutlines = ClientTestUtility.getDesktop().getAvailableOutlines();
        int n = availableOutlines.length;
        int n2 = 0;
        while (n2 < n) {
            IOutline outline = iOutlineArray[n2];
            if (outline.getClass().isAssignableFrom(outlineClass)) {
                ClientTestUtility.getDesktop().setOutline(outline);
                System.out.println("Selected Outline: " + outline.getTitle());
                outline.releaseUnusedPages();
                rootPage = outline.getRootPage();
            }
            ++n2;
        }
        return rootPage;
    }

    public static <T extends IPage> T gotoChildPage(IPage parentPage, Class<T> childPageClass) {
        IPage[] childPages;
        IPage childPage = null;
        IPage[] iPageArray = childPages = parentPage.getChildPages();
        int n = childPages.length;
        int n2 = 0;
        while (n2 < n) {
            IPage page = iPageArray[n2];
            if (childPageClass.isAssignableFrom(page.getClass())) {
                IOutline outline = ClientTestUtility.getDesktop().getOutline();
                outline.selectNode(page);
                System.out.println("Selected Page: " + page);
                outline.releaseUnusedPages();
                childPage = page;
            }
            ++n2;
        }
        return (T)childPage;
    }

    public static <T extends IPage> T gotoChildPage(Class<T> childPageClass) {
        IPage selectedNode = ClientTestUtility.getDesktop().getOutline().getActivePage();
        return ClientTestUtility.gotoChildPage(selectedNode, childPageClass);
    }

    public static void fillForm(AbstractForm form, long testNr) throws ProcessingException {
        IFormField[] iFormFieldArray = form.getAllFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField formField = iFormFieldArray[n2];
            if (formField.isEnabled() && formField.isVisible() && formField instanceof AbstractValueField && ((AbstractValueField)formField).getValue() == null) {
                LookupRow[] rs;
                LookupCall lookupCall;
                if (formField instanceof AbstractStringField) {
                    ((AbstractStringField)formField).setValue("test " + testNr);
                } else if (formField instanceof AbstractSmartField) {
                    lookupCall = null;
                    if (((AbstractSmartField)formField).getLookupCall() != null) {
                        lookupCall = ((AbstractSmartField)formField).getLookupCall();
                        ((AbstractSmartField)formField).prepareKeyLookup(lookupCall, null);
                        ((AbstractSmartField)formField).prepareTextLookup(lookupCall, "abc");
                        ((AbstractSmartField)formField).prepareBrowseLookup(lookupCall, "abc", TriState.TRUE);
                    } else if (((AbstractSmartField)formField).getCodeTypeClass() != null) {
                        lookupCall = new CodeLookupCall(((AbstractSmartField)formField).getCodeTypeClass());
                    }
                    if (lookupCall == null) {
                        System.out.println("WARNING: Lookup Call for Field " + formField.getFieldId() + "is null!");
                    } else {
                        lookupCall.setActive(TriState.TRUE);
                        lookupCall.setMaxRowCount(100);
                        lookupCall.getDataByKey();
                        lookupCall.getDataByText();
                        rs = lookupCall.getDataByAll();
                        if (rs.length > 0) {
                            ((AbstractSmartField)formField).setValue(rs[0].getKey());
                        }
                    }
                } else if (formField instanceof AbstractNumberField) {
                    ((AbstractNumberField)formField).setValue(42L);
                } else if (formField instanceof AbstractBigDecimalField) {
                    ((AbstractBigDecimalField)formField).setValue(BigDecimal.valueOf(42.42));
                } else if (formField instanceof AbstractDateField) {
                    ((AbstractDateField)formField).setValue(new Date());
                } else if (formField instanceof AbstractListBox) {
                    lookupCall = null;
                    if (((AbstractListBox)formField).getLookupCall() != null) {
                        lookupCall = ((AbstractListBox)formField).getLookupCall();
                        ((AbstractListBox)formField).prepareLookupCall(lookupCall);
                    } else if (((AbstractListBox)formField).getCodeTypeClass() != null) {
                        lookupCall = new CodeLookupCall(((AbstractListBox)formField).getCodeTypeClass());
                    }
                    if (lookupCall == null) {
                        System.out.println("WARNING: Lookup Call for Field " + formField.getFieldId() + "is null!");
                    } else {
                        lookupCall.setActive(TriState.TRUE);
                        lookupCall.setMaxRowCount(100);
                        lookupCall.getDataByKey();
                        lookupCall.getDataByText();
                        rs = lookupCall.getDataByAll();
                        if (rs.length > 0 && ((AbstractListBox)formField).getCheckedKeyCount() == 0) {
                            ((AbstractListBox)formField).checkKey(rs[0].getKey());
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

