/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityCell;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityMapEvent;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityMapListener;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityCellObserver;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMapUIFacade;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MajorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MinorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MultiTimeRange;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeRange;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeScale;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeScaleBuilder;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractActivityMap
extends AbstractPropertyObserver
implements IActivityMap {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractActivityMap.class);
    private EventListenerList m_listenerList;
    private IActivityMapUIFacade m_activityMapUIFacade;
    private long m_minimumActivityDuration;
    private HashMap<Long, List<ActivityCell>> m_resourceIdToActivities;
    private HashMap<CompositeLong, ActivityCell> m_activities;
    private HashSet<Long> m_selectedResourceIds;
    private int m_tableChanging;
    private ArrayList<ActivityMapEvent> m_eventBuffer = new ArrayList();
    private IMenu[] m_menus;
    private IActivityCellObserver m_cellObserver;
    private boolean m_timeScaleValid;

    public AbstractActivityMap() {
        this.initConfig();
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=20.0)
    @ConfigPropertyValue(value="5")
    protected int getConfiguredWorkDayCount() {
        return 5;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredWorkDaysOnly() {
        return false;
    }

    @ConfigProperty(value="HOUR_OF_DAY")
    @Order(value=110.0)
    @ConfigPropertyValue(value="8")
    protected int getConfiguredFirstHourOfDay() {
        return 8;
    }

    @ConfigProperty(value="HOUR_OF_DAY")
    @Order(value=130.0)
    @ConfigPropertyValue(value="16")
    protected int getConfiguredLastHourOfDay() {
        return 16;
    }

    @ConfigProperty(value="DURATION_MINUTES")
    @Order(value=120.0)
    @ConfigPropertyValue(value="1800000L")
    protected long getConfiguredIntradayInterval() {
        return 1800000L;
    }

    @ConfigProperty(value="DURATION_MINUTES")
    @Order(value=125.0)
    @ConfigPropertyValue(value="1800000L")
    protected long getConfiguredMinimumActivityDuration() {
        return 1800000L;
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execDecorateActivityCell(ActivityCell cell) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execActivityCellSelected(ActivityCell cell) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=75.0)
    protected void execCellAction(long resourceId, MinorTimeColumn column, ActivityCell activityCell) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execInitActivityMap() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execDisposeActivityMap() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=100.0)
    protected TimeScale execCreateTimeScale() throws ProcessingException {
        return new TimeScaleBuilder(this).build();
    }

    @ConfigOperation
    @Order(value=110.0)
    protected void execDecorateMajorTimeColumn(TimeScale scale, MajorTimeColumn columns) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execDecorateMinorTimeColumn(TimeScale scale, MajorTimeColumn majorColumn, MinorTimeColumn minorColumn) throws ProcessingException {
    }

    protected void initConfig() {
        this.m_listenerList = new EventListenerList();
        this.m_activityMapUIFacade = this.createUIFacade();
        this.m_resourceIdToActivities = new HashMap();
        this.m_activities = new HashMap();
        this.m_cellObserver = new P_ActivityCellObserver();
        this.m_selectedResourceIds = new HashSet();
        this.setWorkDayCount(this.getConfiguredWorkDayCount());
        this.setWorkDaysOnly(this.getConfiguredWorkDaysOnly());
        this.setFirstHourOfDay(this.getConfiguredFirstHourOfDay());
        this.setIntradayInterval(this.getConfiguredIntradayInterval());
        this.setMinimumActivityDuration(this.getConfiguredMinimumActivityDuration());
        this.setLastHourOfDay(this.getConfiguredLastHourOfDay());
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class<? extends IMenu>[] ma = this.getConfiguredMenus();
        int i = 0;
        while (i < ma.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, ma[i]);
                menuList.add(menu);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        this.m_menus = menuList.toArray(new IMenu[0]);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ActivityCell cell;
                if (e.getPropertyName().equals("days")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("firstHourOfDay")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("lastHourOfDay")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("intradayInterval")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("planningMode")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("selectedActivityCell") && (cell = (ActivityCell)((Object)e.getNewValue())) != null) {
                    try {
                        AbstractActivityMap.this.execActivityCellSelected(cell);
                    }
                    catch (ProcessingException t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(t);
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                    }
                }
            }
        });
        this.createTimeScale();
    }

    protected IActivityMapUIFacade createUIFacade() {
        return new P_ActivityMapUIFacade();
    }

    @Override
    public final void initActivityMap() throws ProcessingException {
        this.initActivityMapInternal();
        this.execInitActivityMap();
    }

    protected void initActivityMapInternal() throws ProcessingException {
    }

    @Override
    public final void disposeActivityMap() {
        this.disposeActivityMapInternal();
        try {
            this.execDisposeActivityMap();
        }
        catch (Throwable t) {
            LOG.warn(this.getClass().getName(), t);
        }
    }

    protected void disposeActivityMapInternal() {
    }

    private void invalidateTimeScale() {
        this.m_timeScaleValid = false;
    }

    private void validateTimeScale() {
        if (!this.m_timeScaleValid) {
            this.m_timeScaleValid = true;
            this.createTimeScale();
        }
    }

    @Override
    public void createTimeScale() {
        try {
            TimeScale scale = this.execCreateTimeScale();
            this.setTimeScale(scale);
        }
        catch (ProcessingException t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(t);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
    }

    @Override
    public TimeScale getTimeScale() {
        TimeScale scale = (TimeScale)this.propertySupport.getProperty("timeScale");
        if (scale == null) {
            scale = new TimeScale();
        }
        return scale;
    }

    @Override
    public void setTimeScale(TimeScale scale) {
        if (scale == null) {
            scale = new TimeScale();
        }
        this.propertySupport.setProperty("timeScale", (Object)scale);
    }

    @Override
    public void addActivityMapListener(ActivityMapListener listener) {
        this.m_listenerList.add(ActivityMapListener.class, (EventListener)listener);
    }

    @Override
    public void removeActivityMapListener(ActivityMapListener listener) {
        this.m_listenerList.remove(ActivityMapListener.class, (EventListener)listener);
    }

    @Override
    public ActivityCell resolveActivityCell(ActivityCell cell) {
        if (cell == null) {
            return cell;
        }
        return this.m_activities.get(new CompositeLong(cell.getResourceId(), cell.getActivityId()));
    }

    @Override
    public ActivityCell[] resolveActivityCells(ActivityCell[] cells) {
        if (cells == null) {
            cells = new ActivityCell[]{};
        }
        int mismatchCount = 0;
        int i = 0;
        while (i < cells.length) {
            if (this.resolveActivityCell(cells[i]) != cells[i]) {
                LOG.warn("could not resolve " + (Object)((Object)cells[i]));
                ++mismatchCount;
            }
            ++i;
        }
        if (mismatchCount > 0) {
            ActivityCell[] resolvedCells = new ActivityCell[cells.length - mismatchCount];
            int index = 0;
            int i2 = 0;
            while (i2 < cells.length) {
                if (this.resolveActivityCell(cells[i2]) == cells[i2]) {
                    resolvedCells[index] = cells[i2];
                    ++index;
                }
                ++i2;
            }
            cells = resolvedCells;
        }
        return cells;
    }

    @Override
    public ActivityCell[] getActivityCells(long resourceId) {
        return this.getActivityCells(new Long[]{resourceId});
    }

    @Override
    public ActivityCell[] getActivityCells(Long[] resourceIds) {
        ArrayList<ActivityCell> all = new ArrayList<ActivityCell>();
        Long[] longArray = resourceIds;
        int n = resourceIds.length;
        int n2 = 0;
        while (n2 < n) {
            Long resourceId = longArray[n2];
            List<ActivityCell> list = this.m_resourceIdToActivities.get(resourceId);
            if (list != null) {
                all.addAll(list);
            }
            ++n2;
        }
        return all.toArray(new ActivityCell[all.size()]);
    }

    @Override
    public ActivityCell[] getAllActivityCells() {
        return this.m_activities.values().toArray(new ActivityCell[this.m_activities.size()]);
    }

    @Override
    public void addActivityCells(ActivityCell[] cells) {
        ArrayList<ActivityCell> addedCells = new ArrayList<ActivityCell>();
        ActivityCell[] activityCellArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityCell cell = activityCellArray[n2];
            CompositeLong key = new CompositeLong(cell.getResourceId(), cell.getActivityId());
            if (!this.m_activities.containsKey(key)) {
                this.m_activities.put(key, cell);
                List<ActivityCell> list = this.m_resourceIdToActivities.get(cell.getResourceId());
                if (list == null) {
                    list = new ArrayList<ActivityCell>();
                    this.m_resourceIdToActivities.put(cell.getResourceId(), list);
                }
                list.add(cell);
                addedCells.add(cell);
                this.decorateActivityCell(cell);
                cell.setObserver(this.m_cellObserver);
            }
            ++n2;
        }
        if (addedCells.size() > 0) {
            this.fireActivitiesInserted(addedCells.toArray(new ActivityCell[addedCells.size()]));
        }
    }

    @Override
    public void updateActivityCells(ActivityCell[] cells) {
        cells = this.resolveActivityCells(cells);
        this.updateActivityCellsInternal(cells);
    }

    @Override
    public void updateActivityCells(Long[] resourceIds) {
        this.updateActivityCellsInternal(this.getActivityCells(resourceIds));
    }

    private void updateActivityCellsInternal(ActivityCell[] cells) {
        ActivityCell[] activityCellArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityCell cell = activityCellArray[n2];
            this.decorateActivityCell(cell);
            ++n2;
        }
        this.fireActivitiesUpdated(cells);
    }

    @Override
    public void removeActivityCells(ActivityCell[] cells) {
        cells = this.resolveActivityCells(cells);
        this.removeActivityCellsInternal(cells);
    }

    @Override
    public void removeActivityCells(Long[] resourceIds) {
        this.removeActivityCellsInternal(this.getActivityCells(resourceIds));
    }

    private void removeActivityCellsInternal(ActivityCell[] cells) {
        if (cells.length > 0) {
            ActivityCell[] activityCellArray = cells;
            int n = cells.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityCell cell = activityCellArray[n2];
                cell.setObserver(null);
                this.m_activities.remove(new CompositeLong(cell.getResourceId(), cell.getActivityId()));
                List<ActivityCell> list = this.m_resourceIdToActivities.get(cell.getResourceId());
                if (list != null) {
                    list.remove((Object)cell);
                }
                ++n2;
            }
            this.fireActivitiesDeleted(cells);
        }
    }

    @Override
    public void removeAllActivityCells() {
        ActivityCell[] a = this.getAllActivityCells();
        if (a.length > 0) {
            ActivityCell[] activityCellArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityCell cell = activityCellArray[n2];
                cell.setObserver(null);
                ++n2;
            }
            this.m_activities.clear();
            this.m_resourceIdToActivities.clear();
            this.fireAllActivitiesDeleted(a);
        }
    }

    @Override
    public ActivityCell getSelectedActivityCell() {
        return (ActivityCell)((Object)this.propertySupport.getProperty("selectedActivityCell"));
    }

    @Override
    public void setSelectedActivityCell(ActivityCell cell) {
        cell = this.resolveActivityCell(cell);
        this.propertySupport.setProperty("selectedActivityCell", (Object)cell);
    }

    @Override
    public boolean isSelectedActivityCell(ActivityCell cell) {
        return this.getSelectedActivityCell() == cell;
    }

    @Override
    public Long[] getSelectedResourceIds() {
        Long[] a = (Long[])this.propertySupport.getProperty("selectedResourceIds");
        if (a == null) {
            a = new Long[]{};
        }
        return a;
    }

    @Override
    public void setSelectedResourceIds(Long[] resourceIds) {
        if (resourceIds == null) {
            resourceIds = new Long[]{};
        }
        this.m_selectedResourceIds.clear();
        this.m_selectedResourceIds.addAll(Arrays.asList(resourceIds));
        this.propertySupport.setProperty("selectedResourceIds", (Object)resourceIds);
    }

    @Override
    public Long[] getResourceIds() {
        Long[] resourceIds = (Long[])this.propertySupport.getProperty("resourceIds");
        if (resourceIds == null) {
            resourceIds = new Long[]{};
        }
        return resourceIds;
    }

    @Override
    public void setResourceIds(Long[] resourceIds) {
        if (resourceIds == null) {
            resourceIds = new Long[]{};
        }
        HashSet<Long> eliminatedResourceIdSet = new HashSet<Long>();
        eliminatedResourceIdSet.addAll(Arrays.asList(this.getResourceIds()));
        eliminatedResourceIdSet.removeAll(Arrays.asList(resourceIds));
        try {
            this.setActivityMapChanging(true);
            this.propertySupport.setProperty("resourceIds", (Object)resourceIds);
            this.removeActivityCells(eliminatedResourceIdSet.toArray(new Long[eliminatedResourceIdSet.size()]));
            this.updateActivityCellsInternal(this.getAllActivityCells());
        }
        finally {
            this.setActivityMapChanging(false);
        }
    }

    @Override
    public void isSelectedResourceId(Long resourceId) {
        this.m_selectedResourceIds.contains(resourceId);
    }

    @Override
    public IMenu[] getMenus() {
        return this.m_menus;
    }

    private IMenu[] fireEditActivityPopup(ActivityCell cell) {
        if (cell != null) {
            ActivityMapEvent e = new ActivityMapEvent((IActivityMap)this, 700, cell);
            this.addEditActivityPopupMenus(e);
            this.fireActivityMapEventInternal(e);
            return e.getPopupMenus();
        }
        return new IMenu[0];
    }

    private void addEditActivityPopupMenus(ActivityMapEvent e) {
        IMenu[] a = this.getMenus();
        int i = 0;
        while (i < a.length) {
            IMenu validMenu = null;
            if (a[i].isSingleSelectionAction()) {
                validMenu = a[i];
            }
            if (validMenu != null) {
                validMenu.prepareAction();
                if (validMenu.isVisible()) {
                    e.addPopupMenu(validMenu);
                }
            }
            ++i;
        }
    }

    private IMenu[] fireNewActivityPopup() {
        ActivityMapEvent e = new ActivityMapEvent(this, 701);
        this.addNewActivityPopupMenus(e);
        this.fireActivityMapEventInternal(e);
        return e.getPopupMenus();
    }

    private void addNewActivityPopupMenus(ActivityMapEvent e) {
        IMenu[] a = this.getMenus();
        int i = 0;
        while (i < a.length) {
            IAction validMenu = null;
            if (!a[i].isSingleSelectionAction() && !a[i].isMultiSelectionAction()) {
                validMenu = a[i];
            }
            if (validMenu != null) {
                validMenu.prepareAction();
                if (validMenu.isVisible()) {
                    e.addPopupMenu((IMenu)validMenu);
                }
            }
            ++i;
        }
    }

    private void fireCellAction(long resourceId, MinorTimeColumn column, ActivityCell activityCell) {
        try {
            this.execCellAction(resourceId, column, activityCell);
        }
        catch (ProcessingException t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(t);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
        ActivityMapEvent e = new ActivityMapEvent(this, 104, resourceId, column, activityCell);
        this.fireActivityMapEventInternal(e);
    }

    private void fireActivitiesInserted(ActivityCell[] a) {
        ActivityMapEvent e = new ActivityMapEvent((IActivityMap)this, 100, a);
        this.fireActivityMapEventInternal(e);
    }

    private void fireActivitiesUpdated(ActivityCell[] a) {
        ActivityMapEvent e = new ActivityMapEvent((IActivityMap)this, 101, a);
        this.fireActivityMapEventInternal(e);
    }

    private void fireActivitiesDeleted(ActivityCell[] a) {
        ActivityMapEvent e = new ActivityMapEvent((IActivityMap)this, 102, a);
        this.fireActivityMapEventInternal(e);
    }

    private void fireAllActivitiesDeleted(ActivityCell[] a) {
        ActivityMapEvent e = new ActivityMapEvent((IActivityMap)this, 105, a);
        this.fireActivityMapEventInternal(e);
    }

    private void fireActivityMapEventInternal(ActivityMapEvent e) {
        if (this.isActivityMapChanging()) {
            this.m_eventBuffer.add(e);
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(ActivityMapListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    ((ActivityMapListener)listeners[i]).activityMapChanged(e);
                    ++i;
                }
            }
        }
    }

    private void fireActivityMapEventBatchInternal(ActivityMapEvent[] batch) {
        EventListener[] listeners;
        if (this.isActivityMapChanging()) {
            LOG.error("Illegal State: firing an event batch while table is changing");
        } else if (batch.length > 0 && (listeners = this.m_listenerList.getListeners(ActivityMapListener.class)) != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ActivityMapEvent[] activityMapEventArray = batch;
                int n = batch.length;
                int n2 = 0;
                while (n2 < n) {
                    ActivityMapEvent e = activityMapEventArray[n2];
                    ((ActivityMapListener)listeners[i]).activityMapChanged(e);
                    ++n2;
                }
                ++i;
            }
        }
    }

    private void processChangeBuffer() {
        ArrayList<ActivityMapEvent> list = this.m_eventBuffer;
        this.m_eventBuffer = new ArrayList();
        if (list.size() > 0) {
            HashMap<Integer, ArrayList<ActivityMapEvent>> coalesceMap = new HashMap<Integer, ArrayList<ActivityMapEvent>>();
            for (ActivityMapEvent e : list) {
                ArrayList<ActivityMapEvent> subList = (ArrayList<ActivityMapEvent>)coalesceMap.get(e.getType());
                if (subList == null) {
                    subList = new ArrayList<ActivityMapEvent>();
                    coalesceMap.put(e.getType(), subList);
                }
                subList.add(e);
            }
            TreeMap<Integer, ActivityMapEvent> sortedCoalescedMap = new TreeMap<Integer, ActivityMapEvent>();
            for (Map.Entry entry : coalesceMap.entrySet()) {
                int type = (Integer)entry.getKey();
                List subList = (List)entry.getValue();
                int lastIndex = subList.size() - 1;
                switch (type) {
                    case 105: {
                        sortedCoalescedMap.put(10, (ActivityMapEvent)subList.get(lastIndex));
                        break;
                    }
                    case 100: {
                        sortedCoalescedMap.put(20, this.coalesceActivityMapEvents(subList));
                        break;
                    }
                    case 102: {
                        sortedCoalescedMap.put(30, this.coalesceActivityMapEvents(subList));
                        break;
                    }
                    case 101: {
                        sortedCoalescedMap.put(40, this.coalesceActivityMapEvents(subList));
                        break;
                    }
                    case 104: {
                        sortedCoalescedMap.put(50, (ActivityMapEvent)subList.get(lastIndex));
                        break;
                    }
                    case 700: {
                        sortedCoalescedMap.put(70, (ActivityMapEvent)subList.get(lastIndex));
                        break;
                    }
                    case 701: {
                        sortedCoalescedMap.put(80, (ActivityMapEvent)subList.get(lastIndex));
                        break;
                    }
                    default: {
                        sortedCoalescedMap.put(-type, (ActivityMapEvent)subList.get(lastIndex));
                    }
                }
            }
            this.fireActivityMapEventBatchInternal(sortedCoalescedMap.values().toArray(new ActivityMapEvent[sortedCoalescedMap.size()]));
        }
    }

    private ActivityMapEvent coalesceActivityMapEvents(List<ActivityMapEvent> list) {
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        ActivityMapEvent last = list.get(list.size() - 1);
        ActivityMapEvent ce = new ActivityMapEvent(last.getActivityMap(), last.getType());
        ce.addPopupMenus(last.getPopupMenus());
        HashSet<ActivityCell> coalesceList = new HashSet<ActivityCell>();
        for (ActivityMapEvent t : list) {
            if (t.getActivityCount() <= 0) continue;
            coalesceList.addAll(Arrays.asList(t.getActivities()));
        }
        ce.setActivities(coalesceList.toArray(new ActivityCell[coalesceList.size()]));
        return ce;
    }

    @Override
    public boolean isActivityMapChanging() {
        return this.m_tableChanging > 0;
    }

    @Override
    public void setActivityMapChanging(boolean b) {
        if (b) {
            ++this.m_tableChanging;
            if (this.m_tableChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_tableChanging > 0) {
            --this.m_tableChanging;
            if (this.m_tableChanging == 0) {
                try {
                    this.validateTimeScale();
                    this.processChangeBuffer();
                }
                finally {
                    this.propertySupport.setPropertiesChanging(false);
                }
            }
        }
    }

    @Override
    public Date getBeginTime() {
        Calendar cal = Calendar.getInstance();
        Date[] a = this.getDays();
        if (a.length > 0) {
            cal.setTime(a[0]);
        } else {
            cal.setTime(DateUtility.truncDate((Date)new Date()));
        }
        switch (this.getPlanningMode()) {
            case 0: {
                cal.set(11, this.getFirstHourOfDay());
                break;
            }
            case 1: {
                break;
            }
        }
        return cal.getTime();
    }

    @Override
    public Date getEndTime() {
        Calendar cal = Calendar.getInstance();
        Date[] a = this.getDays();
        if (a.length > 0) {
            cal.setTime(a[a.length - 1]);
        } else {
            cal.setTime(DateUtility.truncDate((Date)new Date()));
        }
        switch (this.getPlanningMode()) {
            case 0: {
                cal.set(11, this.getLastHourOfDay());
                break;
            }
            case 1: {
                cal.add(5, 1);
                break;
            }
            case 2: {
                cal.add(5, 7);
            }
        }
        return cal.getTime();
    }

    @Override
    public void addDay(Date day) {
        if ((day = DateUtility.truncDate((Date)day)) != null) {
            TreeSet<Date> set = new TreeSet<Date>();
            set.addAll(Arrays.asList(this.getDays()));
            set.add(day);
            this.setDaysInternal(set);
        }
    }

    @Override
    public void removeDay(Date day) {
        if ((day = DateUtility.truncDate((Date)day)) != null) {
            TreeSet<Date> set = new TreeSet<Date>();
            set.addAll(Arrays.asList(this.getDays()));
            set.remove(day);
            this.setDaysInternal(set);
        }
    }

    @Override
    public void setDay(Date day) {
        day = DateUtility.truncDate((Date)day);
        TreeSet<Date> set = new TreeSet<Date>();
        if (day != null) {
            set.add(day);
        }
        this.setDaysInternal(set);
    }

    @Override
    public void setDays(Date[] days) {
        TreeSet<Date> set = new TreeSet<Date>();
        Date[] dateArray = days;
        int n = days.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            set.add(DateUtility.truncDate((Date)d));
            ++n2;
        }
        this.setDaysInternal(set);
    }

    private void setDaysInternal(TreeSet<Date> set) {
        this.propertySupport.setProperty("days", (Object)set.toArray(new Date[set.size()]));
    }

    @Override
    public Date[] getDays() {
        Date[] a = (Date[])this.propertySupport.getProperty("days");
        if (a == null) {
            a = new Date[]{};
        }
        return a;
    }

    @Override
    public int getWorkDayCount() {
        return this.propertySupport.getPropertyInt("workDayCount");
    }

    @Override
    public void setWorkDayCount(int n) {
        if (n < 1 || n > 6) {
            return;
        }
        this.propertySupport.setPropertyInt("workDayCount", n);
    }

    @Override
    public boolean isWorkDaysOnly() {
        return this.propertySupport.getPropertyBool("workDaysOnly");
    }

    @Override
    public void setWorkDaysOnly(boolean b) {
        this.propertySupport.setPropertyBool("workDaysOnly", b);
    }

    @Override
    public int getFirstHourOfDay() {
        return this.propertySupport.getPropertyInt("firstHourOfDay");
    }

    @Override
    public void setFirstHourOfDay(int i) {
        this.propertySupport.setPropertyInt("firstHourOfDay", i);
    }

    @Override
    public int getLastHourOfDay() {
        return this.propertySupport.getPropertyInt("lastHourOfDay");
    }

    @Override
    public void setLastHourOfDay(int i) {
        this.propertySupport.setPropertyInt("lastHourOfDay", i);
    }

    @Override
    public long getIntradayInterval() {
        return this.propertySupport.getPropertyInt("intradayInterval");
    }

    @Override
    public void setIntradayInterval(long millis) {
        if (millis < 900000L || millis > 86400000L) {
            throw new IllegalArgumentException("intradayIntervalMinutes must be between 15 minutes and 24 hours");
        }
        this.propertySupport.setPropertyLong("intradayInterval", millis);
    }

    @Override
    public void setIntradayIntervalInMinutes(long min) {
        this.setIntradayInterval(min * 60000L);
    }

    @Override
    public long getMinimumActivityDuration() {
        return this.m_minimumActivityDuration;
    }

    @Override
    public void setMinimumActivityDuration(long minDuration) {
        this.m_minimumActivityDuration = minDuration;
    }

    @Override
    public void setMinimumActivityDurationInMinutes(long min) {
        this.setMinimumActivityDuration(min * 60000L);
    }

    @Override
    public int getPlanningMode() {
        return this.propertySupport.getPropertyInt("planningMode");
    }

    @Override
    public void setPlanningMode(int mode) {
        this.propertySupport.setPropertyInt("planningMode", mode);
    }

    @Override
    public Date getSelectedBeginTime() {
        return (Date)this.propertySupport.getProperty("selectedBeginTime");
    }

    @Override
    public Date getSelectedEndTime() {
        return (Date)this.propertySupport.getProperty("selectedEndTime");
    }

    @Override
    public void setSelectedTime(Date beginTime, Date endTime) {
        try {
            this.setActivityMapChanging(true);
            this.propertySupport.setProperty("selectedBeginTime", (Object)beginTime);
            this.propertySupport.setProperty("selectedEndTime", (Object)endTime);
        }
        finally {
            this.setActivityMapChanging(false);
        }
    }

    @Override
    public void decorateActivityCell(ActivityCell cell) {
        try {
            try {
                cell.setObserver(null);
                this.decorateActivityCellInternal(cell);
                this.execDecorateActivityCell(cell);
            }
            catch (ProcessingException t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(t);
                cell.setObserver(this.m_cellObserver);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                cell.setObserver(this.m_cellObserver);
            }
        }
        finally {
            cell.setObserver(this.m_cellObserver);
        }
    }

    protected void decorateActivityCellInternal(ActivityCell p) {
        String from;
        String to = from = this.getTimeScale().getDateFormat().format(p.getBeginTime());
        if (p.getEndTime() != null) {
            to = this.getTimeScale().getDateFormat().format(p.getEndTime());
        }
        if (from.equals(to)) {
            p.setTooltipText(from);
        } else {
            p.setTooltipText(String.valueOf(from) + " - " + to);
        }
    }

    @Override
    public MultiTimeRange calculateSelectedTimeRanges(Date earliestBeginTime, Date latestEndTime) {
        Date max;
        MultiTimeRange multiRange = new MultiTimeRange();
        Calendar cal = Calendar.getInstance();
        Date[] dateArray = this.getDays();
        int n = dateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            cal.setTime(d);
            cal.set(11, this.getFirstHourOfDay());
            Date from = cal.getTime();
            cal.set(11, this.getLastHourOfDay());
            cal.add(11, 1);
            Date to = cal.getTime();
            multiRange.add(from, to);
            ++n2;
        }
        Date min = multiRange.getBeginDate();
        if (min != null && min.before(earliestBeginTime)) {
            multiRange.remove(min, earliestBeginTime);
        }
        if ((max = multiRange.getEndDate()) != null && max.after(latestEndTime)) {
            multiRange.remove(latestEndTime, max);
        }
        return multiRange;
    }

    @Override
    public void planActivityForSelectedResources(boolean singleMatch, boolean chooseRandom, Date earliestBeginTime, Date latestEndTime, long preferredDuration) {
        earliestBeginTime = DateUtility.toUtilDate((Date)earliestBeginTime);
        latestEndTime = DateUtility.toUtilDate((Date)latestEndTime);
        if (earliestBeginTime == null) {
            earliestBeginTime = new Date();
        }
        if (latestEndTime == null) {
            latestEndTime = new Date(System.currentTimeMillis() + 315360000000L);
        }
        if (preferredDuration <= 0L) {
            preferredDuration = 1800000L;
        }
        this.setSelectedTime(null, null);
        if (singleMatch) {
            this.planActivityForSelectedResourcesSingleInternal(chooseRandom, earliestBeginTime, latestEndTime, preferredDuration);
        } else {
            this.planActivityForSelectedResourcesMultiInternal(earliestBeginTime, latestEndTime, preferredDuration);
        }
    }

    private void planActivityForSelectedResourcesSingleInternal(boolean chooseRandom, Date earliestBeginTime, Date latestEndTime, long preferredDuration) {
        MultiTimeRange multiTimeRange = this.calculateSelectedTimeRanges(earliestBeginTime, latestEndTime);
        if (multiTimeRange.isEmpty()) {
            return;
        }
        TreeMap<CompositeLong, ActivityCell> sortMap = new TreeMap<CompositeLong, ActivityCell>();
        Random rnd = new Random();
        int resourceIndex = 0;
        Long[] longArray = this.getSelectedResourceIds();
        int n = longArray.length;
        int n2 = 0;
        while (n2 < n) {
            Long resourceId = longArray[n2];
            MultiTimeRange localTimeRanges = (MultiTimeRange)multiTimeRange.clone();
            Object[] objectArray = this.getActivityCells(resourceId);
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ActivityCell a = objectArray[n4];
                localTimeRanges.remove(a.getBeginTime(), a.getEndTime());
                ++n4;
            }
            objectArray = localTimeRanges.getTimeRanges();
            n3 = objectArray.length;
            n4 = 0;
            while (n4 < n3) {
                ActivityCell a;
                long sortNo;
                ActivityCell tr = objectArray[n4];
                long durationMillis = ((TimeRange)((Object)tr)).getDurationMillis();
                long l = sortNo = chooseRandom ? rnd.nextLong() : (long)resourceIndex;
                if (durationMillis >= preferredDuration) {
                    a = new ActivityCell(0L, 0L);
                    a.setBeginTime(((TimeRange)((Object)tr)).getFrom());
                    a.setEndTime(new Date(((TimeRange)((Object)tr)).getFrom().getTime() + preferredDuration));
                    sortMap.put(new CompositeLong(0L, a.getBeginTime().getTime(), sortNo), a);
                } else if (durationMillis >= 900000L) {
                    a = new ActivityCell(0L, 0L);
                    a.setBeginTime(((TimeRange)((Object)tr)).getFrom());
                    a.setEndTime(new Date(((TimeRange)((Object)tr)).getFrom().getTime() + durationMillis));
                    sortMap.put(new CompositeLong(1L, -durationMillis, sortNo), a);
                }
                ++n4;
            }
            ++resourceIndex;
            ++n2;
        }
        if (!sortMap.isEmpty()) {
            ActivityCell a = (ActivityCell)((Object)sortMap.get(sortMap.firstKey()));
            this.setSelectedResourceIds(new Long[]{a.getResourceId()});
            this.setSelectedTime(a.getBeginTime(), a.getEndTime());
        }
    }

    private void planActivityForSelectedResourcesMultiInternal(Date earliestBeginTime, Date latestEndTime, long preferredDuration) {
        MultiTimeRange multiTimeRange = this.calculateSelectedTimeRanges(earliestBeginTime, latestEndTime);
        if (multiTimeRange.isEmpty()) {
            return;
        }
        TreeMap<CompositeLong, ActivityCell> sortMap = new TreeMap<CompositeLong, ActivityCell>();
        Object[] objectArray = this.getSelectedResourceIds();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Long resourceId = objectArray[n2];
            ActivityCell[] activityCellArray = this.getActivityCells(resourceId);
            int n3 = activityCellArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ActivityCell a = activityCellArray[n4];
                multiTimeRange.remove(a.getBeginTime(), a.getEndTime());
                ++n4;
            }
            ++n2;
        }
        objectArray = multiTimeRange.getTimeRanges();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object tr = objectArray[n2];
            long durationMillis = ((TimeRange)tr).getDurationMillis();
            if (durationMillis >= preferredDuration) {
                ActivityCell a = new ActivityCell(0L, 0L);
                a.setBeginTime(((TimeRange)tr).getFrom());
                a.setEndTime(new Date(((TimeRange)tr).getFrom().getTime() + preferredDuration));
                sortMap.put(new CompositeLong(0L, a.getBeginTime().getTime()), a);
            } else if (durationMillis >= 900000L) {
                ActivityCell a = new ActivityCell(0L, 0L);
                a.setBeginTime(((TimeRange)tr).getFrom());
                a.setEndTime(new Date(((TimeRange)tr).getFrom().getTime() + durationMillis));
                sortMap.put(new CompositeLong(1L, -durationMillis), a);
            }
            ++n2;
        }
        if (!sortMap.isEmpty()) {
            ActivityCell a = (ActivityCell)((Object)sortMap.get(sortMap.firstKey()));
            this.setSelectedTime(a.getBeginTime(), a.getEndTime());
        }
    }

    @Override
    public IActivityMapUIFacade getUIFacade() {
        return this.m_activityMapUIFacade;
    }

    private class P_ActivityCellObserver
    implements IActivityCellObserver {
        private P_ActivityCellObserver() {
        }

        @Override
        public void cellChanged(ActivityCell cell, int bitPos) {
            AbstractActivityMap.this.fireActivitiesUpdated(new ActivityCell[]{cell});
        }
    }

    private class P_ActivityMapUIFacade
    implements IActivityMapUIFacade {
        private P_ActivityMapUIFacade() {
        }

        public void setSelectedDayListFromUI(Date[] days) {
            AbstractActivityMap.this.setDays(days);
        }

        @Override
        public void setSelectionFromUI(Long[] resourceIds, double[] normalizedRange) {
            try {
                AbstractActivityMap.this.setActivityMapChanging(true);
                double cellCenter = 1.0 / (double)AbstractActivityMap.this.getTimeScale().getMinorTimeColumns().length / 2.0;
                AbstractActivityMap.this.setSelectedResourceIds(resourceIds);
                Date beginTime = normalizedRange != null ? AbstractActivityMap.this.getTimeScale().getMinorTimeColumn(normalizedRange[0] + cellCenter).getBeginTime() : null;
                Date endTime = normalizedRange != null ? AbstractActivityMap.this.getTimeScale().getMinorTimeColumn(normalizedRange[1] - cellCenter).getEndTime() : null;
                AbstractActivityMap.this.setSelectedTime(beginTime, endTime);
            }
            finally {
                AbstractActivityMap.this.setActivityMapChanging(false);
            }
        }

        @Override
        public IMenu[] fireEditActivityPopupFromUI() {
            return AbstractActivityMap.this.fireEditActivityPopup(AbstractActivityMap.this.getSelectedActivityCell());
        }

        @Override
        public IMenu[] fireNewActivityPopupFromUI() {
            return AbstractActivityMap.this.fireNewActivityPopup();
        }

        @Override
        public void setDaysFromUI(Date[] days) {
            AbstractActivityMap.this.setDays(days);
        }

        @Override
        public void setSelectedActivityCellFromUI(ActivityCell cell) {
            AbstractActivityMap.this.setSelectedActivityCell(cell);
        }

        @Override
        public void fireCellActionFromUI(long resourceId, double[] normalizedRange, ActivityCell activityCell) {
            if (activityCell != null) {
                AbstractActivityMap.this.setSelectedActivityCell(activityCell);
            }
            MinorTimeColumn column = AbstractActivityMap.this.getTimeScale().getMinorTimeColumn((normalizedRange[0] + normalizedRange[1]) / 2.0);
            AbstractActivityMap.this.fireCellAction(resourceId, column, activityCell);
        }
    }
}

