/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar.provider;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarAppointment;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarTask;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractCalendarItemProvider
extends AbstractPropertyObserver
implements ICalendarItemProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCalendarItemProvider.class);
    public static final long DAY_MILLIS = 86400000L;
    public static final long MONTH_MILLIS = 2764800000L;
    private P_ReloadJob m_reloadJob;
    private IMenu[] m_menus;
    private Date m_minDateLoaded;
    private Date m_maxDateLoaded;

    public AbstractCalendarItemProvider() {
        this.initConfig();
        this.ensureItemsLoadedInternal(new Date(System.currentTimeMillis() - 2764800000L), new Date(System.currentTimeMillis() + 2764800000L));
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMoveItemEnabled() {
        return false;
    }

    @ConfigProperty(value="LONG")
    @Order(value=20.0)
    @ConfigPropertyValue(value="0")
    protected long getConfiguredRefreshIntervallMillis() {
        return 0L;
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execLoadItems(Date minDate, Date maxDate, Holder<ICalendarItem[]> resultHolder) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execLoadItemsInBackground(IClientSession session, final Date minDate, final Date maxDate, final Holder<ICalendarItem[]> resultHolder) throws ProcessingException {
        ClientSyncJob job = new ClientSyncJob(String.valueOf(this.getClass().getSimpleName()) + " load items", session){

            @Override
            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                AbstractCalendarItemProvider.this.execLoadItems(minDate, maxDate, (Holder<ICalendarItem[]>)resultHolder);
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execDecorateCell(Cell cell, ICalendarItem item) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execItemMoved(ICalendarItem item, Date newDate) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execItemAction(ICalendarItem item) throws ProcessingException {
    }

    protected void initConfig() {
        this.setMoveItemEnabled(this.getConfiguredMoveItemEnabled());
        this.setRefreshIntervalMillis(this.getConfiguredRefreshIntervallMillis());
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class<? extends IMenu>[] ma = this.getConfiguredMenus();
        int i = 0;
        while (i < ma.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, ma[i]);
                menuList.add(menu);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contribute menus.", (Throwable)e);
        }
        this.m_menus = menuList.toArray(new IMenu[0]);
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    @Override
    public void disposeProvider() {
        P_ReloadJob job = this.m_reloadJob;
        if (job != null) {
            job.cancel();
            this.m_reloadJob = null;
        }
    }

    @Override
    public final void decorateCell(Cell cell, ICalendarItem item) {
        this.decorateCellInternal(cell, item);
        try {
            this.execDecorateCell(cell, item);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", e));
        }
    }

    protected void decorateCellInternal(Cell cell, ICalendarItem item) {
        StringBuffer buf;
        if (item instanceof ICalendarAppointment) {
            ICalendarAppointment app = (ICalendarAppointment)item;
            cell.setText(app.getSubject());
            buf = new StringBuffer();
            if (app.getLocation() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(app.getLocation());
            }
            if (app.getBody() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(app.getBody());
            }
            if (buf.length() > 0) {
                cell.setTooltipText(buf.toString());
            }
        }
        if (item instanceof ICalendarTask) {
            ICalendarTask task = (ICalendarTask)item;
            cell.setText(task.getSubject());
            buf = new StringBuffer();
            if (task.getBody() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(task.getBody());
            }
            if (buf.length() > 0) {
                cell.setTooltipText(buf.toString());
            }
        }
        cell.setBackgroundColor(item.getColor());
    }

    @Override
    public ICalendarItem[] getItems(Date minDate, Date maxDate) {
        this.ensureItemsLoadedInternal(minDate, maxDate);
        ArrayList<ICalendarItem> list = new ArrayList<ICalendarItem>();
        ICalendarItem[] a = (ICalendarItem[])this.propertySupport.getProperty("items");
        if (a != null) {
            ICalendarItem[] iCalendarItemArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                ICalendarItem item = iCalendarItemArray[n2];
                if (item.isIntersecting(minDate, maxDate)) {
                    list.add(item);
                }
                ++n2;
            }
        }
        return list.toArray(new ICalendarItem[list.size()]);
    }

    @Override
    public void reloadProvider() {
        this.loadItemsAsyncInternal(ClientSyncJob.getCurrentSession(), this.m_minDateLoaded, this.m_maxDateLoaded, 250L);
    }

    private void setItemsInternal(Date minDate, Date maxDate, ICalendarItem[] items) {
        this.m_minDateLoaded = minDate;
        this.m_maxDateLoaded = maxDate;
        this.propertySupport.setProperty("items", (Object)items);
    }

    @Override
    public IMenu[] getMenus() {
        return this.m_menus;
    }

    @Override
    public boolean isMoveItemEnabled() {
        return this.propertySupport.getPropertyBool("moveItemEnabled");
    }

    @Override
    public void setMoveItemEnabled(boolean b) {
        this.propertySupport.setPropertyBool("moveItemEnabled", b);
    }

    @Override
    public boolean isLoadInProgress() {
        return this.propertySupport.getPropertyBool("loadInProgress");
    }

    @Override
    public void setLoadInProgress(boolean b) {
        this.propertySupport.setPropertyBool("loadInProgress", b);
    }

    @Override
    public long getRefreshIntervalMillis() {
        return this.propertySupport.getPropertyLong("refreshIntervalMillis");
    }

    @Override
    public void setRefreshIntervalMillis(long m) {
        this.propertySupport.setPropertyLong("refreshIntervalMillis", m);
        if (m > 0L) {
            this.loadItemsAsyncInternal(ClientSyncJob.getCurrentSession(), this.m_minDateLoaded, this.m_maxDateLoaded, m);
        }
    }

    @Override
    public void onItemAction(ICalendarItem item) throws ProcessingException {
        try {
            this.execItemAction(item);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public void onItemMoved(ICalendarItem item, Date newDate) throws ProcessingException {
        try {
            this.execItemMoved(item, newDate);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    private void ensureItemsLoadedInternal(Date minDate, Date maxDate) {
        if (!DateUtility.isInRange((Date)this.m_minDateLoaded, (Date)minDate, (Date)this.m_maxDateLoaded) || !DateUtility.isInRange((Date)this.m_minDateLoaded, (Date)maxDate, (Date)this.m_maxDateLoaded)) {
            this.loadItemsAsyncInternal(ClientSyncJob.getCurrentSession(), minDate, maxDate, 250L);
        }
    }

    private synchronized void loadItemsAsyncInternal(IClientSession session, Date minDate, Date maxDate, long startDelayMillis) {
        P_ReloadJob oldJob = this.m_reloadJob;
        if (oldJob != null) {
            oldJob.cancel();
            this.m_reloadJob = null;
        }
        if (minDate != null && maxDate != null) {
            this.m_reloadJob = new P_ReloadJob(session, minDate, maxDate);
            this.m_reloadJob.schedule(startDelayMillis);
        }
    }

    static /* synthetic */ Date access$0(AbstractCalendarItemProvider abstractCalendarItemProvider) {
        return abstractCalendarItemProvider.m_minDateLoaded;
    }

    static /* synthetic */ Date access$1(AbstractCalendarItemProvider abstractCalendarItemProvider) {
        return abstractCalendarItemProvider.m_maxDateLoaded;
    }

    static /* synthetic */ void access$2(AbstractCalendarItemProvider abstractCalendarItemProvider, IClientSession iClientSession, Date date, Date date2, long l) {
        abstractCalendarItemProvider.loadItemsAsyncInternal(iClientSession, date, date2, l);
    }

    static /* synthetic */ IScoutLogger access$3() {
        return LOG;
    }

    private class P_ReloadJob
    extends ClientAsyncJob {
        private final Holder<ICalendarItem[]> m_result;
        private final Date m_loadingMinDate;
        private final Date m_loadingMaxDate;

        public P_ReloadJob(IClientSession session, Date loadingMinDate, Date loadingMaxDate) {
            super(String.valueOf(AbstractCalendarItemProvider.this.getClass().getSimpleName()) + " reload", session);
            this.m_result = new Holder(null);
            this.m_loadingMinDate = loadingMinDate;
            this.m_loadingMaxDate = loadingMaxDate;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 10[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

