/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.treebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

public abstract class AbstractTreeBoxFilterBox
extends AbstractGroupBox {
    private final OptimisticLock m_treeBoxSyncLock = new OptimisticLock();
    private PropertyChangeListener m_treeBoxPropertyListener;

    protected abstract ITreeBox getTreeBox();

    @Override
    protected boolean getConfiguredBorderVisible() {
        return false;
    }

    @Override
    protected int getConfiguredGridW() {
        return 1;
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @Override
    protected int getConfiguredGridColumnCount() {
        return 1;
    }

    @Override
    protected void execInitField() throws ProcessingException {
        if (this.m_treeBoxPropertyListener == null) {
            this.m_treeBoxPropertyListener = new PropertyChangeListener(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String name = e.getPropertyName();
                    if ("filterCheckedNodes".equals(name)) {
                        AbstractTreeBoxFilterBox.this.updateVisibilities();
                        return;
                    }
                    if ("filterActiveNodes".equals(name)) {
                        AbstractTreeBoxFilterBox.this.updateVisibilities();
                        return;
                    }
                    if ("filterCheckedNodesValue".equals(name)) {
                        try {
                            if (!AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.acquire()) return;
                            AbstractTreeBoxFilterBox.this.getCheckedStateRadioButtonGroup().setValue(AbstractTreeBoxFilterBox.this.getTreeBox().getFilterCheckedNodesValue());
                            return;
                        }
                        finally {
                            AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.release();
                        }
                    }
                    if (!"filterActiveNodesValue".equals(name)) return;
                    try {
                        if (!AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.acquire()) return;
                        AbstractTreeBoxFilterBox.this.getActiveStateRadioButtonGroup().setValue(AbstractTreeBoxFilterBox.this.getTreeBox().getFilterActiveNodesValue());
                        return;
                    }
                    finally {
                        AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.release();
                    }
                }
            };
            this.getTreeBox().addPropertyChangeListener(this.m_treeBoxPropertyListener);
        }
        try {
            this.m_treeBoxSyncLock.acquire();
            this.updateVisibilities();
            this.getCheckedStateRadioButtonGroup().setValue(this.getTreeBox().getFilterCheckedNodesValue());
            this.getActiveStateRadioButtonGroup().setValue(this.getTreeBox().getFilterActiveNodesValue());
        }
        finally {
            this.m_treeBoxSyncLock.release();
        }
    }

    protected void updateVisibilities() {
        this.setVisible(this.getTreeBox().isFilterCheckedNodes() || this.getTreeBox().isFilterActiveNodes());
        this.getCheckedStateRadioButtonGroup().setVisible(this.getTreeBox().isFilterCheckedNodes());
        this.getActiveStateRadioButtonGroup().setVisible(this.getTreeBox().isFilterActiveNodes());
    }

    @Override
    protected void execDisposeField() throws ProcessingException {
        if (this.m_treeBoxPropertyListener != null) {
            this.getTreeBox().removePropertyChangeListener(this.m_treeBoxPropertyListener);
            this.m_treeBoxPropertyListener = null;
        }
    }

    public ActiveStateRadioButtonGroup getActiveStateRadioButtonGroup() {
        return this.getFieldByClass(ActiveStateRadioButtonGroup.class);
    }

    public CheckedStateRadioButtonGroup getCheckedStateRadioButtonGroup() {
        return this.getFieldByClass(CheckedStateRadioButtonGroup.class);
    }

    @Order(value=20.0)
    public class ActiveStateRadioButtonGroup
    extends AbstractRadioButtonGroup<TriState> {
        @Override
        protected void execAddSearchTerms(SearchFilter search) {
        }

        @Override
        protected boolean getConfiguredGridUseUiHeight() {
            return true;
        }

        @Override
        protected boolean getConfiguredGridUseUiWidth() {
            return true;
        }

        @Override
        protected double getConfiguredGridWeightX() {
            return 1.0;
        }

        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected boolean execIsEmpty() throws ProcessingException {
            return true;
        }

        @Override
        protected boolean execIsSaveNeeded() throws ProcessingException {
            return false;
        }

        @Override
        protected void execChangedValue() throws ProcessingException {
            try {
                if (AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.acquire()) {
                    AbstractTreeBoxFilterBox.this.getTreeBox().setFilterActiveNodesValue((TriState)AbstractTreeBoxFilterBox.this.getActiveStateRadioButtonGroup().getValue());
                }
            }
            finally {
                AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.release();
            }
        }

        @Order(value=30.0)
        public class ActiveAndInactiveButton
        extends AbstractButton {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected int getConfiguredDisplayStyle() {
                return 2;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ActiveAndInactiveStates", (String[])new String[0]);
            }

            @Override
            protected Object getConfiguredRadioValue() {
                return TriState.UNDEFINED;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=10.0)
        public class ActiveButton
        extends AbstractButton {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected int getConfiguredDisplayStyle() {
                return 2;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ActiveStates", (String[])new String[0]);
            }

            @Override
            protected Object getConfiguredRadioValue() {
                return TriState.TRUE;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=20.0)
        public class InactiveButton
        extends AbstractButton {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected int getConfiguredDisplayStyle() {
                return 2;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"InactiveStates", (String[])new String[0]);
            }

            @Override
            protected Object getConfiguredRadioValue() {
                return TriState.FALSE;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }

    @Order(value=10.0)
    public class CheckedStateRadioButtonGroup
    extends AbstractRadioButtonGroup<Boolean> {
        @Override
        protected void execAddSearchTerms(SearchFilter search) {
        }

        @Override
        protected boolean getConfiguredGridUseUiHeight() {
            return true;
        }

        @Override
        protected boolean getConfiguredGridUseUiWidth() {
            return true;
        }

        @Override
        protected double getConfiguredGridWeightX() {
            return 1.0;
        }

        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected boolean execIsEmpty() throws ProcessingException {
            return true;
        }

        @Override
        protected boolean execIsSaveNeeded() throws ProcessingException {
            return false;
        }

        @Override
        protected void execChangedValue() throws ProcessingException {
            try {
                if (AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.acquire()) {
                    Boolean b = (Boolean)AbstractTreeBoxFilterBox.this.getCheckedStateRadioButtonGroup().getValue();
                    AbstractTreeBoxFilterBox.this.getTreeBox().setFilterCheckedNodesValue(b != null && b != false);
                }
            }
            finally {
                AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.release();
            }
        }

        @Order(value=20.0)
        public class AllButton
        extends AbstractButton {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected int getConfiguredDisplayStyle() {
                return 2;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"AllStates", (String[])new String[0]);
            }

            @Override
            protected Object getConfiguredRadioValue() {
                return false;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=10.0)
        public class CheckedButton
        extends AbstractButton {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected int getConfiguredDisplayStyle() {
                return 2;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"SelectedStates", (String[])new String[0]);
            }

            @Override
            protected Object getConfiguredRadioValue() {
                return true;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }
}

