/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.ui.view.InstanceServicesComposite;
import org.eclipse.tml.framework.device.ui.view.InstanceStatusComposite;
import org.eclipse.tml.framework.device.ui.view.model.InstanceSelectionChangeEvent;
import org.eclipse.tml.framework.device.ui.view.model.InstanceSelectionChangeListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class InstanceMgtView
extends ViewPart {
    private static final Set<InstanceSelectionChangeListener> listeners = new LinkedHashSet<InstanceSelectionChangeListener>();
    private static InstanceServicesComposite instanceServicesComposite = null;
    private static IInstance selectedInstance = null;
    private static InstanceStatusComposite topComposite;
    private static InstanceSelectionChangeListener selectionChangeListener;
    private static SashForm form;
    private static String contextId;

    public static InstanceServicesComposite getInstanceServicesComposite() {
        return instanceServicesComposite;
    }

    public static void setHelp(String contextId) {
        InstanceMgtView.contextId = contextId;
        if (form != null) {
            form.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, contextId);
                }
            });
        }
    }

    public void createPartControl(Composite parent) {
        InstanceServicesComposite bottomComposite;
        form = new SashForm(parent, 512);
        form.setLayout((Layout)new FillLayout());
        topComposite = new InstanceStatusComposite((Composite)form, this.getViewSite());
        instanceServicesComposite = bottomComposite = new InstanceServicesComposite((Composite)form);
        form.setWeights(new int[]{60, 40});
        if (selectionChangeListener != null) {
            topComposite.removeInstanceSelectionChangeListener(selectionChangeListener);
        }
        selectionChangeListener = new InstanceSelectionChangeListener(){

            public void instanceSelectionChanged(InstanceSelectionChangeEvent event) {
                bottomComposite.setSelectedInstance(event.getInstance());
            }
        };
        topComposite.addInstanceSelectionChangeListener(selectionChangeListener);
        if (contextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, contextId);
        }
    }

    public void setFocus() {
        if (form != null) {
            form.setFocus();
        }
    }

    public static void setSeletectedInstance(IInstance instance) {
        selectedInstance = instance;
        if (topComposite != null) {
            topComposite.selectInstance(instance);
        }
    }

    public static IInstance getSelectedInstance() {
        if (topComposite != null) {
            return topComposite.getSelectedInstance();
        }
        return selectedInstance;
    }

    public static void addInstanceSelectionChangeListener(InstanceSelectionChangeListener listener) {
        listeners.add(listener);
    }

    public static void removeInstanceSelectionChangeListener(InstanceSelectionChangeListener listener) {
        listeners.remove(listener);
    }

    protected static void notifyInstanceSelectionChangeListeners(IInstance instance) {
        if (instance != null) {
            InstanceSelectionChangeEvent event = new InstanceSelectionChangeEvent(instance);
            for (InstanceSelectionChangeListener listener : listeners) {
                listener.instanceSelectionChanged(event);
            }
        }
    }

    public void dispose() {
        if (topComposite != null) {
            topComposite.removeListener();
        }
        super.dispose();
    }
}

