/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.editors;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.internal.model.MobileInstance;
import org.eclipse.sequoyah.device.framework.model.AbstractMobileInstance;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.ui.DeviceUIResources;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class InstancePropertyEditor
extends PropertyPage {
    private static final String LABEL_INSTANCE_NAME = "Device name: ";
    private static final String LABEL_PROPERTIES = "Properties: ";
    private static final String COLUMN_NAME_KEY = "Key";
    private static final String COLUMN_NAME_VALUE = "Value";
    private Table table;
    private MobileInstance instance;
    private Text textInstanceName;
    private String initialInstanceName;

    private void onMouseDoubleClick() {
        String string = this.table.getSelection()[0].getText(0);
        String string2 = this.table.getSelection()[0].getText(1);
        InputDialog inputDialog = new InputDialog(this.getShell(), String.valueOf(string) + " Property Value", "Enter a new value for " + string, string2, null);
        if (inputDialog.open() == 0) {
            this.table.getSelection()[0].setText(1, inputDialog.getValue().trim());
        }
    }

    private boolean validateName(String string) {
        InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
        String string2 = null;
        boolean bl = false;
        if (string != null && !string.equals("")) {
            if (instanceRegistry.getInstancesByName(string).size() == 0 || string.equals(this.initialInstanceName)) {
                bl = true;
            } else {
                string2 = DeviceUIResources.SEQUOYAH_Instance_Name_Duplicated_Error;
            }
            if (bl && !AbstractMobileInstance.validName((String)string)) {
                bl = false;
                string2 = DeviceUIResources.SEQUOYAH_Instance_Name_Invalid_Error;
            }
        }
        this.setErrorMessage(string2);
        return bl;
    }

    public Control createContents(Composite composite) {
        String[] stringArray = new String[]{COLUMN_NAME_KEY, COLUMN_NAME_VALUE};
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        this.instance = (MobileInstance)this.getElement().getAdapter(MobileInstance.class);
        Label label = new Label(composite2, 0);
        label.setText(LABEL_INSTANCE_NAME);
        this.textInstanceName = new Text(composite2, 2048);
        this.initialInstanceName = this.instance.getName().trim();
        this.textInstanceName.setText(this.initialInstanceName);
        GridData gridData = new GridData(768);
        this.textInstanceName.setLayoutData((Object)gridData);
        this.textInstanceName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                boolean bl = InstancePropertyEditor.this.validateName(InstancePropertyEditor.this.textInstanceName.getText());
                InstancePropertyEditor.this.setValid(bl);
            }
        });
        label = new Label(composite2, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText(LABEL_PROPERTIES);
        this.table = new Table(composite2, 65536);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gridData);
        new TableColumn(this.table, 0x1000000).setText(stringArray[0]);
        new TableColumn(this.table, 0x1000000).setText(stringArray[1]);
        Properties properties = this.instance.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(new String[]{string, string2});
        }
        int n = this.table.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            this.table.getColumn(n2).pack();
            ++n2;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                InstancePropertyEditor.this.onMouseDoubleClick();
            }
        });
        this.noDefaultAndApplyButton();
        return composite2;
    }

    public boolean performOk() {
        TableItem[] tableItemArray = this.table.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            String string = tableItemArray[n].getText(0);
            String string2 = tableItemArray[n].getText(1).trim();
            this.instance.getProperties().setProperty(string, string2);
            ++n;
        }
        this.instance.setName(this.textInstanceName.getText().trim());
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UPDATED, (IInstance)this.instance));
        return true;
    }
}

