/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework;

import java.util.Collection;
import java.util.List;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;

public abstract class DeviceUtils {
    public static String[] getAllDeviceNames() {
        DeviceTypeRegistry deviceTypeRegistry = DeviceTypeRegistry.getInstance();
        Collection<IDeviceType> collection = deviceTypeRegistry.getDeviceTypes();
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (IDeviceType iDeviceType : collection) {
            stringArray[n++] = iDeviceType.getBundleName();
        }
        return stringArray;
    }

    public static String[] getAllInstanceNames() {
        InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
        List<IInstance> list = instanceRegistry.getInstances();
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (IInstance iInstance : list) {
            stringArray[n++] = iInstance.getName();
        }
        return stringArray;
    }

    public static IInstance getInstance(String string) {
        IInstance iInstance = null;
        List<IInstance> list = InstanceRegistry.getInstance().getInstancesByName(string);
        if (!list.isEmpty()) {
            iInstance = list.get(0);
        }
        return iInstance;
    }

    public static IService getServiceById(IDeviceType iDeviceType, String string) {
        IService iService = null;
        if (iDeviceType != null && string != null) {
            for (IService iService2 : iDeviceType.getServices()) {
                if (!string.equals(iService2.getId())) continue;
                iService = iService2;
                break;
            }
        }
        return iService;
    }

    public static IDeviceType getDeviceType(IInstance iInstance) {
        return DeviceUtils.getDeviceTypeById(iInstance.getDeviceTypeId());
    }

    public static IDeviceType getDeviceTypeById(String string) {
        return DeviceTypeRegistry.getInstance().getDeviceTypeById(string);
    }
}

