/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.FileUtil;
import org.eclipse.sequoyah.device.common.utilities.exception.AbstractExceptionStatus;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahExceptionStatus;
import org.eclipse.sequoyah.localization.android.AndroidLocaleAttribute;
import org.eclipse.sequoyah.localization.android.AndroidLocalizationPlugin;
import org.eclipse.sequoyah.localization.android.LocalizationXMLParserFilter;
import org.eclipse.sequoyah.localization.android.datamodel.AndroidLocalizationFile;
import org.eclipse.sequoyah.localization.android.i18n.Messages;
import org.eclipse.sequoyah.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.TranslationInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleAttribute;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.StringArray;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNode;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNodeComment;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.NewRowInputDialog;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.TranslateColumnInputDialog;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.TranslateColumnsInputDialog;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.ProjectLocalizationManager;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidLocalizationSchema
extends ILocalizationSchema {
    private final String RESOURCES_FOLDER = "res";
    private final String PREFERED_LANGUAGES_XML_PATH = "resource/prefered_languages.xml";
    private final String DEFAULT_LOCALE_TOOLTIP = Messages.AndroidLocalizationSchema_Default_Andr_Localization_File_Tooltip;
    public static final String LOCALIZATION_FILES_FOLDER = "values";
    public static final String LOCALIZATION_FILE_NAME = "strings.xml";
    private final String FILE_EXTENSION = "xml";
    private final String LF_REGULAR_EXPRESSION = "res/values.*/strings.xml";
    private final String XML_RESOURCES_TAG = "resources";
    private final String XML_STRING_TAG = "string";
    private final String XML_STRING_ARRAY_TAG = "string-array";
    private final String XML_STRING_ARRAY_ITEM_TAG = "item";
    private final String XML_STRING_ATTR_NAME = "name";
    private final String NEW_COLUMN_TITLE = Messages.AndroidNewColumnProvider_NewColumnTitle;
    private final String NEW_TRANSLATE_COLUMN_TITLE = Messages.AndroidTranslatedColumnProvider_NewColumnTitle;
    private final String TRANSLATE_CELLS_TITLE = Messages.AndroidTranslateCells_DialogTitle;
    private final String NEW_ROW_TITLE = Messages.AndroidNewRow_DialogTitle;
    private final String NEW_COLUMN_DESCRIPTION = Messages.AndroidNewColumnProvider_NewColumnDescription;
    private final String NEW_COLUMN_TEXT = "values";
    private final String NEW_COLUMN_INVALID_ID = Messages.AndroidNewColumnProvider_InvalidNewColumID;
    private String MANDATORY_ID = "values";
    private final String QUALIFIER_SEP = "-";

    public List<String> getPreferedLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            InputStream inputStream = AndroidLocalizationPlugin.getDefault().getBundle().getEntry("resource/prefered_languages.xml").openStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("language");
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element2 = (Element)nodeList.item(n);
                arrayList.add(element2.getAttributeNode("id").getNodeValue());
                ++n;
            }
        }
        catch (Exception exception) {
            BasePlugin.logError((String)"Could not load prefered languages for Android Localization Schema");
        }
        return arrayList;
    }

    public String getIDforLanguage(String string) {
        String string2 = LOCALIZATION_FILES_FOLDER;
        if (string.contains("-")) {
            String[] stringArray = string.split("-");
            string2 = String.valueOf(string2) + "-" + stringArray[0] + "-" + "r" + stringArray[1];
        } else {
            string2 = String.valueOf(string2) + "-" + string;
        }
        return string2;
    }

    public IStatus isValueValid(String string, String string2, String string3) {
        Status status = new Status(0, "org.eclipse.sequoyah.localization.android", "");
        if (string.toLowerCase().equals(this.MANDATORY_ID.toLowerCase())) {
            if (string3 == null) {
                status = new Status(4, "org.eclipse.sequoyah.localization.android", Messages.EmptyKey_Discouraged);
            }
            if (string3 == null || string3.length() == 0) {
                status = new Status(2, "org.eclipse.sequoyah.localization.android", Messages.EmptyKey_Discouraged);
            }
        }
        return status;
    }

    public ColumnInfo promptCollumnName(final IProject iProject) {
        ColumnInfo columnInfo = null;
        InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.NEW_COLUMN_TITLE, this.NEW_COLUMN_DESCRIPTION, LOCALIZATION_FILES_FOLDER, new IInputValidator(){

            public String isValid(String string) {
                return AndroidLocalizationSchema.this.isValid2(string, iProject);
            }
        });
        if (inputDialog.open() == 0) {
            columnInfo = new ColumnInfo(inputDialog.getValue(), inputDialog.getValue(), null, true);
        }
        return columnInfo;
    }

    public RowInfo[] promptRowName(IProject iProject) {
        RowInfo[] rowInfoArray = null;
        NewRowInputDialog newRowInputDialog = new NewRowInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iProject, this.NEW_ROW_TITLE);
        if (newRowInputDialog.open() == 0) {
            rowInfoArray = new RowInfo[newRowInputDialog.getNumEntries()];
            String string = newRowInputDialog.getKey();
            boolean bl = newRowInputDialog.isArray();
            int n = 0;
            while (n < newRowInputDialog.getNumEntries()) {
                rowInfoArray[n] = new RowInfo(string, bl, null);
                ++n;
            }
        }
        return rowInfoArray;
    }

    public TranslationInfo promptTranslatedCollumnName(final IProject iProject, String string) {
        TranslationInfo translationInfo = null;
        TranslateColumnInputDialog translateColumnInputDialog = new TranslateColumnInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iProject, string, this.NEW_TRANSLATE_COLUMN_TITLE, this.NEW_COLUMN_DESCRIPTION, LOCALIZATION_FILES_FOLDER, new IInputValidator(){

            public String isValid(String string) {
                return AndroidLocalizationSchema.this.isValid2(string, iProject);
            }
        });
        if (translateColumnInputDialog.open() == 0) {
            translationInfo = new TranslationInfo(translateColumnInputDialog.getValue(), translateColumnInputDialog.getValue(), null, true, translateColumnInputDialog.getFromLanguage(), translateColumnInputDialog.getToLanguage(), null, translateColumnInputDialog.getTranslator());
        }
        return translationInfo;
    }

    public TranslationInfo[] promptTranslatedCollumnsName(IProject iProject, String string, String[] stringArray, String[] stringArray2, TableColumn[] tableColumnArray) {
        TranslationInfo[] translationInfoArray = null;
        TranslateColumnsInputDialog translateColumnsInputDialog = new TranslateColumnsInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iProject, string, stringArray2, tableColumnArray, this.TRANSLATE_CELLS_TITLE);
        if (translateColumnsInputDialog.open() == 0) {
            List list = translateColumnsInputDialog.getDestinationColumns();
            translationInfoArray = new TranslationInfo[stringArray2.length * list.size()];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String string2 = stringArray2[n2];
                String string3 = stringArray[n2];
                int n3 = 0;
                while (n3 < list.size()) {
                    TranslateColumnsInputDialog.DestinationColumn destinationColumn = (TranslateColumnsInputDialog.DestinationColumn)list.get(n3);
                    translationInfoArray[n] = new TranslationInfo(destinationColumn.getText(), destinationColumn.getText(), null, true, translateColumnsInputDialog.getFromLanguage(), destinationColumn.getLang(), string2, translateColumnsInputDialog.getTranslator());
                    translationInfoArray[n].setFromKey(string3);
                    translationInfoArray[n].setToColumn(destinationColumn.getText());
                    ++n;
                    ++n3;
                }
                ++n2;
            }
        }
        return translationInfoArray;
    }

    private String isValid2(String string, IProject iProject) {
        String string2 = null;
        if (string.startsWith(LOCALIZATION_FILES_FOLDER)) {
            AndroidLocalizationSchema androidLocalizationSchema = new AndroidLocalizationSchema();
            String string3 = string.replace(LOCALIZATION_FILES_FOLDER, "");
            LocaleInfo localeInfo = androidLocalizationSchema.getLocaleInfoFromID(string3);
            ProjectLocalizationManager projectLocalizationManager = null;
            try {
                projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(iProject, false);
            }
            catch (IOException iOException) {}
            if (localeInfo.getLocaleAttributes().size() > 0 || string.equalsIgnoreCase(LOCALIZATION_FILES_FOLDER)) {
                LocalizationFile localizationFile = projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
                if (localizationFile != null && !localizationFile.isToBeDeleted()) {
                    string2 = Messages.AndroidNewColumnProvider_Dialog_FileAlreadyExists;
                }
            } else {
                string2 = this.NEW_COLUMN_INVALID_ID;
            }
        } else {
            string2 = this.NEW_COLUMN_INVALID_ID;
        }
        return string2;
    }

    public String getEditorName() {
        return Messages.AndroidStringEditorInput_EditorTooltip;
    }

    public void createFile(LocalizationFile localizationFile) throws SequoyahException {
        try {
            DocumentBuilder documentBuilder;
            DocumentBuilderFactory documentBuilderFactory;
            String string = localizationFile.getFile().getFullPath().toOSString();
            if (!localizationFile.getFile().exists()) {
                localizationFile.getFile().getLocation();
                documentBuilderFactory = null;
                documentBuilderFactory = localizationFile.getLocalizationProject() != null ? new Path(localizationFile.getLocalizationProject().getProject().getLocation() + string) : localizationFile.getFile().getLocation();
                documentBuilderFactory.removeLastSegments(1).toFile().mkdirs();
                documentBuilderFactory.toFile().createNewFile();
                if (localizationFile.getLocalizationProject() != null) {
                    documentBuilder = localizationFile.getLocalizationProject().getProject().getFile((IPath)new Path(string));
                    localizationFile.setFile((IFile)documentBuilder);
                }
            }
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("resources");
            for (StringNode stringNode : localizationFile.getStringNodes()) {
                this.addSingleEntry(document, element, stringNode);
            }
            for (StringNode stringNode : localizationFile.getStringArrays()) {
                this.addArrayEntry(document, element, (StringArray)stringNode);
            }
            document.appendChild(element);
            this.saveXMLDocument(localizationFile.getFile().getLocation().toFile(), document);
            ((AndroidLocalizationFile)localizationFile).setSavedXMLDocument(document);
            localizationFile.getFile().getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            throw new SequoyahException();
        }
    }

    private void addArrayEntry(Document document, Element element, StringArray stringArray) {
        Element element2 = document.createElement("string-array");
        element2.setAttribute("name", stringArray.getKey());
        for (StringNode stringNode : stringArray.getValues()) {
            this.createArrayItem(document, element2, stringNode);
        }
        element.appendChild(element2);
    }

    private void createArrayItem(Document document, Element element, StringNode stringNode) {
        Element element2 = document.createElement("item");
        element2.appendChild(document.createTextNode(stringNode.getValue()));
        element.appendChild(element2);
        this.createOrUpdateComment(document, stringNode, element2);
    }

    private void addSingleEntry(Document document, Element element, StringNode stringNode) {
        if (!stringNode.isArray()) {
            Element element2 = document.createElement("string");
            element2.setAttribute("name", stringNode.getKey());
            element2.appendChild(document.createTextNode(stringNode.getValue()));
            this.createOrUpdateComment(document, stringNode, element2);
            element.appendChild(element2);
        }
    }

    private void createOrUpdateComment(Document document, StringNode stringNode, Element element) {
        StringNodeComment stringNodeComment = stringNode.getStringNodeComment();
        if (stringNodeComment != null && stringNodeComment.getComment() != null && stringNodeComment.getComment().length() > 0) {
            Comment comment = document.createComment(stringNodeComment.getComment());
            element.appendChild(comment);
        }
    }

    private void saveXMLDocument(File file, Document document) throws TransformerFactoryConfigurationError, TransformerConfigurationException, FileNotFoundException, UnsupportedEncodingException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        try {
            StreamResult streamResult = new StreamResult(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.unescapeEntity(file);
    }

    private String getXMLAsString(Document document) {
        String string = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            string = stringWriter.toString();
            string = this.unescapeEntity(string);
        }
        catch (Exception exception) {}
        return string;
    }

    public String getLocaleToolTip(IPath iPath) {
        LocaleInfo localeInfo = this.getLocaleInfoFromPath(iPath);
        List list = localeInfo.getLocaleAttributes();
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (string.length() > 0) {
                string = String.valueOf(string) + "\n ";
            }
            LocaleAttribute localeAttribute = (LocaleAttribute)iterator.next();
            string = String.valueOf(string) + ((AndroidLocaleAttribute)localeAttribute).getDisplayName() + ": " + ((AndroidLocaleAttribute)localeAttribute).getDisplayValue();
        }
        if (string.length() == 0) {
            string = this.DEFAULT_LOCALE_TOOLTIP;
        }
        return string;
    }

    private String unescapeEntity(String string) {
        String string2 = string;
        string2 = string2.replaceAll("&lt;", "<");
        string2 = string2.replaceAll("&gt;", ">");
        string2 = string2.replaceAll("&#13;", "");
        return string2;
    }

    private void unescapeEntity(File file) {
        File file2 = null;
        FilterOutputStream filterOutputStream = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                file2 = File.createTempFile("temp_localization", "dom");
                FileUtil.copyFile((File)file, (File)file2);
                fileInputStream = new FileInputStream(file2);
                fileOutputStream = new FileOutputStream(file);
                filterOutputStream = new DataOutputStream(fileOutputStream);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                String string = null;
                string = bufferedReader.readLine();
                while (string != null) {
                    string = this.unescapeEntity(string);
                    filterOutputStream.write(string.getBytes("UTF-8"));
                    String string2 = System.getProperty("line.separator");
                    filterOutputStream.write(string2.getBytes("UTF-8"));
                    string = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
                BasePlugin.logError((String)"Error translating file.", (Throwable)exception);
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                        bufferedReader = null;
                    }
                }
                catch (IOException iOException) {
                    BasePlugin.logError((String)"Error cleaning up objects after translation", (Throwable)iOException);
                }
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {
                        BasePlugin.logError((String)"Error closing file after translation", (Throwable)iOException);
                    }
                    filterOutputStream = null;
                }
                if (file2 != null && !file2.delete()) {
                    file2.deleteOnExit();
                }
                file = null;
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (IOException iOException) {
                BasePlugin.logError((String)"Error cleaning up objects after translation", (Throwable)iOException);
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    BasePlugin.logError((String)"Error closing file after translation", (Throwable)iOException);
                }
                filterOutputStream = null;
            }
            if (file2 != null && !file2.delete()) {
                file2.deleteOnExit();
            }
            file = null;
        }
    }

    public List<LocaleAttribute> getLocaleAttributes() {
        ArrayList<LocaleAttribute> arrayList = new ArrayList<LocaleAttribute>();
        arrayList.add(new AndroidLocaleAttribute(new Integer(123), AndroidLocaleAttribute.AndroidLocaleAttributes.COUNTRY_CODE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(new Integer(0), AndroidLocaleAttribute.AndroidLocaleAttributes.NETWORK_CODE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.LANGUAGE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.REGION.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_SIZE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ASPECT.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.DOCK_MODE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.NIGHT_MODE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(new Integer(12), AndroidLocaleAttribute.AndroidLocaleAttributes.PIXEL_DENSITY.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.TOUCH_TYPE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.KEYBOARD_STATE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(new Dimension(1, 1), AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal()));
        return arrayList;
    }

    public List<String> getLocalizationFileExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("xml");
        return arrayList;
    }

    public Map<LocaleInfo, IFile> getLocalizationFiles(IProject iProject) {
        LinkedHashMap<LocaleInfo, IFile> linkedHashMap;
        block12: {
            linkedHashMap = new LinkedHashMap<LocaleInfo, IFile>();
            boolean bl = false;
            try {
                IFolder iFolder;
                IFolder iFolder2;
                IResource iResource = iProject.findMember("res");
                if (iResource != null && iResource instanceof IFolder && (iFolder2 = ((IFolder)iResource).members()) != null) {
                    IFolder iFolder3 = iFolder2;
                    int n = ((IFolder)iFolder3).length;
                    int n2 = 0;
                    while (n2 < n) {
                        iFolder = iFolder3[n2];
                        if (iFolder.getName().startsWith(LOCALIZATION_FILES_FOLDER)) {
                            IResource[] iResourceArray;
                            IResource[] iResourceArray2 = iResourceArray = iFolder.members();
                            int n3 = iResourceArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource iResource2 = iResourceArray2[n4];
                                if (iResource2 instanceof IFile && this.isLocalizationFile((IFile)iResource2)) {
                                    linkedHashMap.put(this.getLocaleInfoFromPath(iResource2.getProjectRelativePath()), (IFile)iResource2);
                                    if (iFolder.getName().equals(LOCALIZATION_FILES_FOLDER)) {
                                        bl = true;
                                    }
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                if (bl || !(iResource instanceof IFolder)) break block12;
                iFolder2 = (IFolder)iResource;
                iFolder = iFolder2.getFolder(LOCALIZATION_FILES_FOLDER);
                try {
                    if (!iFolder.exists()) {
                        PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    iFolder.create(true, true, iProgressMonitor);
                                }
                                catch (CoreException coreException) {}
                            }
                        });
                    }
                    if (iFolder.exists()) {
                        IFile iFile = iFolder.getFile(LOCALIZATION_FILE_NAME);
                        linkedHashMap.put(this.getLocaleInfoFromPath(iFile.getProjectRelativePath()), iFile);
                    }
                }
                catch (Exception exception) {}
            }
            catch (CoreException coreException) {}
        }
        return linkedHashMap;
    }

    public boolean isLocalizationFile(IFile iFile) {
        boolean bl = false;
        if (iFile != null && iFile.getProjectRelativePath().toString().matches("res/values.*/strings.xml")) {
            bl = true;
        }
        return bl;
    }

    public Map<LocaleInfo, LocalizationFile> loadAllFiles(IProject iProject) throws IOException {
        LinkedHashMap<LocaleInfo, LocalizationFile> linkedHashMap = new LinkedHashMap<LocaleInfo, LocalizationFile>();
        Map<LocaleInfo, IFile> map = this.getLocalizationFiles(iProject);
        for (Map.Entry<LocaleInfo, IFile> entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey(), this.loadFile(entry.getValue()));
        }
        return linkedHashMap;
    }

    public LocalizationFile loadFile(IFile iFile) throws IOException {
        Object object;
        AndroidLocalizationFile androidLocalizationFile = null;
        LocaleInfo localeInfo = this.getLocaleInfoFromPath(iFile.getFullPath());
        if (!iFile.exists()) {
            object = new AndroidLocalizationFile(iFile, localeInfo, null, null);
            try {
                this.createFile((LocalizationFile)object);
            }
            catch (SequoyahException sequoyahException) {}
        }
        try {
            Document document;
            if (System.getProperty("java.version").startsWith("1.5")) {
                object = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                document = documentBuilder.parse(new File(iFile.getLocation().toString()));
            } else {
                object = new FileInputStream(iFile.getLocation().toFile());
                DOMImplementation dOMImplementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0");
                DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
                LSInput lSInput = dOMImplementationLS.createLSInput();
                LSParser lSParser = dOMImplementationLS.createLSParser((short)1, "http://www.w3.org/2001/XMLSchema");
                LocalizationXMLParserFilter localizationXMLParserFilter = new LocalizationXMLParserFilter();
                lSParser.setFilter(localizationXMLParserFilter);
                lSInput.setEncoding("UTF-8");
                lSInput.setByteStream((InputStream)object);
                document = lSParser.parse(lSInput);
            }
            androidLocalizationFile = new AndroidLocalizationFile(iFile, localeInfo, new ArrayList<StringNode>(), new ArrayList<StringArray>());
            this.updateLocalizationFileContent((LocalizationFile)androidLocalizationFile, document);
        }
        catch (Exception exception) {
            throw new IOException(String.valueOf(Messages.AndroidLocalizationSchema_Exception_CouldNotLoadFile) + iFile.getName() + ". " + exception.getMessage());
        }
        return androidLocalizationFile;
    }

    private void getStringByNodes(StringBuffer stringBuffer, Node node) {
        Node node2 = node;
        while (node2 != null) {
            if (node2.getNodeName() != null && node2.getNodeType() == 1) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                String string = "";
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node3 = namedNodeMap.item(n);
                    string = String.valueOf(string) + " " + node3.toString();
                    ++n;
                }
                stringBuffer.append("<" + node2.getNodeName() + string + ">");
                if (node2.hasChildNodes()) {
                    this.getStringByNodes(stringBuffer, node2.getFirstChild());
                } else if (node2.getNodeType() != 8) {
                    stringBuffer.append(node2.getTextContent());
                }
                stringBuffer.append("</" + node2.getNodeName() + ">");
            } else if (node2.getNodeType() != 8) {
                stringBuffer.append(node2.getTextContent());
            }
            node2 = node2.getNextSibling();
        }
    }

    private void updateFile(LocalizationFile localizationFile, Document document) throws SequoyahException {
        AndroidLocalizationFile androidLocalizationFile = (AndroidLocalizationFile)localizationFile;
        if (document == null) {
            this.createFile(androidLocalizationFile);
            document = androidLocalizationFile.getSavedXMLDocument();
        } else {
            Object object2;
            StringNode stringNode2;
            HashMap<String, StringNode> hashMap = new HashMap<String, StringNode>();
            for (StringNode stringNode2 : localizationFile.getStringNodes()) {
                if (stringNode2.isArray()) continue;
                hashMap.put(stringNode2.getKey(), stringNode2);
            }
            stringNode2 = new HashMap();
            for (Object object2 : localizationFile.getStringArrays()) {
                stringNode2.put(object2.getKey(), object2);
            }
            object2 = document.getElementsByTagName("resources");
            if (object2.getLength() == 0) {
                Element element = document.createElement("resources");
                document.appendChild(element);
                object2 = document.getElementsByTagName("resources");
            }
            int n = 0;
            while (n < object2.getLength()) {
                Element element = (Element)object2.item(n);
                this.visitToRemoveDOMChildren(document, element.getFirstChild(), "name", androidLocalizationFile.getSingleEntryToRemove(), androidLocalizationFile.getArrayEntryToRemove(), androidLocalizationFile.getArrayItemsToRemove());
                this.visitToUpdateDOMChildren(document, element.getFirstChild(), "name", hashMap, (Map<String, StringArray>)stringNode2);
                this.visitToAddDOMChildren(document, hashMap, (Map<String, StringArray>)stringNode2, element);
                ++n;
            }
        }
    }

    public void updateFile(LocalizationFile localizationFile) throws SequoyahException {
        AndroidLocalizationFile androidLocalizationFile = (AndroidLocalizationFile)localizationFile;
        Document document = androidLocalizationFile.getSavedXMLDocument();
        this.updateFile(androidLocalizationFile, document);
        if (document == null) {
            document = androidLocalizationFile.getSavedXMLDocument();
        }
        try {
            this.saveXMLDocument(localizationFile.getFile().getLocation().toFile(), document);
        }
        catch (Exception exception) {
            SequoyahException sequoyahException = new SequoyahException();
            sequoyahException.setStackTrace(exception.getStackTrace());
            throw sequoyahException;
        }
        localizationFile.setDirty(false);
    }

    private void visitToAddDOMChildren(Document document, Map<String, StringNode> map, Map<String, StringArray> map2, Element element) {
        StringNode stringNode;
        for (Map.Entry<String, StringNode> entry : map.entrySet()) {
            stringNode = entry.getValue();
            this.addSingleEntry(document, element, stringNode);
        }
        for (Map.Entry<String, StringNode> entry : map2.entrySet()) {
            stringNode = (StringArray)entry.getValue();
            this.addArrayEntry(document, element, (StringArray)stringNode);
        }
    }

    public void visitToRemoveDOMChildren(Document document, Node node, String string, Map<String, StringNode> map, Map<String, StringArray> map2, Map<String, StringNode> map3) {
        while (node != null) {
            Attr attr;
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 1 && (attr = AndroidLocalizationSchema.getAttribute((Element)node, string)) != null) {
                String string2 = attr.getValue();
                StringNode stringNode = map.get(string2);
                if (stringNode != null) {
                    node.getParentNode().removeChild(node);
                } else {
                    StringArray stringArray = map2.get(string2);
                    if (stringArray != null) {
                        node.getParentNode().removeChild(node);
                    } else {
                        NodeList nodeList = node.getChildNodes();
                        int n = 0;
                        while (n < nodeList.getLength()) {
                            Node node3 = nodeList.item(n);
                            if (node3 instanceof Element) {
                                Element element = (Element)node3;
                                DecimalFormat decimalFormat = new DecimalFormat("000");
                                String string3 = String.valueOf(string2) + "_" + decimalFormat.format(n);
                                StringNode stringNode2 = map3.get(string3);
                                if (stringNode2 != null) {
                                    element.getParentNode().removeChild(element);
                                }
                            }
                            ++n;
                        }
                    }
                }
            }
            node = node2;
        }
    }

    public void visitToUpdateDOMChildren(Document document, Node node, String string, Map<String, StringNode> map, Map<String, StringArray> map2) {
        while (node != null) {
            Attr attr;
            if (node.getNodeType() == 1 && (attr = AndroidLocalizationSchema.getAttribute((Element)node, string)) != null) {
                String string2;
                String string3 = attr.getValue();
                StringNode stringNode = map.get(string3);
                if (stringNode != null) {
                    string2 = stringNode.getValue();
                    node.setTextContent(string2);
                    this.createOrUpdateComment(document, stringNode, (Element)node);
                    map.remove(string3);
                } else {
                    string2 = map2.get(string3);
                    if (string2 != null) {
                        Element element;
                        Node node2;
                        NodeList nodeList = node.getChildNodes();
                        List list = string2.getValues();
                        int n = 0;
                        int n2 = 0;
                        while (n < nodeList.getLength() && n2 < list.size()) {
                            node2 = nodeList.item(n);
                            if (node2 instanceof Element) {
                                element = (Element)node2;
                                StringNode stringNode2 = (StringNode)list.get(n2);
                                String string4 = stringNode2.getValue();
                                element.setTextContent(string4);
                                this.createOrUpdateComment(document, stringNode2, element);
                                map2.remove(string3);
                                ++n2;
                            }
                            ++n;
                        }
                        while (n2 < list.size()) {
                            if (!(node instanceof Element)) continue;
                            node2 = (Element)node;
                            element = (StringNode)list.get(n2);
                            this.createArrayItem(document, (Element)node2, (StringNode)element);
                            ++n2;
                        }
                    }
                }
            }
            node = node.getNextSibling();
        }
    }

    private boolean isKnownNode(Node node) {
        return node.getNodeName().equals("string") || node.getNodeName().equals("string-array");
    }

    public static Attr getAttribute(Element element, String string) {
        Attr attr = element.getAttributeNode(string);
        return attr;
    }

    private LocaleInfo getLocaleInfoFromPath(IPath iPath) {
        IPath iPath2 = iPath;
        iPath2 = iPath.removeLastSegments(1);
        String string = iPath2.lastSegment();
        String string2 = string.replace(LOCALIZATION_FILES_FOLDER, "");
        return this.getLocaleInfoFromID(string2);
    }

    public String getPathFromLocaleInfo(LocaleInfo localeInfo) {
        String string = localeInfo.getLocaleAttributes().size() > 0 ? "res" + File.separator + LOCALIZATION_FILES_FOLDER + "-" + this.getLocaleID(localeInfo) + File.separator + LOCALIZATION_FILE_NAME : "res" + File.separator + LOCALIZATION_FILES_FOLDER + File.separator + LOCALIZATION_FILE_NAME;
        return string;
    }

    public String getLocaleID(LocaleInfo localeInfo) {
        String string = "";
        List list = localeInfo.getLocaleAttributes();
        for (LocaleAttribute localeAttribute : list) {
            if (!((AndroidLocaleAttribute)localeAttribute).isSet()) continue;
            if (string.length() != 0) {
                string = String.valueOf(string) + "-";
            }
            string = String.valueOf(string) + localeAttribute.getFolderValue();
        }
        return string;
    }

    public LocaleInfo getLocaleInfoFromID(String string) {
        LocaleInfo localeInfo = new LocaleInfo();
        String[] stringArray = string.split("-");
        int n = -1;
        ArrayList<AndroidLocaleAttribute> arrayList = new ArrayList<AndroidLocaleAttribute>();
        int n2 = 1;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].equals("")) {
                if (this.isCountryCodeSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.COUNTRY_CODE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.COUNTRY_CODE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.COUNTRY_CODE.ordinal()));
                } else if (this.isNetworkCodeSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.NETWORK_CODE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.NETWORK_CODE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.NETWORK_CODE.ordinal()));
                } else if (this.isLanguageSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.LANGUAGE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.LANGUAGE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.LANGUAGE.ordinal()));
                } else if (this.isRegionSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.REGION.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.REGION.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.REGION.ordinal()));
                } else if (this.isScreenSizeSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_SIZE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_SIZE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_SIZE.ordinal()));
                } else if (this.isScreenAspectSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ASPECT.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ASPECT.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ASPECT.ordinal()));
                } else if (this.isOrientationSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal()));
                } else if (this.isDockSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.DOCK_MODE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.DOCK_MODE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.DOCK_MODE.ordinal()));
                } else if (this.isNightSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.NIGHT_MODE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.NIGHT_MODE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.NIGHT_MODE.ordinal()));
                } else if (this.isPixelDensitySegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.PIXEL_DENSITY.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.PIXEL_DENSITY.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.PIXEL_DENSITY.ordinal()));
                } else if (this.isTouchTypeSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.TOUCH_TYPE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.TOUCH_TYPE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.TOUCH_TYPE.ordinal()));
                } else if (this.isKeyboardStateSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.KEYBOARD_STATE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.KEYBOARD_STATE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.KEYBOARD_STATE.ordinal()));
                } else if (this.isTextInputSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal()));
                } else if (this.isNavigationKeySegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal()));
                } else if (this.isNavigationSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal()));
                } else if (this.isDimensionSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal()));
                } else if (this.isAPIVersionSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.API_VERSION.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.API_VERSION.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.API_VERSION.ordinal()));
                } else {
                    arrayList = new ArrayList();
                }
            }
            ++n2;
        }
        localeInfo.setLocaleAttributes(arrayList);
        return localeInfo;
    }

    public String getISO639LangFromID(String string) {
        String string2 = null;
        LocaleInfo localeInfo = this.getLocaleInfoFromID(string);
        for (LocaleAttribute localeAttribute : localeInfo.getLocaleAttributes()) {
            if (!localeAttribute.getDisplayName().equals("Language")) continue;
            string2 = localeAttribute.getFolderValue();
        }
        return string2;
    }

    public String getDefaultID() {
        return LOCALIZATION_FILES_FOLDER;
    }

    private boolean isScreenAspectSegment(String string) {
        return string.equalsIgnoreCase("long") || string.equalsIgnoreCase("notlong");
    }

    private boolean isDockSegment(String string) {
        return string.equalsIgnoreCase("car") || string.equalsIgnoreCase("desk");
    }

    private boolean isNightSegment(String string) {
        return string.equalsIgnoreCase("night") || string.equalsIgnoreCase("notnight");
    }

    private boolean isNavigationKeySegment(String string) {
        return string.equalsIgnoreCase("navexposed") || string.equalsIgnoreCase("navhidden");
    }

    private boolean isLanguageSegment(String string) {
        return string.length() == 2;
    }

    private boolean isRegionSegment(String string) {
        return string.startsWith("r") && string.length() == 3;
    }

    private boolean isOrientationSegment(String string) {
        return string.equalsIgnoreCase("port") || string.equalsIgnoreCase("land") || string.equalsIgnoreCase("square");
    }

    private boolean isPixelDensitySegment(String string) {
        return string.endsWith("dpi");
    }

    private boolean isTouchTypeSegment(String string) {
        return string.equalsIgnoreCase("notouch") || string.equalsIgnoreCase("stylus") || string.equalsIgnoreCase("finger");
    }

    private boolean isKeyboardStateSegment(String string) {
        return string.equalsIgnoreCase("keysexposed") || string.equalsIgnoreCase("keyshidden");
    }

    private boolean isTextInputSegment(String string) {
        return string.equalsIgnoreCase("nokeys") || string.equalsIgnoreCase("qwerty") || string.equalsIgnoreCase("12key");
    }

    private boolean isNavigationSegment(String string) {
        return string.equalsIgnoreCase("dpad") || string.equalsIgnoreCase("trackball") || string.equalsIgnoreCase("wheel") || string.equalsIgnoreCase("nonav");
    }

    private boolean isDimensionSegment(String string) {
        String[] stringArray;
        boolean bl = false;
        if (string.contains("x") && (stringArray = string.split("x")).length == 2) {
            bl = true;
        }
        return bl;
    }

    private boolean isCountryCodeSegment(String string) {
        boolean bl = false;
        if (string.startsWith("mcc") && string.length() <= 6) {
            String string2 = string;
            String string3 = string2.substring(3, string2.length());
            try {
                Integer.valueOf(Integer.parseInt(string3));
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    private boolean isNetworkCodeSegment(String string) {
        boolean bl = false;
        if (string.startsWith("mnc") && string.length() <= 6) {
            String string2 = string;
            String string3 = string2.substring(3, string2.length());
            try {
                Integer.valueOf(Integer.parseInt(string3));
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    private boolean isScreenSizeSegment(String string) {
        return string.equalsIgnoreCase("large") || string.equalsIgnoreCase("xlarge") || string.equalsIgnoreCase("normal") || string.equalsIgnoreCase("small");
    }

    private boolean isAPIVersionSegment(String string) {
        boolean bl = false;
        if (string.startsWith("v")) {
            String string2 = string;
            String string3 = string2.substring(1, string2.length());
            try {
                Integer.valueOf(Integer.parseInt(string3));
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    public LocalizationFile createLocalizationFile(IFile iFile, LocaleInfo localeInfo, List<StringNode> list, List<StringArray> list2) {
        return new AndroidLocalizationFile(iFile, localeInfo, list, list2);
    }

    public String getLocalizationFileContent(LocalizationFile localizationFile) {
        String string = null;
        if (localizationFile instanceof AndroidLocalizationFile) {
            AndroidLocalizationFile androidLocalizationFile = (AndroidLocalizationFile)localizationFile;
            try {
                this.updateFile(androidLocalizationFile, androidLocalizationFile.getSavedXMLDocument());
            }
            catch (SequoyahException sequoyahException) {}
            string = this.getXMLAsString(androidLocalizationFile.getSavedXMLDocument());
        }
        return string;
    }

    private void updateLocalizationFileContent(LocalizationFile localizationFile, Document document) {
        NodeList nodeList;
        Object object;
        Node node;
        String string;
        Object object2;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        NodeList nodeList2 = document.getElementsByTagName("string");
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < nodeList2.getLength()) {
            Object object3;
            object2 = (Element)nodeList2.item(n);
            string2 = object2.getAttributeNode("name").getNodeValue();
            string = null;
            if (object2.hasChildNodes()) {
                object3 = object2.getChildNodes();
                int n2 = 0;
                while (n2 < object3.getLength()) {
                    node = object3.item(n2);
                    if (node.getNodeType() == 8) {
                        string = node.getNodeValue();
                    }
                    ++n2;
                }
            }
            object3 = object2.getFirstChild();
            object = new StringBuffer();
            this.getStringByNodes((StringBuffer)object, (Node)object3);
            string3 = ((StringBuffer)object).toString();
            object2.toString();
            node = new StringNode(string2, string3);
            if (string != null) {
                nodeList = new StringNodeComment();
                nodeList.setComment(string);
                node.setStringNodeComment((StringNodeComment)nodeList);
            }
            arrayList.add(node);
            ++n;
        }
        NodeList nodeList3 = document.getElementsByTagName("string-array");
        object2 = null;
        string = null;
        int n3 = 0;
        while (n3 < nodeList3.getLength()) {
            object = (Element)nodeList3.item(n3);
            object2 = object.getAttributeNode("name").getNodeValue();
            node = new StringArray((String)object2);
            if (object.hasChildNodes()) {
                nodeList = object.getElementsByTagName("item");
                int n4 = 0;
                while (n4 < nodeList.getLength()) {
                    NodeList nodeList4;
                    Node node2 = nodeList.item(n4);
                    Node node3 = node2.getFirstChild();
                    StringBuffer stringBuffer = new StringBuffer();
                    this.getStringByNodes(stringBuffer, node3);
                    string = stringBuffer.toString();
                    StringNode stringNode = node.addValue(string);
                    String string4 = null;
                    if (node2.hasChildNodes()) {
                        nodeList4 = node2.getChildNodes();
                        int n5 = 0;
                        while (n5 < nodeList4.getLength()) {
                            Node node4 = nodeList4.item(n5);
                            if (node4.getNodeType() == 8) {
                                string4 = node4.getNodeValue();
                            }
                            ++n5;
                        }
                    }
                    if (string4 != null) {
                        nodeList4 = new StringNodeComment();
                        nodeList4.setComment(string4);
                        stringNode.setStringNodeComment((StringNodeComment)nodeList4);
                    }
                    ++n4;
                }
            }
            arrayList2.add(node);
            ++n3;
        }
        localizationFile.setStringNodes(arrayList);
        localizationFile.setStringArrays(arrayList2);
        ((AndroidLocalizationFile)localizationFile).setSavedXMLDocument(document);
    }

    public void updateLocalizationFileContent(LocalizationFile localizationFile, String string) throws SequoyahException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            Document document = documentBuilder.parse(byteArrayInputStream);
            this.updateLocalizationFileContent(localizationFile, document);
        }
        catch (Exception exception) {
            SequoyahExceptionStatus sequoyahExceptionStatus = new SequoyahExceptionStatus(4, "org.eclipse.sequoyah.localization.android", 0, String.valueOf(Messages.AndroidLocalizationSchema_6) + localizationFile.getFile().getFullPath(), (Throwable)exception);
            throw new SequoyahException((AbstractExceptionStatus)sequoyahExceptionStatus);
        }
    }

    public boolean keyAcceptsBlankSpaces() {
        return false;
    }
}

