/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.wizard;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.internal.model.MobileDeviceType;
import org.eclipse.sequoyah.device.framework.model.AbstractMobileInstance;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.ui.DeviceUIResources;
import org.eclipse.sequoyah.device.framework.ui.wizard.NewDeviceMenuWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DefaultDeviceTypeMenuWizardPage
extends WizardPage {
    private Text nameText;
    private MobileDeviceType currentDeviceType;
    private static String contextId = null;

    protected DefaultDeviceTypeMenuWizardPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
    }

    protected DefaultDeviceTypeMenuWizardPage(String string, String string2) {
        super(string);
        this.setTitle(DeviceUIResources.SEQUOYAH_Default_Device_Type_Wizard_Page_title);
        this.setMessage(DeviceUIResources.SEQUOYAH_Default_Device_Type_Wizard_Page_message);
        Object[] objectArray = DeviceTypeRegistry.getInstance().getDeviceTypes().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (((IDeviceType)object).getId().equals(string2)) {
                this.currentDeviceType = (MobileDeviceType)object;
            }
            ++n2;
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setText(DeviceUIResources.SEQUOYAH_Default_Device_Type_Wizard_Page_name);
        label.setFont(composite2.getFont());
        this.nameText = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.setFont(composite2.getFont());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
                String string = DefaultDeviceTypeMenuWizardPage.this.nameText.getText();
                String string2 = null;
                if (string != null && !string.equals("")) {
                    if (instanceRegistry.getInstancesByName(string).size() != 0) {
                        string2 = DeviceUIResources.SEQUOYAH_Emulator_Wizard_Project_Description_Duplicated_Error;
                    } else if (!AbstractMobileInstance.validName((String)string)) {
                        string2 = DeviceUIResources.SEQUOYAH_Instance_Name_Invalid_Error;
                    }
                }
                DefaultDeviceTypeMenuWizardPage.this.setErrorMessage(string2);
                DefaultDeviceTypeMenuWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.createDeviceTypesArea(composite2);
        if (contextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, contextId);
        }
        this.setControl((Control)composite2);
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.nameText.getText().trim() != "" && this.currentDeviceType != null;
    }

    private void createDeviceTypesArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(String.valueOf(DeviceUIResources.SEQUOYAH_Default_Device_Type_Wizard_Page_deviceTypes) + " " + this.currentDeviceType.getLabel());
        label.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        IWizard iWizard = this.getWizard();
        if (iWizard instanceof NewDeviceMenuWizard) {
            ((NewDeviceMenuWizard)iWizard).setCurrentDeviceTypeId(this.currentDeviceType.getId());
        }
    }

    public String getInstanceName() {
        return this.nameText.getText().trim();
    }

    public MobileDeviceType getDeviceType() {
        return this.currentDeviceType;
    }

    public static String getHelpContextId() {
        return contextId;
    }

    public static void setHelpContextId(String string) {
        contextId = string;
    }
}

