/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.sequoyah.device.framework.manager.ServiceManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandlerAction;
import org.eclipse.sequoyah.device.framework.ui.DeviceUIPlugin;
import org.eclipse.sequoyah.device.framework.ui.view.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceServicesComposite
extends Composite {
    private static boolean showAllServices = true;
    private static int buttonsOrienation = 256;
    private List<IInstance> instances = null;
    private static final String SERVICES_LABEL = Messages.InstanceServicesComposite_1;
    private static final String SERVICES_FILTERED_LABEL = Messages.InstanceServicesComposite_2;
    private static final String NO_LABEL = "";
    private static final int DEFAULT_BUTTONS_WIDTH = 120;
    private static final int DEFAULT_BUTTONS_HEIGHT = 30;
    private static final int MAX_BUTTON_STRING_SIZE = 12;
    private static final int DEFAULT_BUTTON_IMAGE_SIZE = 16;
    public static final String AVAILABILITY_TOOL_TIP_TEXT = Messages.InstanceServicesComposite_0;
    private CLabel label;
    private ToolBar toolBar;
    private ViewForm viewForm;
    private Listener createServicesAreaListener = new Listener(){

        public void handleEvent(Event event) {
            InstanceServicesComposite.this.createServicesArea();
        }
    };

    public InstanceServicesComposite(Composite composite) {
        super(composite, 0);
        this.createContents();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                InstanceServicesComposite.this.label.dispose();
                InstanceServicesComposite.this.label = null;
                InstanceServicesComposite.this.toolBar.dispose();
                InstanceServicesComposite.this.toolBar = null;
            }
        });
    }

    public void setSelectedInstances(List<IInstance> list) {
        this.instances = list;
        this.createServicesArea();
    }

    private void createContents() {
        this.setLayout((Layout)new FillLayout());
        this.viewForm = new ViewForm((Composite)this, 0);
        this.viewForm.setLayout((Layout)new GridLayout());
        this.createToolbarArea();
        this.createServicesArea();
    }

    private void createToolbarArea() {
        this.label = new CLabel((Composite)this.viewForm, 0);
        this.label.setText(Messages.InstanceServicesComposite_6);
        this.viewForm.setTopLeft((Control)this.label);
        this.toolBar = new ToolBar((Composite)this.viewForm, 0x800040);
        this.viewForm.setTopCenter((Control)this.toolBar);
        ToolBarManager toolBarManager = new ToolBarManager(this.toolBar);
        toolBarManager.add((IAction)new ServicesFilterAction());
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new ServicesOrientationAction());
        toolBarManager.update(true);
    }

    private void createServicesArea() {
        List list;
        Control control = this.viewForm.getContent();
        this.viewForm.setContent(null);
        if (control != null) {
            control.dispose();
            control = null;
        }
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.viewForm, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setBackground(this.getDisplay().getSystemColor(1));
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.pack = false;
        rowLayout.justify = false;
        rowLayout.type = buttonsOrienation;
        rowLayout.marginLeft = 5;
        rowLayout.marginTop = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginBottom = 5;
        rowLayout.spacing = 5;
        composite.setLayout((Layout)rowLayout);
        if (this.instances != null && !this.instances.isEmpty()) {
            list = ServiceManager.getCommonServices(this.instances, (this.instances.size() > 1 ? 1 : 0) != 0);
            List list2 = ServiceManager.getAllServices(this.instances, (boolean)false);
            ArrayList<Button> arrayList = new ArrayList<Button>();
            for (IService iService : list2) {
                if (!iService.isVisible() || !showAllServices && !list.contains(iService)) continue;
                Button button = new Button(composite, 8);
                arrayList.add(button);
                button.setEnabled(list.contains(iService));
                button.addListener(13, (Listener)new ServiceHandlerAction(this.instances, iService.getId()));
                button.addListener(13, this.createServicesAreaListener);
                button.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        Listener[] listenerArray;
                        Listener[] listenerArray2 = listenerArray = disposeEvent.widget.getListeners(13);
                        int n = listenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Listener listener = listenerArray2[n2];
                            disposeEvent.widget.removeListener(13, listener);
                            ++n2;
                        }
                    }
                });
                RowData rowData = new RowData();
                rowData.width = 120;
                rowData.height = 30;
                button.setLayoutData((Object)rowData);
                String string = iService.getName();
                button.setToolTipText(string);
                if (string.length() > 12) {
                    string = string.substring(0, 12).concat("...");
                }
                button.setText(string);
                if (iService.getImage() == null) continue;
                ImageData imageData = iService.getImage().getImageData().scaledTo(16, 16);
                Image image = new Image((Device)button.getDisplay(), imageData);
                button.setImage(image);
            }
        }
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        list = composite.computeSize(-1, -1);
        scrolledComposite.setMinSize(130, ((Point)list).y);
        this.viewForm.setContent((Control)scrolledComposite);
        if (this.instances == null) {
            this.label.setText(NO_LABEL);
            this.toolBar.setVisible(false);
        } else {
            if (showAllServices) {
                this.label.setText(SERVICES_LABEL);
            } else {
                this.label.setText(SERVICES_FILTERED_LABEL);
            }
            this.toolBar.setVisible(true);
        }
    }

    private class ServicesFilterAction
    extends Action {
        public ServicesFilterAction() {
            super(Messages.InstanceServicesComposite_3);
            PlatformUI.getPreferenceStore().setDefault("org.eclipse.sequoyah.device.framework.uiSERVICE_BUTTONS_ORIENTATION", 256);
            PlatformUI.getPreferenceStore().setDefault("org.eclipse.sequoyah.device.framework.uiFILTER_SERVICE_BY_AVAILABILITY", false);
            showAllServices = !PlatformUI.getPreferenceStore().getBoolean("org.eclipse.sequoyah.device.framework.uiFILTER_SERVICE_BY_AVAILABILITY");
            this.setToolTipText(AVAILABILITY_TOOL_TIP_TEXT);
            this.setChecked(!showAllServices);
            this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_FILTER"));
        }

        public void run() {
            showAllServices = !showAllServices;
            this.setChecked(!showAllServices);
            PlatformUI.getPreferenceStore().setValue("org.eclipse.sequoyah.device.framework.uiFILTER_SERVICE_BY_AVAILABILITY", !showAllServices);
            InstanceServicesComposite.this.createServicesArea();
        }
    }

    private class ServicesOrientationAction
    extends Action {
        public ServicesOrientationAction() {
            super(Messages.InstanceServicesComposite_4);
            buttonsOrienation = PlatformUI.getPreferenceStore().getInt("org.eclipse.sequoyah.device.framework.uiSERVICE_BUTTONS_ORIENTATION");
            this.setToolTipText(Messages.InstanceServicesComposite_5);
            if (buttonsOrienation == 256) {
                this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_HORIZONTAL"));
            } else {
                this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_VERTICAL"));
            }
        }

        public void run() {
            if (buttonsOrienation == 256) {
                buttonsOrienation = 512;
                this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_VERTICAL"));
            } else {
                buttonsOrienation = 256;
                this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_HORIZONTAL"));
            }
            PlatformUI.getPreferenceStore().setValue("org.eclipse.sequoyah.device.framework.uiSERVICE_BUTTONS_ORIENTATION", buttonsOrienation);
            InstanceServicesComposite.this.createServicesArea();
        }
    }
}

