/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Basisobjekte.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Basisobjekte.util.BasisobjekteAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class BasisobjekteItemProviderAdapterFactory extends BasisobjekteAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BasisobjekteItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Abstand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_TypeClassItemProvider abstand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Abstand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_TypeClassAdapter() {
		if (abstand_TypeClassItemProvider == null) {
			abstand_TypeClassItemProvider = new Abstand_TypeClassItemProvider(this);
		}

		return abstand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Anhang} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnhangItemProvider anhangItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Anhang}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnhangAdapter() {
		if (anhangItemProvider == null) {
			anhangItemProvider = new AnhangItemProvider(this);
		}

		return anhangItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Anhang_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anhang_Allg_AttributeGroupItemProvider anhang_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Anhang_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnhang_Allg_AttributeGroupAdapter() {
		if (anhang_Allg_AttributeGroupItemProvider == null) {
			anhang_Allg_AttributeGroupItemProvider = new Anhang_Allg_AttributeGroupItemProvider(this);
		}

		return anhang_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Anhang_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anhang_Art_TypeClassItemProvider anhang_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Anhang_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnhang_Art_TypeClassAdapter() {
		if (anhang_Art_TypeClassItemProvider == null) {
			anhang_Art_TypeClassItemProvider = new Anhang_Art_TypeClassItemProvider(this);
		}

		return anhang_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Basis_Objekt_Allg_AttributeGroupItemProvider basis_Objekt_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBasis_Objekt_Allg_AttributeGroupAdapter() {
		if (basis_Objekt_Allg_AttributeGroupItemProvider == null) {
			basis_Objekt_Allg_AttributeGroupItemProvider = new Basis_Objekt_Allg_AttributeGroupItemProvider(this);
		}

		return basis_Objekt_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BearbeitungsvermerkItemProvider bearbeitungsvermerkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBearbeitungsvermerkAdapter() {
		if (bearbeitungsvermerkItemProvider == null) {
			bearbeitungsvermerkItemProvider = new BearbeitungsvermerkItemProvider(this);
		}

		return bearbeitungsvermerkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bearbeitungsvermerk_Allg_AttributeGroupItemProvider bearbeitungsvermerk_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBearbeitungsvermerk_Allg_AttributeGroupAdapter() {
		if (bearbeitungsvermerk_Allg_AttributeGroupItemProvider == null) {
			bearbeitungsvermerk_Allg_AttributeGroupItemProvider = new Bearbeitungsvermerk_Allg_AttributeGroupItemProvider(this);
		}

		return bearbeitungsvermerk_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk_Kennung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bearbeitungsvermerk_Kennung_TypeClassItemProvider bearbeitungsvermerk_Kennung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk_Kennung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBearbeitungsvermerk_Kennung_TypeClassAdapter() {
		if (bearbeitungsvermerk_Kennung_TypeClassItemProvider == null) {
			bearbeitungsvermerk_Kennung_TypeClassItemProvider = new Bearbeitungsvermerk_Kennung_TypeClassItemProvider(this);
		}

		return bearbeitungsvermerk_Kennung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk_Rolle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bearbeitungsvermerk_Rolle_TypeClassItemProvider bearbeitungsvermerk_Rolle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk_Rolle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBearbeitungsvermerk_Rolle_TypeClassAdapter() {
		if (bearbeitungsvermerk_Rolle_TypeClassItemProvider == null) {
			bearbeitungsvermerk_Rolle_TypeClassItemProvider = new Bearbeitungsvermerk_Rolle_TypeClassItemProvider(this);
		}

		return bearbeitungsvermerk_Rolle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_A_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Begrenzung_A_TypeClassItemProvider begrenzung_A_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_A_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBegrenzung_A_TypeClassAdapter() {
		if (begrenzung_A_TypeClassItemProvider == null) {
			begrenzung_A_TypeClassItemProvider = new Begrenzung_A_TypeClassItemProvider(this);
		}

		return begrenzung_A_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_B_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Begrenzung_B_TypeClassItemProvider begrenzung_B_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_B_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBegrenzung_B_TypeClassAdapter() {
		if (begrenzung_B_TypeClassItemProvider == null) {
			begrenzung_B_TypeClassItemProvider = new Begrenzung_B_TypeClassItemProvider(this);
		}

		return begrenzung_B_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bereich_Objekt_Teilbereich_AttributeGroupItemProvider bereich_Objekt_Teilbereich_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBereich_Objekt_Teilbereich_AttributeGroupAdapter() {
		if (bereich_Objekt_Teilbereich_AttributeGroupItemProvider == null) {
			bereich_Objekt_Teilbereich_AttributeGroupItemProvider = new Bereich_Objekt_Teilbereich_AttributeGroupItemProvider(this);
		}

		return bereich_Objekt_Teilbereich_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Beschreibung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Beschreibung_TypeClassItemProvider beschreibung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Beschreibung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBeschreibung_TypeClassAdapter() {
		if (beschreibung_TypeClassItemProvider == null) {
			beschreibung_TypeClassItemProvider = new Beschreibung_TypeClassItemProvider(this);
		}

		return beschreibung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bestandsrelevanz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bestandsrelevanz_TypeClassItemProvider bestandsrelevanz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bestandsrelevanz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBestandsrelevanz_TypeClassAdapter() {
		if (bestandsrelevanz_TypeClassItemProvider == null) {
			bestandsrelevanz_TypeClassItemProvider = new Bestandsrelevanz_TypeClassItemProvider(this);
		}

		return bestandsrelevanz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bestandsschutz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bestandsschutz_TypeClassItemProvider bestandsschutz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Bestandsschutz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBestandsschutz_TypeClassAdapter() {
		if (bestandsschutz_TypeClassItemProvider == null) {
			bestandsschutz_TypeClassItemProvider = new Bestandsschutz_TypeClassItemProvider(this);
		}

		return bestandsschutz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Dateiname_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Dateiname_TypeClassItemProvider dateiname_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Dateiname_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDateiname_TypeClassAdapter() {
		if (dateiname_TypeClassItemProvider == null) {
			dateiname_TypeClassItemProvider = new Dateiname_TypeClassItemProvider(this);
		}

		return dateiname_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Dateityp_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Dateityp_TypeClassItemProvider dateityp_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Dateityp_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDateityp_TypeClassAdapter() {
		if (dateityp_TypeClassItemProvider == null) {
			dateityp_TypeClassItemProvider = new Dateityp_TypeClassItemProvider(this);
		}

		return dateityp_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Daten_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Daten_TypeClassItemProvider daten_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Daten_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDaten_TypeClassAdapter() {
		if (daten_TypeClassItemProvider == null) {
			daten_TypeClassItemProvider = new Daten_TypeClassItemProvider(this);
		}

		return daten_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Datum_Regelwerk_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datum_Regelwerk_TypeClassItemProvider datum_Regelwerk_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Datum_Regelwerk_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatum_Regelwerk_TypeClassAdapter() {
		if (datum_Regelwerk_TypeClassItemProvider == null) {
			datum_Regelwerk_TypeClassItemProvider = new Datum_Regelwerk_TypeClassItemProvider(this);
		}

		return datum_Regelwerk_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.DB_GDI_Referenz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DB_GDI_Referenz_TypeClassItemProvider dB_GDI_Referenz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.DB_GDI_Referenz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDB_GDI_Referenz_TypeClassAdapter() {
		if (dB_GDI_Referenz_TypeClassItemProvider == null) {
			dB_GDI_Referenz_TypeClassItemProvider = new DB_GDI_Referenz_TypeClassItemProvider(this);
		}

		return dB_GDI_Referenz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Identitaet_TypeClassItemProvider identitaet_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIdentitaet_TypeClassAdapter() {
		if (identitaet_TypeClassItemProvider == null) {
			identitaet_TypeClassItemProvider = new Identitaet_TypeClassItemProvider(this);
		}

		return identitaet_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Kommentar_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kommentar_TypeClassItemProvider kommentar_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Kommentar_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKommentar_TypeClassAdapter() {
		if (kommentar_TypeClassItemProvider == null) {
			kommentar_TypeClassItemProvider = new Kommentar_TypeClassItemProvider(this);
		}

		return kommentar_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Kurztext_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kurztext_TypeClassItemProvider kurztext_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Kurztext_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKurztext_TypeClassAdapter() {
		if (kurztext_TypeClassItemProvider == null) {
			kurztext_TypeClassItemProvider = new Kurztext_TypeClassItemProvider(this);
		}

		return kurztext_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Lieferobjekt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LieferobjektItemProvider lieferobjektItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Lieferobjekt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLieferobjektAdapter() {
		if (lieferobjektItemProvider == null) {
			lieferobjektItemProvider = new LieferobjektItemProvider(this);
		}

		return lieferobjektItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Ausgabestand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LO_Ausgabestand_TypeClassItemProvider lO_Ausgabestand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Ausgabestand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLO_Ausgabestand_TypeClassAdapter() {
		if (lO_Ausgabestand_TypeClassItemProvider == null) {
			lO_Ausgabestand_TypeClassItemProvider = new LO_Ausgabestand_TypeClassItemProvider(this);
		}

		return lO_Ausgabestand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Datum_Herstellung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LO_Datum_Herstellung_TypeClassItemProvider lO_Datum_Herstellung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Datum_Herstellung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLO_Datum_Herstellung_TypeClassAdapter() {
		if (lO_Datum_Herstellung_TypeClassItemProvider == null) {
			lO_Datum_Herstellung_TypeClassItemProvider = new LO_Datum_Herstellung_TypeClassItemProvider(this);
		}

		return lO_Datum_Herstellung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_DB_Freigabe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LO_DB_Freigabe_TypeClassItemProvider lO_DB_Freigabe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_DB_Freigabe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLO_DB_Freigabe_TypeClassAdapter() {
		if (lO_DB_Freigabe_TypeClassItemProvider == null) {
			lO_DB_Freigabe_TypeClassItemProvider = new LO_DB_Freigabe_TypeClassItemProvider(this);
		}

		return lO_DB_Freigabe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_EMA_Nr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LO_EMA_Nr_TypeClassItemProvider lO_EMA_Nr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_EMA_Nr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLO_EMA_Nr_TypeClassAdapter() {
		if (lO_EMA_Nr_TypeClassItemProvider == null) {
			lO_EMA_Nr_TypeClassItemProvider = new LO_EMA_Nr_TypeClassItemProvider(this);
		}

		return lO_EMA_Nr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Ersatz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LO_Ersatz_TypeClassItemProvider lO_Ersatz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Ersatz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLO_Ersatz_TypeClassAdapter() {
		if (lO_Ersatz_TypeClassItemProvider == null) {
			lO_Ersatz_TypeClassItemProvider = new LO_Ersatz_TypeClassItemProvider(this);
		}

		return lO_Ersatz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Firmensachnummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LO_Firmensachnummer_TypeClassItemProvider lO_Firmensachnummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Firmensachnummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLO_Firmensachnummer_TypeClassAdapter() {
		if (lO_Firmensachnummer_TypeClassItemProvider == null) {
			lO_Firmensachnummer_TypeClassItemProvider = new LO_Firmensachnummer_TypeClassItemProvider(this);
		}

		return lO_Firmensachnummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Material_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LO_Material_AttributeGroupItemProvider lO_Material_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Material_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLO_Material_AttributeGroupAdapter() {
		if (lO_Material_AttributeGroupItemProvider == null) {
			lO_Material_AttributeGroupItemProvider = new LO_Material_AttributeGroupItemProvider(this);
		}

		return lO_Material_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Seriennummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LO_Seriennummer_TypeClassItemProvider lO_Seriennummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.LO_Seriennummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLO_Seriennummer_TypeClassAdapter() {
		if (lO_Seriennummer_TypeClassItemProvider == null) {
			lO_Seriennummer_TypeClassItemProvider = new LO_Seriennummer_TypeClassItemProvider(this);
		}

		return lO_Seriennummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.LST_Objekt_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LST_Objekt_Art_TypeClassItemProvider lsT_Objekt_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.LST_Objekt_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLST_Objekt_Art_TypeClassAdapter() {
		if (lsT_Objekt_Art_TypeClassItemProvider == null) {
			lsT_Objekt_Art_TypeClassItemProvider = new LST_Objekt_Art_TypeClassItemProvider(this);
		}

		return lsT_Objekt_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Objektreferenzen_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Objektreferenzen_AttributeGroupItemProvider objektreferenzen_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Objektreferenzen_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createObjektreferenzen_AttributeGroupAdapter() {
		if (objektreferenzen_AttributeGroupItemProvider == null) {
			objektreferenzen_AttributeGroupItemProvider = new Objektreferenzen_AttributeGroupItemProvider(this);
		}

		return objektreferenzen_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Objektzustand_Besonders_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Objektzustand_Besonders_TypeClassItemProvider objektzustand_Besonders_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Objektzustand_Besonders_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createObjektzustand_Besonders_TypeClassAdapter() {
		if (objektzustand_Besonders_TypeClassItemProvider == null) {
			objektzustand_Besonders_TypeClassItemProvider = new Objektzustand_Besonders_TypeClassItemProvider(this);
		}

		return objektzustand_Besonders_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Proxy_Objekt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Proxy_ObjektItemProvider proxy_ObjektItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Proxy_Objekt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProxy_ObjektAdapter() {
		if (proxy_ObjektItemProvider == null) {
			proxy_ObjektItemProvider = new Proxy_ObjektItemProvider(this);
		}

		return proxy_ObjektItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_Strecke_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Punkt_Objekt_Strecke_AttributeGroupItemProvider punkt_Objekt_Strecke_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_Strecke_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPunkt_Objekt_Strecke_AttributeGroupAdapter() {
		if (punkt_Objekt_Strecke_AttributeGroupItemProvider == null) {
			punkt_Objekt_Strecke_AttributeGroupItemProvider = new Punkt_Objekt_Strecke_AttributeGroupItemProvider(this);
		}

		return punkt_Objekt_Strecke_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Punkt_Objekt_TOP_Kante_AttributeGroupItemProvider punkt_Objekt_TOP_Kante_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPunkt_Objekt_TOP_Kante_AttributeGroupAdapter() {
		if (punkt_Objekt_TOP_Kante_AttributeGroupItemProvider == null) {
			punkt_Objekt_TOP_Kante_AttributeGroupItemProvider = new Punkt_Objekt_TOP_Kante_AttributeGroupItemProvider(this);
		}

		return punkt_Objekt_TOP_Kante_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Richtungsbezug_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Richtungsbezug_TypeClassItemProvider richtungsbezug_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Richtungsbezug_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRichtungsbezug_TypeClassAdapter() {
		if (richtungsbezug_TypeClassItemProvider == null) {
			richtungsbezug_TypeClassItemProvider = new Richtungsbezug_TypeClassItemProvider(this);
		}

		return richtungsbezug_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Seitliche_Lage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Seitliche_Lage_TypeClassItemProvider seitliche_Lage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Seitliche_Lage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSeitliche_Lage_TypeClassAdapter() {
		if (seitliche_Lage_TypeClassItemProvider == null) {
			seitliche_Lage_TypeClassItemProvider = new Seitliche_Lage_TypeClassItemProvider(this);
		}

		return seitliche_Lage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Seitlicher_Abstand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Seitlicher_Abstand_TypeClassItemProvider seitlicher_Abstand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Seitlicher_Abstand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSeitlicher_Abstand_TypeClassAdapter() {
		if (seitlicher_Abstand_TypeClassItemProvider == null) {
			seitlicher_Abstand_TypeClassItemProvider = new Seitlicher_Abstand_TypeClassItemProvider(this);
		}

		return seitlicher_Abstand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Strecke_Km_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Strecke_Km_TypeClassItemProvider strecke_Km_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Strecke_Km_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStrecke_Km_TypeClassAdapter() {
		if (strecke_Km_TypeClassItemProvider == null) {
			strecke_Km_TypeClassItemProvider = new Strecke_Km_TypeClassItemProvider(this);
		}

		return strecke_Km_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Technischer_Platz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Technischer_Platz_TypeClassItemProvider technischer_Platz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Technischer_Platz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnischer_Platz_TypeClassAdapter() {
		if (technischer_Platz_TypeClassItemProvider == null) {
			technischer_Platz_TypeClassItemProvider = new Technischer_Platz_TypeClassItemProvider(this);
		}

		return technischer_Platz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Wirkrichtung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Wirkrichtung_TypeClassItemProvider wirkrichtung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Wirkrichtung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWirkrichtung_TypeClassAdapter() {
		if (wirkrichtung_TypeClassItemProvider == null) {
			wirkrichtung_TypeClassItemProvider = new Wirkrichtung_TypeClassItemProvider(this);
		}

		return wirkrichtung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Basisobjekte.Zeit_Bearbeitungsvermerk_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zeit_Bearbeitungsvermerk_TypeClassItemProvider zeit_Bearbeitungsvermerk_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Basisobjekte.Zeit_Bearbeitungsvermerk_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZeit_Bearbeitungsvermerk_TypeClassAdapter() {
		if (zeit_Bearbeitungsvermerk_TypeClassItemProvider == null) {
			zeit_Bearbeitungsvermerk_TypeClassItemProvider = new Zeit_Bearbeitungsvermerk_TypeClassItemProvider(this);
		}

		return zeit_Bearbeitungsvermerk_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (abstand_TypeClassItemProvider != null) abstand_TypeClassItemProvider.dispose();
		if (anhangItemProvider != null) anhangItemProvider.dispose();
		if (anhang_Allg_AttributeGroupItemProvider != null) anhang_Allg_AttributeGroupItemProvider.dispose();
		if (anhang_Art_TypeClassItemProvider != null) anhang_Art_TypeClassItemProvider.dispose();
		if (basis_Objekt_Allg_AttributeGroupItemProvider != null) basis_Objekt_Allg_AttributeGroupItemProvider.dispose();
		if (bearbeitungsvermerkItemProvider != null) bearbeitungsvermerkItemProvider.dispose();
		if (bearbeitungsvermerk_Allg_AttributeGroupItemProvider != null) bearbeitungsvermerk_Allg_AttributeGroupItemProvider.dispose();
		if (bearbeitungsvermerk_Kennung_TypeClassItemProvider != null) bearbeitungsvermerk_Kennung_TypeClassItemProvider.dispose();
		if (bearbeitungsvermerk_Rolle_TypeClassItemProvider != null) bearbeitungsvermerk_Rolle_TypeClassItemProvider.dispose();
		if (begrenzung_A_TypeClassItemProvider != null) begrenzung_A_TypeClassItemProvider.dispose();
		if (begrenzung_B_TypeClassItemProvider != null) begrenzung_B_TypeClassItemProvider.dispose();
		if (bereich_Objekt_Teilbereich_AttributeGroupItemProvider != null) bereich_Objekt_Teilbereich_AttributeGroupItemProvider.dispose();
		if (beschreibung_TypeClassItemProvider != null) beschreibung_TypeClassItemProvider.dispose();
		if (bestandsrelevanz_TypeClassItemProvider != null) bestandsrelevanz_TypeClassItemProvider.dispose();
		if (bestandsschutz_TypeClassItemProvider != null) bestandsschutz_TypeClassItemProvider.dispose();
		if (dateiname_TypeClassItemProvider != null) dateiname_TypeClassItemProvider.dispose();
		if (dateityp_TypeClassItemProvider != null) dateityp_TypeClassItemProvider.dispose();
		if (daten_TypeClassItemProvider != null) daten_TypeClassItemProvider.dispose();
		if (datum_Regelwerk_TypeClassItemProvider != null) datum_Regelwerk_TypeClassItemProvider.dispose();
		if (dB_GDI_Referenz_TypeClassItemProvider != null) dB_GDI_Referenz_TypeClassItemProvider.dispose();
		if (identitaet_TypeClassItemProvider != null) identitaet_TypeClassItemProvider.dispose();
		if (kommentar_TypeClassItemProvider != null) kommentar_TypeClassItemProvider.dispose();
		if (kurztext_TypeClassItemProvider != null) kurztext_TypeClassItemProvider.dispose();
		if (lieferobjektItemProvider != null) lieferobjektItemProvider.dispose();
		if (lO_Ausgabestand_TypeClassItemProvider != null) lO_Ausgabestand_TypeClassItemProvider.dispose();
		if (lO_Datum_Herstellung_TypeClassItemProvider != null) lO_Datum_Herstellung_TypeClassItemProvider.dispose();
		if (lO_DB_Freigabe_TypeClassItemProvider != null) lO_DB_Freigabe_TypeClassItemProvider.dispose();
		if (lO_EMA_Nr_TypeClassItemProvider != null) lO_EMA_Nr_TypeClassItemProvider.dispose();
		if (lO_Ersatz_TypeClassItemProvider != null) lO_Ersatz_TypeClassItemProvider.dispose();
		if (lO_Firmensachnummer_TypeClassItemProvider != null) lO_Firmensachnummer_TypeClassItemProvider.dispose();
		if (lO_Material_AttributeGroupItemProvider != null) lO_Material_AttributeGroupItemProvider.dispose();
		if (lO_Seriennummer_TypeClassItemProvider != null) lO_Seriennummer_TypeClassItemProvider.dispose();
		if (lsT_Objekt_Art_TypeClassItemProvider != null) lsT_Objekt_Art_TypeClassItemProvider.dispose();
		if (objektreferenzen_AttributeGroupItemProvider != null) objektreferenzen_AttributeGroupItemProvider.dispose();
		if (objektzustand_Besonders_TypeClassItemProvider != null) objektzustand_Besonders_TypeClassItemProvider.dispose();
		if (proxy_ObjektItemProvider != null) proxy_ObjektItemProvider.dispose();
		if (punkt_Objekt_Strecke_AttributeGroupItemProvider != null) punkt_Objekt_Strecke_AttributeGroupItemProvider.dispose();
		if (punkt_Objekt_TOP_Kante_AttributeGroupItemProvider != null) punkt_Objekt_TOP_Kante_AttributeGroupItemProvider.dispose();
		if (richtungsbezug_TypeClassItemProvider != null) richtungsbezug_TypeClassItemProvider.dispose();
		if (seitliche_Lage_TypeClassItemProvider != null) seitliche_Lage_TypeClassItemProvider.dispose();
		if (seitlicher_Abstand_TypeClassItemProvider != null) seitlicher_Abstand_TypeClassItemProvider.dispose();
		if (strecke_Km_TypeClassItemProvider != null) strecke_Km_TypeClassItemProvider.dispose();
		if (technischer_Platz_TypeClassItemProvider != null) technischer_Platz_TypeClassItemProvider.dispose();
		if (wirkrichtung_TypeClassItemProvider != null) wirkrichtung_TypeClassItemProvider.dispose();
		if (zeit_Bearbeitungsvermerk_TypeClassItemProvider != null) zeit_Bearbeitungsvermerk_TypeClassItemProvider.dispose();
	}

}
