/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.scale.internal;

import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smarthome.core.transform.AbstractFileTransformationService;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.transform.scale.internal.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleTransformationService
extends AbstractFileTransformationService<Map<Range, String>> {
    private final Logger logger = LoggerFactory.getLogger(ScaleTransformationService.class);
    private static final Pattern LIMITS_PATTERN = Pattern.compile("(\\[|\\])(.*)\\.\\.(.*)(\\[|\\])");

    protected String internalTransform(Map<Range, String> data, String source) throws TransformationException {
        try {
            BigDecimal value = new BigDecimal(source);
            return data.entrySet().stream().filter(e -> ((Range)e.getKey()).contains(value)).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new TransformationException("No matching range for '" + source + "'"));
        }
        catch (NumberFormatException e2) {
            throw new TransformationException("Scale can only be used with numeric inputs");
        }
    }

    protected Map<Range, String> internalLoadTransform(String filename) throws TransformationException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileReader reader = new FileReader(filename);){
                LinkedHashMap<Range, String> data = new LinkedHashMap<Range, String>();
                OrderedProperties properties = new OrderedProperties();
                properties.load(reader);
                for (Object orderedKey : properties.orderedKeys()) {
                    String entry = (String)orderedKey;
                    String value = properties.getProperty(entry);
                    Matcher matcher = LIMITS_PATTERN.matcher(entry);
                    if (matcher.matches() && matcher.groupCount() == 4) {
                        boolean lowerInclusive = !matcher.group(1).equals("]");
                        boolean upperInclusive = !matcher.group(4).equals("[");
                        String lowLimit = matcher.group(2);
                        String highLimit = matcher.group(3);
                        try {
                            BigDecimal lowValue = lowLimit.isEmpty() ? null : new BigDecimal(lowLimit);
                            BigDecimal highValue = highLimit.isEmpty() ? null : new BigDecimal(highLimit);
                            Range range = Range.range(lowValue, lowerInclusive, highValue, upperInclusive);
                            data.put(range, value);
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new TransformationException("Error parsing bounds: " + lowLimit + ".." + highLimit);
                        }
                    }
                    this.logger.warn("Scale transform file '{}' does not comply with syntax for entry : '{}', '{}'", new Object[]{filename, entry, value});
                }
                return data;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new TransformationException("An error occurred while opening file.", (Throwable)ex);
        }
    }

    static class OrderedProperties
    extends Properties {
        private static final long serialVersionUID = 3860553217028220119L;
        private final HashSet<Object> keys = new LinkedHashSet<Object>();

        OrderedProperties() {
        }

        Set<Object> orderedKeys() {
            return this.keys;
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }
    }
}

