/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.WebAppConfig;
import org.eclipse.smarthome.ui.basic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.basic.render.RenderException;
import org.eclipse.smarthome.ui.basic.render.WidgetRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRenderer
extends AbstractWidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(PageRenderer.class);
    List<WidgetRenderer> widgetRenderers = new ArrayList<WidgetRenderer>();

    public void addWidgetRenderer(WidgetRenderer widgetRenderer) {
        widgetRenderer.setConfig(this.config);
        this.widgetRenderers.add(widgetRenderer);
    }

    public void removeWidgetRenderer(WidgetRenderer widgetRenderer) {
        this.widgetRenderers.remove(widgetRenderer);
    }

    public StringBuilder processPage(String id, String sitemap, String label, EList<Widget> children, boolean async) throws RenderException {
        String snippet = this.getSnippet(async ? "layer" : "main");
        snippet = snippet.replaceAll("%main.offline-msg%", this.localizeText("@text/main.offline-msg"));
        snippet = snippet.replaceAll("%id%", id);
        String labelPlain = label;
        if (labelPlain.contains("[") && labelPlain.endsWith("]")) {
            labelPlain = labelPlain.replace("[", "").replace("]", "");
        }
        snippet = StringUtils.replace((String)snippet, (String)"%label%", (String)this.escapeHtml(labelPlain));
        snippet = StringUtils.replace((String)snippet, (String)"%servletname%", (String)"app");
        snippet = StringUtils.replace((String)snippet, (String)"%sitemap%", (String)sitemap);
        snippet = StringUtils.replace((String)snippet, (String)"%htmlclass%", (String)this.config.getCssClassList());
        snippet = StringUtils.replace((String)snippet, (String)"%icon_type%", (String)this.config.getIconType());
        snippet = StringUtils.replace((String)snippet, (String)"%theme%", (String)this.config.getTheme());
        String[] parts = snippet.split("%children%");
        StringBuilder pre_children = new StringBuilder(parts[0]);
        StringBuilder post_children = new StringBuilder(parts[1]);
        if (parts.length == 2) {
            this.processChildren(pre_children, post_children, children);
        } else if (parts.length > 2) {
            this.logger.error("Snippet '{}' contains multiple %children% sections, but only one is allowed!", (Object)(async ? "layer" : "main"));
        }
        return pre_children.append((CharSequence)post_children);
    }

    private void processChildren(StringBuilder sb_pre, StringBuilder sb_post, EList<Widget> children) throws RenderException {
        if (!children.isEmpty()) {
            EObject firstChild = (EObject)children.get(0);
            EObject parent = this.itemUIRegistry.getParent((Widget)firstChild);
            if (!(firstChild instanceof Frame || parent instanceof Frame || parent instanceof Sitemap || parent instanceof org.eclipse.smarthome.model.sitemap.List)) {
                String frameSnippet = this.getSnippet("frame");
                frameSnippet = StringUtils.replace((String)frameSnippet, (String)"%widget_id%", (String)"");
                frameSnippet = StringUtils.replace((String)frameSnippet, (String)"%label%", (String)"");
                String[] parts = (frameSnippet = StringUtils.replace((String)frameSnippet, (String)"%frame_class%", (String)"mdl-form--no-label")).split("%children%");
                if (parts.length > 1) {
                    sb_pre.append(parts[0]);
                    sb_post.insert(0, parts[1]);
                }
                if (parts.length > 2) {
                    this.logger.error("Snippet 'frame' contains multiple %children% sections, but only one is allowed!");
                }
            }
        }
        for (Widget w : children) {
            StringBuilder new_pre = new StringBuilder();
            StringBuilder new_post = new StringBuilder();
            StringBuilder widgetSB = new StringBuilder();
            EList<Widget> nextChildren = this.renderWidget(w, widgetSB);
            if (nextChildren != null) {
                String[] parts = widgetSB.toString().split("%children%");
                if (parts.length == 1) {
                    new_pre.append((CharSequence)widgetSB);
                }
                if (parts.length > 1) {
                    new_pre.append(parts[0]);
                    new_post.insert(0, parts[1]);
                }
                if (parts.length > 2) {
                    String widgetType = w.eClass().getInstanceTypeName().substring(w.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
                    this.logger.error("Snippet for widget '{}' contains multiple %children% sections, but only one is allowed!", (Object)widgetType);
                }
                this.processChildren(new_pre, new_post, nextChildren);
                sb_pre.append((CharSequence)new_pre);
                sb_pre.append((CharSequence)new_post);
                continue;
            }
            sb_pre.append((CharSequence)widgetSB);
        }
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        for (WidgetRenderer renderer : this.widgetRenderers) {
            if (!renderer.canRender(w)) continue;
            return renderer.renderWidget(w, sb);
        }
        return null;
    }

    @Override
    public boolean canRender(Widget w) {
        return false;
    }

    @Override
    public void setConfig(WebAppConfig config) {
        this.config = config;
        for (WidgetRenderer renderer : this.widgetRenderers) {
            renderer.setConfig(config);
        }
    }

    public CharSequence renderSitemapList(Set<SitemapProvider> sitemapProviders) throws RenderException {
        LinkedList<String> sitemapList = new LinkedList<String>();
        for (SitemapProvider sitemapProvider : sitemapProviders) {
            Set sitemaps = sitemapProvider.getSitemapNames();
            for (String sitemap : sitemaps) {
                if (sitemap.equals("_default")) continue;
                sitemapList.add(sitemap);
            }
        }
        String pageSnippet = this.getSnippet("main_static");
        String listSnippet = this.getSnippet("sitemaps_list");
        String sitemapSnippet = this.getSnippet("sitemaps_list_item");
        StringBuilder sb = new StringBuilder();
        if (sitemapList.isEmpty()) {
            String listEmptySnippet = this.getSnippet("sitemaps_list_empty");
            listEmptySnippet = StringUtils.replace((String)listEmptySnippet, (String)"%sitemaps-list-empty.info%", (String)this.localizeText("@text/sitemaps-list-empty.info"));
            sb.append(listEmptySnippet);
        } else {
            for (String sitemap : sitemapList) {
                sb.append(StringUtils.replace((String)sitemapSnippet, (String)"%sitemap%", (String)sitemap));
            }
        }
        listSnippet = StringUtils.replace((String)listSnippet, (String)"%sitemaps-list.welcome%", (String)this.localizeText("@text/sitemaps-list.welcome"));
        listSnippet = StringUtils.replace((String)listSnippet, (String)"%sitemaps-list.available-sitemaps%", (String)this.localizeText("@text/sitemaps-list.available-sitemaps"));
        listSnippet = StringUtils.replace((String)listSnippet, (String)"%items%", (String)sb.toString());
        pageSnippet = StringUtils.replace((String)pageSnippet, (String)"%title%", (String)"BasicUI");
        pageSnippet = StringUtils.replace((String)pageSnippet, (String)"%htmlclass%", (String)(String.valueOf(this.config.getCssClassList()) + " page-welcome-sitemaps"));
        pageSnippet = StringUtils.replace((String)pageSnippet, (String)"%content%", (String)listSnippet);
        return pageSnippet;
    }
}

