/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.auth.oauth2client.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.auth.oauth2client.internal.OAuthClientServiceImpl;
import org.eclipse.smarthome.auth.oauth2client.internal.OAuthStoreHandler;
import org.eclipse.smarthome.auth.oauth2client.internal.PersistedParams;
import org.eclipse.smarthome.core.auth.client.oauth2.OAuthClientService;
import org.eclipse.smarthome.core.auth.client.oauth2.OAuthException;
import org.eclipse.smarthome.core.auth.client.oauth2.OAuthFactory;
import org.eclipse.smarthome.io.net.http.HttpClientFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component
public class OAuthFactoryImpl
implements OAuthFactory {
    private final Logger logger = LoggerFactory.getLogger(OAuthFactoryImpl.class);
    @NonNullByDefault(value={})
    private OAuthStoreHandler oAuthStoreHandler;
    @NonNullByDefault(value={})
    private HttpClientFactory httpClientFactory;
    private int tokenExpiresInBuffer = 10;
    private final Map<String, OAuthClientService> oauthClientServiceCache = new ConcurrentHashMap<String, OAuthClientService>();

    @Deactivate
    public void deactivate() {
        for (OAuthClientService clientServiceImpl : this.oauthClientServiceCache.values()) {
            clientServiceImpl.close();
        }
        this.oauthClientServiceCache.clear();
    }

    public OAuthClientService createOAuthClientService(String handle, String tokenUrl, @Nullable String authorizationUrl, String clientId, @Nullable String clientSecret, @Nullable String scope, @Nullable Boolean supportsBasicAuth) {
        PersistedParams params = this.oAuthStoreHandler.loadPersistedParams(handle);
        PersistedParams newParams = new PersistedParams(handle, tokenUrl, authorizationUrl, clientId, clientSecret, scope, supportsBasicAuth, this.tokenExpiresInBuffer);
        OAuthClientService clientImpl = null;
        if (params != null && params.equals(newParams)) {
            clientImpl = this.getOAuthClientService(handle);
        }
        if (clientImpl == null) {
            clientImpl = OAuthClientServiceImpl.createInstance(handle, this.oAuthStoreHandler, this.httpClientFactory, newParams);
            this.oauthClientServiceCache.put(handle, clientImpl);
        }
        return clientImpl;
    }

    public @Nullable OAuthClientService getOAuthClientService(String handle) {
        OAuthClientService clientImpl = this.oauthClientServiceCache.get(handle);
        if (clientImpl == null || clientImpl.isClosed()) {
            clientImpl = OAuthClientServiceImpl.getInstance(handle, this.oAuthStoreHandler, this.tokenExpiresInBuffer, this.httpClientFactory);
            if (clientImpl == null) {
                return null;
            }
            this.oauthClientServiceCache.put(handle, clientImpl);
        }
        return clientImpl;
    }

    public void ungetOAuthService(String handle) {
        OAuthClientService clientImpl = this.oauthClientServiceCache.get(handle);
        if (clientImpl == null) {
            this.logger.debug("{} handle not found. Cannot unregisterOAuthServie", (Object)handle);
            return;
        }
        clientImpl.close();
        this.oauthClientServiceCache.remove(handle);
    }

    public void deleteServiceAndAccessToken(String handle) {
        OAuthClientService clientImpl = this.oauthClientServiceCache.get(handle);
        if (clientImpl != null) {
            try {
                clientImpl.remove();
            }
            catch (OAuthException oAuthException) {}
            this.oauthClientServiceCache.remove(handle);
        }
        this.oAuthStoreHandler.remove(handle);
    }

    @Reference
    protected void setOAuthStoreHandler(OAuthStoreHandler oAuthStoreHandler) {
        this.oAuthStoreHandler = oAuthStoreHandler;
    }

    protected void unsetOAuthStoreHandler(OAuthStoreHandler oAuthStoreHandler) {
        this.oAuthStoreHandler = null;
    }

    @Reference
    protected void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    protected void unsetHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = null;
    }

    public int getTokenExpiresInBuffer() {
        return this.tokenExpiresInBuffer;
    }

    public void setTokenExpiresInBuffer(int bufferInSeconds) {
        this.tokenExpiresInBuffer = bufferInSeconds;
    }
}

