/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.smarthome.automation.module.script.ScriptEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericScriptEngineFactory
implements ScriptEngineFactory {
    private ScriptEngineManager engineManager = new ScriptEngineManager();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public GenericScriptEngineFactory() {
        for (javax.script.ScriptEngineFactory f : this.engineManager.getEngineFactories()) {
            this.logger.info("Activated scripting support for {}", (Object)f.getLanguageName());
            this.logger.debug("Activated scripting support with engine {}({}) for {}({}) with mimetypes {} and file extensions {}", new Object[]{f.getEngineName(), f.getEngineVersion(), f.getLanguageName(), f.getLanguageVersion(), f.getMimeTypes(), f.getExtensions()});
        }
    }

    @Override
    public List<String> getLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        for (javax.script.ScriptEngineFactory f : this.engineManager.getEngineFactories()) {
            languages.addAll(f.getExtensions());
        }
        return languages;
    }

    @Override
    public void scopeValues(ScriptEngine scriptEngine, Map<String, Object> scopeValues) {
        for (Map.Entry<String, Object> entry : scopeValues.entrySet()) {
            scriptEngine.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public ScriptEngine createScriptEngine(String fileExtension) {
        ScriptEngine engine = this.engineManager.getEngineByExtension(fileExtension);
        if (engine == null) {
            engine = this.engineManager.getEngineByName(fileExtension);
        }
        if (engine == null) {
            engine = this.engineManager.getEngineByMimeType(fileExtension);
        }
        return engine;
    }

    @Override
    public boolean isSupported(String fileExtension) {
        for (javax.script.ScriptEngineFactory f : this.engineManager.getEngineFactories()) {
            if (!f.getExtensions().contains(fileExtension)) continue;
            return true;
        }
        return false;
    }
}

