/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.rule.jvmmodel;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.script.engine.action.ActionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesRefresher {
    private static final long REFRESH_DELAY = 2000L;
    private final Logger logger = LoggerFactory.getLogger(RulesRefresher.class);
    ModelRepository modelRepository;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> job;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (RulesRefresher.this.modelRepository != null) {
                    RulesRefresher.this.modelRepository.reloadAllModelsOfType("rules");
                }
            }
            catch (Exception e) {
                RulesRefresher.this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    };

    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        this.modelRepository = null;
    }

    protected void addActionService(ActionService actionService) {
        this.scheduleRuleRefresh();
    }

    protected void removeActionService(ActionService actionService) {
        this.scheduleRuleRefresh();
    }

    protected synchronized void scheduleRuleRefresh() {
        if (this.job != null && !this.job.isDone()) {
            this.job.cancel(false);
        }
        this.job = this.scheduler.schedule(this.runnable, 2000L, TimeUnit.MILLISECONDS);
    }
}

