/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.eclipse.smarthome.model.script.engine.Script;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.smarthome.model.script.engine.ScriptExecutionException;
import org.eclipse.smarthome.model.script.engine.ScriptParsingException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ConsoleCommandExtension.class})
public class ScriptEngineConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private ScriptEngine scriptEngine;

    public ScriptEngineConsoleCommandExtension() {
        super("script", "Execute scripts");
    }

    public void execute(String[] args, Console console) {
        block6: {
            if (this.scriptEngine != null) {
                String scriptString = Arrays.stream(args).collect(Collectors.joining(" "));
                try {
                    Script script = this.scriptEngine.newScriptFromString(scriptString);
                    Object result = script.execute();
                    if (result != null) {
                        console.println(result.toString());
                        break block6;
                    }
                    console.println("OK");
                }
                catch (ScriptParsingException e) {
                    console.println(e.getMessage());
                }
                catch (ScriptExecutionException e) {
                    console.println(e.getMessage());
                }
            } else {
                console.println("Script engine is not available.");
            }
        }
    }

    public List<String> getUsages() {
        return Collections.singletonList(this.buildCommandUsage("<script to execute>", "Executes a script"));
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void unsetScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = null;
    }
}

