package org.eclipse.smarthome.model.persistence.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.model.persistence.persistence.AllConfig;
import org.eclipse.smarthome.model.persistence.persistence.CronStrategy;
import org.eclipse.smarthome.model.persistence.persistence.Filter;
import org.eclipse.smarthome.model.persistence.persistence.GroupConfig;
import org.eclipse.smarthome.model.persistence.persistence.ItemConfig;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceConfiguration;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceModel;
import org.eclipse.smarthome.model.persistence.persistence.PersistencePackage;
import org.eclipse.smarthome.model.persistence.persistence.Strategy;
import org.eclipse.smarthome.model.persistence.persistence.ThresholdFilter;
import org.eclipse.smarthome.model.persistence.persistence.TimeFilter;
import org.eclipse.smarthome.model.persistence.services.PersistenceGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class PersistenceSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private PersistenceGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == PersistencePackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case PersistencePackage.ALL_CONFIG:
				if(context == grammarAccess.getAllConfigRule()) {
					sequence_AllConfig(context, (AllConfig) semanticObject); 
					return; 
				}
				else break;
			case PersistencePackage.CRON_STRATEGY:
				if(context == grammarAccess.getCronStrategyRule() ||
				   context == grammarAccess.getStrategyRule()) {
					sequence_CronStrategy(context, (CronStrategy) semanticObject); 
					return; 
				}
				else break;
			case PersistencePackage.FILTER:
				if(context == grammarAccess.getFilterRule()) {
					sequence_Filter(context, (Filter) semanticObject); 
					return; 
				}
				else break;
			case PersistencePackage.GROUP_CONFIG:
				if(context == grammarAccess.getGroupConfigRule()) {
					sequence_GroupConfig(context, (GroupConfig) semanticObject); 
					return; 
				}
				else break;
			case PersistencePackage.ITEM_CONFIG:
				if(context == grammarAccess.getItemConfigRule()) {
					sequence_ItemConfig(context, (ItemConfig) semanticObject); 
					return; 
				}
				else break;
			case PersistencePackage.PERSISTENCE_CONFIGURATION:
				if(context == grammarAccess.getPersistenceConfigurationRule()) {
					sequence_PersistenceConfiguration(context, (PersistenceConfiguration) semanticObject); 
					return; 
				}
				else break;
			case PersistencePackage.PERSISTENCE_MODEL:
				if(context == grammarAccess.getPersistenceModelRule()) {
					sequence_PersistenceModel(context, (PersistenceModel) semanticObject); 
					return; 
				}
				else break;
			case PersistencePackage.STRATEGY:
				if(context == grammarAccess.getStrategyRule()) {
					sequence_Strategy(context, (Strategy) semanticObject); 
					return; 
				}
				else break;
			case PersistencePackage.THRESHOLD_FILTER:
				if(context == grammarAccess.getFilterDetailsRule() ||
				   context == grammarAccess.getThresholdFilterRule()) {
					sequence_ThresholdFilter(context, (ThresholdFilter) semanticObject); 
					return; 
				}
				else break;
			case PersistencePackage.TIME_FILTER:
				if(context == grammarAccess.getFilterDetailsRule() ||
				   context == grammarAccess.getTimeFilterRule()) {
					sequence_TimeFilter(context, (TimeFilter) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     {AllConfig}
	 */
	protected void sequence_AllConfig(EObject context, AllConfig semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID cronExpression=STRING)
	 */
	protected void sequence_CronStrategy(EObject context, CronStrategy semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.STRATEGY__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.STRATEGY__NAME));
			if(transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.CRON_STRATEGY__CRON_EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.CRON_STRATEGY__CRON_EXPRESSION));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getCronStrategyAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getCronStrategyAccess().getCronExpressionSTRINGTerminalRuleCall_3_0(), semanticObject.getCronExpression());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID definition=FilterDetails)
	 */
	protected void sequence_Filter(EObject context, Filter semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.FILTER__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.FILTER__NAME));
			if(transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.FILTER__DEFINITION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.FILTER__DEFINITION));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getFilterAccess().getNameIDTerminalRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getFilterAccess().getDefinitionFilterDetailsParserRuleCall_2_0(), semanticObject.getDefinition());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     group=ID
	 */
	protected void sequence_GroupConfig(EObject context, GroupConfig semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.GROUP_CONFIG__GROUP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.GROUP_CONFIG__GROUP));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getGroupConfigAccess().getGroupIDTerminalRuleCall_0_0(), semanticObject.getGroup());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     item=ID
	 */
	protected void sequence_ItemConfig(EObject context, ItemConfig semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.ITEM_CONFIG__ITEM) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.ITEM_CONFIG__ITEM));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getItemConfigAccess().getItemIDTerminalRuleCall_0(), semanticObject.getItem());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         (items+=AllConfig | items+=ItemConfig | items+=GroupConfig) 
	 *         (items+=AllConfig | items+=ItemConfig | items+=GroupConfig)* 
	 *         alias=STRING? 
	 *         ((strategies+=[Strategy|ID] strategies+=[Strategy|ID]*)? (filters+=[Filter|ID] filters+=[Filter|ID]*)?)?
	 *     )
	 */
	protected void sequence_PersistenceConfiguration(EObject context, PersistenceConfiguration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (strategies+=Strategy* (defaults+=[Strategy|ID] defaults+=[Strategy|ID]*)? filters+=Filter* configs+=PersistenceConfiguration*)
	 */
	protected void sequence_PersistenceModel(EObject context, PersistenceModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     name=ID
	 */
	protected void sequence_Strategy(EObject context, Strategy semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.STRATEGY__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.STRATEGY__NAME));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getStrategyAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (value=DECIMAL percent?='%')
	 */
	protected void sequence_ThresholdFilter(EObject context, ThresholdFilter semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.THRESHOLD_FILTER__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.THRESHOLD_FILTER__VALUE));
			if(transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.THRESHOLD_FILTER__PERCENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.THRESHOLD_FILTER__PERCENT));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getThresholdFilterAccess().getValueDECIMALParserRuleCall_1_0(), semanticObject.getValue());
		feeder.accept(grammarAccess.getThresholdFilterAccess().getPercentPercentSignKeyword_2_0(), semanticObject.isPercent());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (value=INT (unit='s' | unit='m' | unit='h' | unit='d'))
	 */
	protected void sequence_TimeFilter(EObject context, TimeFilter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
