/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;

public class Rule {
    protected List<Trigger> triggers;
    protected List<Condition> conditions;
    protected List<Action> actions;
    protected Map<String, ?> configuration;
    protected List<ConfigDescriptionParameter> configDescriptions;
    protected String templateUID;
    protected String uid;
    protected String name;
    protected Set<String> tags;
    protected Visibility visibility;
    protected String description;

    public Rule() {
    }

    public Rule(String uid, List<Trigger> triggers, List<Condition> conditions, List<Action> actions, List<ConfigDescriptionParameter> configDescriptions, Map<String, ?> configurations, Visibility visibility) {
        this.triggers = triggers;
        this.actions = actions;
        this.conditions = conditions;
        this.configDescriptions = configDescriptions;
        this.setConfiguration(configurations);
        this.uid = uid;
        this.visibility = visibility;
    }

    public Rule(String uid, List<Trigger> triggers, List<Condition> conditions, List<Action> actions, List<ConfigDescriptionParameter> configDescriptions, Map<String, ?> configurations) {
        this(uid, triggers, conditions, actions, configDescriptions, configurations, Visibility.VISIBLE);
    }

    public Rule(List<Trigger> triggers, List<Condition> conditions, List<Action> actions, List<ConfigDescriptionParameter> configDescriptions, Map<String, ?> configurations) {
        this(null, triggers, conditions, actions, configDescriptions, configurations, Visibility.VISIBLE);
    }

    public Rule(String ruleTemplateUID, Map<String, ?> configurations) {
        this(null, ruleTemplateUID, configurations);
    }

    public Rule(String uid, String ruleTemplateUID, Map<String, ?> configurations) {
        this.uid = uid;
        this.templateUID = ruleTemplateUID;
        this.setConfiguration(configurations);
    }

    public Rule(String uid, List<Trigger> triggers, List<Condition> conditions, List<Action> actions, List<ConfigDescriptionParameter> configDescriptions, Map<String, ?> configurations, String templateUID, Visibility visibility) {
        this(uid, triggers, conditions, actions, configDescriptions, configurations, visibility);
        this.templateUID = templateUID;
    }

    public String getUID() {
        return this.uid;
    }

    public String getTemplateUID() {
        return this.templateUID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String ruleName) throws IllegalStateException {
        this.name = ruleName;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> ruleTags) throws IllegalStateException {
        this.tags = ruleTags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String ruleDescription) {
        this.description = ruleDescription;
    }

    public Visibility getVisibility() {
        if (this.visibility == null) {
            return Visibility.VISIBLE;
        }
        return this.visibility;
    }

    public List<ConfigDescriptionParameter> getConfigurationDescriptions() {
        if (this.configDescriptions == null) {
            this.configDescriptions = new ArrayList<ConfigDescriptionParameter>(3);
        }
        return this.configDescriptions;
    }

    public Map<String, ?> getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new HashMap(3);
        }
        return this.configuration;
    }

    public void setConfiguration(Map<String, ?> ruleConfiguration) {
        if (ruleConfiguration != null) {
            this.configuration = ruleConfiguration;
        }
    }

    public List<Condition> getConditions() {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>(3);
        }
        return this.conditions;
    }

    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>(3);
        }
        return this.actions;
    }

    public List<Trigger> getTriggers() {
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>(3);
        }
        return this.triggers;
    }

    public Module getModule(String moduleId) {
        Module module = this.getModule(moduleId, this.triggers);
        if (module != null) {
            return module;
        }
        module = this.getModule(moduleId, this.conditions);
        if (module != null) {
            return module;
        }
        module = this.getModule(moduleId, this.actions);
        if (module != null) {
            return module;
        }
        return null;
    }

    private <T extends Module> T getModule(String moduleUID, List<T> modules) {
        if (modules != null) {
            for (Module module : modules) {
                if (!module.getId().equals(moduleUID)) continue;
                return (T)module;
            }
        }
        return null;
    }

    public <T extends Module> List<T> getModules(Class<T> moduleClazz) {
        List<Object> result = null;
        if (moduleClazz == null) {
            result = new ArrayList<Trigger>();
            result.addAll(this.getTriggers());
            result.addAll(this.getConditions());
            result.addAll(this.getActions());
        } else if (Trigger.class == moduleClazz) {
            result = this.getTriggers();
        } else if (Condition.class == moduleClazz) {
            result = this.getConditions();
        } else if (Action.class == moduleClazz) {
            result = this.getActions();
        }
        return result != null ? result : Collections.emptyList();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.templateUID == null ? 0 : this.templateUID.hashCode());
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        if (this.templateUID == null ? other.templateUID != null : !this.templateUID.equals(other.templateUID)) {
            return false;
        }
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }
}

