/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.type;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;

public abstract class ModuleType {
    private String uid;
    private Visibility visibility = Visibility.VISIBLE;
    private Set<String> tags;
    private String label;
    private String description;
    protected List<ConfigDescriptionParameter> configDescriptions;

    protected ModuleType() {
    }

    public ModuleType(String UID, List<ConfigDescriptionParameter> configDescriptions) {
        this.uid = UID;
        this.configDescriptions = configDescriptions;
    }

    public ModuleType(String UID, List<ConfigDescriptionParameter> configDescriptions, String label, String description, Set<String> tags, Visibility visibility) {
        this(UID, configDescriptions);
        this.label = label;
        this.description = description;
        this.tags = tags;
        this.visibility = visibility;
    }

    public String getUID() {
        return this.uid;
    }

    public List<ConfigDescriptionParameter> getConfigurationDescription() {
        return this.configDescriptions != null ? this.configDescriptions : Collections.emptyList();
    }

    public Set<String> getTags() {
        return this.tags != null ? this.tags : Collections.emptySet();
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Visibility getVisibility() {
        if (this.visibility == null) {
            return Visibility.VISIBLE;
        }
        return this.visibility;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleType other = (ModuleType)obj;
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }
}

