/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.ntp.internal;

import java.util.Locale;
import org.eclipse.smarthome.binding.ntp.NtpBindingConstants;
import org.eclipse.smarthome.binding.ntp.handler.NtpHandler;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;

public class NtpHandlerFactory
extends BaseThingHandlerFactory {
    private final LocaleProviderHolder localeProviderHolder = new LocaleProviderHolder();

    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProviderHolder.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProviderHolder.localeProvider = null;
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return NtpBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)NtpBindingConstants.THING_TYPE_NTP)) {
            return new NtpHandler(thing, this.localeProviderHolder);
        }
        return null;
    }

    private class LocaleProviderHolder
    implements LocaleProvider {
        private LocaleProvider localeProvider;

        private LocaleProviderHolder() {
        }

        public Locale getLocale() {
            return this.localeProvider.getLocale();
        }
    }
}

