/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonos.handler;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.sonos.SonosBindingConstants;
import org.eclipse.smarthome.binding.sonos.internal.SonosAlarm;
import org.eclipse.smarthome.binding.sonos.internal.SonosEntry;
import org.eclipse.smarthome.binding.sonos.internal.SonosMetaData;
import org.eclipse.smarthome.binding.sonos.internal.SonosXMLParser;
import org.eclipse.smarthome.binding.sonos.internal.SonosZoneGroup;
import org.eclipse.smarthome.binding.sonos.internal.SonosZonePlayerState;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.NextPreviousType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.PlayPauseType;
import org.eclipse.smarthome.core.library.types.RewindFastforwardType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOParticipant;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZonePlayerHandler
extends BaseThingHandler
implements UpnpIOParticipant,
DiscoveryListener {
    private Logger logger = LoggerFactory.getLogger(ZonePlayerHandler.class);
    private UpnpIOService service;
    private DiscoveryServiceRegistry discoveryServiceRegistry;
    private ScheduledFuture<?> pollingJob;
    private Calendar lastOPMLQuery = null;
    private SonosZonePlayerState savedState = null;
    private static final Collection<String> SERVICE_SUBSCRIPTIONS = Lists.newArrayList((Object[])new String[]{"DeviceProperties", "AVTransport", "ZoneGroupTopology", "GroupManagement", "RenderingControl", "AudioIn"});
    protected static final int SUBSCRIPTION_DURATION = 1800;
    private static final int SOCKET_TIMEOUT = 5000;
    private static final int NOTIFICATION_TIMEOUT = 20000;
    private final Object notificationLock = new Object();
    private String notificationSoundVolume = null;
    private ZonePlayerHandler coordinatorHandler;
    private static final int DEFAULT_REFRESH_INTERVAL = 60;
    private Map<String, String> stateMap = Collections.synchronizedMap(new HashMap());
    private final Object upnpLock = new Object();
    private final Object stateLock = new Object();
    private Runnable pollingRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                ZonePlayerHandler.this.updateZoneInfo();
                ZonePlayerHandler.this.updateRunningAlarmProperties();
                ZonePlayerHandler.this.updateLed();
                ZonePlayerHandler.this.updateMediaInfo();
                ZonePlayerHandler.this.updatePlayerState();
                ZonePlayerHandler.this.updateSleepTimerDuration();
            }
            catch (Exception e) {
                ZonePlayerHandler.this.logger.debug("Exception during poll : {}", (Throwable)e);
            }
        }
    };
    private String opmlUrl;

    public ZonePlayerHandler(Thing thing, UpnpIOService upnpIOService, DiscoveryServiceRegistry discoveryServiceRegistry, String opmlUrl) {
        super(thing);
        this.opmlUrl = opmlUrl;
        this.logger.debug("Creating a ZonePlayerHandler for thing '{}'", (Object)this.getThing().getUID());
        if (upnpIOService != null) {
            this.service = upnpIOService;
        }
        if (discoveryServiceRegistry != null) {
            this.discoveryServiceRegistry = discoveryServiceRegistry;
        }
    }

    public void dispose() {
        this.logger.debug("Handler disposed.");
        if (this.pollingJob != null && !this.pollingJob.isCancelled()) {
            this.pollingJob.cancel(true);
            this.pollingJob = null;
        }
        this.discoveryServiceRegistry.removeDiscoveryListener((DiscoveryListener)this);
        this.removeSubscription();
    }

    public void initialize() {
        if (this.migrateThingType()) {
            return;
        }
        Configuration configuration = this.getConfig();
        if (configuration.get("udn") != null) {
            this.discoveryServiceRegistry.addDiscoveryListener((DiscoveryListener)this);
            this.notificationSoundVolume = this.getVolume();
            this.onUpdate();
            super.initialize();
        } else {
            this.logger.warn("Cannot initalize the zoneplayer. UDN not set.");
        }
    }

    public void thingDiscovered(DiscoveryService source, DiscoveryResult result) {
        if (result.getThingUID().equals((Object)this.getThing().getUID()) && this.getThing().getConfiguration().get("udn").equals(result.getProperties().get("udn"))) {
            this.logger.debug("Discovered UDN '{}' for thing '{}'", result.getProperties().get("udn"), (Object)this.getThing().getUID());
            this.updateStatus(ThingStatus.ONLINE);
            this.onUpdate();
        }
    }

    public void thingRemoved(DiscoveryService source, ThingUID thingUID) {
        if (thingUID.equals((Object)this.getThing().getUID())) {
            this.logger.debug("Setting status for thing '{}' to OFFLINE", (Object)this.getThing().getUID());
            this.updateStatus(ThingStatus.OFFLINE);
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        switch (channelUID.getId()) {
            case "led": {
                this.setLed(command);
                break;
            }
            case "mute": {
                this.setMute(command);
                break;
            }
            case "notificationsound": {
                this.scheduleNotificationSound(command);
                break;
            }
            case "notificationvolume": {
                this.setNotificationSoundVolume(command);
                break;
            }
            case "stop": {
                this.getCoordinatorHandler().stop();
                break;
            }
            case "volume": {
                this.setVolumeForGroup(command);
                break;
            }
            case "add": {
                this.addMember(command);
                break;
            }
            case "remove": {
                this.removeMember(command);
                break;
            }
            case "standalone": {
                this.becomeStandAlonePlayer();
                break;
            }
            case "publicaddress": {
                this.publicAddress();
                break;
            }
            case "radio": {
                this.playRadio(command);
                break;
            }
            case "favorite": {
                this.playFavorite(command);
                break;
            }
            case "alarm": {
                this.setAlarm(command);
                break;
            }
            case "snooze": {
                this.snoozeAlarm(command);
                break;
            }
            case "saveall": {
                this.saveAllPlayerState();
                break;
            }
            case "restoreall": {
                this.restoreAllPlayerState();
                break;
            }
            case "save": {
                this.saveState();
                break;
            }
            case "restore": {
                this.restoreState();
                break;
            }
            case "playlist": {
                this.playPlayList(command);
                break;
            }
            case "playqueue": {
                this.playQueue(command);
                break;
            }
            case "playtrack": {
                this.playTrack(command);
                break;
            }
            case "playuri": {
                this.playURI(command);
                break;
            }
            case "playlinein": {
                this.playLineIn(command);
                break;
            }
            case "control": {
                if (command instanceof PlayPauseType) {
                    if (command == PlayPauseType.PLAY) {
                        this.getCoordinatorHandler().play();
                    } else if (command == PlayPauseType.PAUSE) {
                        this.getCoordinatorHandler().pause();
                    }
                }
                if (command instanceof NextPreviousType) {
                    if (command == NextPreviousType.NEXT) {
                        this.getCoordinatorHandler().next();
                    } else if (command == NextPreviousType.PREVIOUS) {
                        this.getCoordinatorHandler().previous();
                    }
                }
                boolean cfr_ignored_0 = command instanceof RewindFastforwardType;
                break;
            }
            case "sleeptimer": {
                this.setSleepTimer(command);
                break;
            }
        }
    }

    private void restoreAllPlayerState() {
        Collection allThings = this.thingRegistry.getAll();
        for (Thing aThing : allThings) {
            if (!aThing.getThingTypeUID().equals((Object)this.getThing().getThingTypeUID())) continue;
            ZonePlayerHandler handler = (ZonePlayerHandler)aThing.getHandler();
            handler.restoreState();
        }
    }

    private void saveAllPlayerState() {
        Collection allThings = this.thingRegistry.getAll();
        for (Thing aThing : allThings) {
            if (!aThing.getThingTypeUID().equals((Object)this.getThing().getThingTypeUID())) continue;
            ZonePlayerHandler handler = (ZonePlayerHandler)aThing.getHandler();
            handler.saveState();
        }
    }

    public void onValueReceived(String variable, String value, String service) {
        block75: {
            Map<String, String> parsedValues;
            if (this.getThing().getStatus() != ThingStatus.ONLINE) break block75;
            this.logger.trace("Received pair '{}':'{}' (service '{}') for thing '{}'", new Object[]{variable, value, service, this.getThing().getUID()});
            String oldValue = this.stateMap.get(variable);
            if (this.shouldIgnoreVariableUpdate(variable, value, oldValue)) {
                return;
            }
            this.stateMap.put(variable, value);
            if (service.equals("AVTransport") && variable.equals("LastChange")) {
                parsedValues = SonosXMLParser.getAVTransportFromXML(value);
                for (String parsedValue : parsedValues.keySet()) {
                    this.onValueReceived(parsedValue, parsedValues.get(parsedValue), "AVTransport");
                }
            }
            if (service.equals("RenderingControl") && variable.equals("LastChange")) {
                parsedValues = SonosXMLParser.getRenderingControlFromXML(value);
                for (String parsedValue : parsedValues.keySet()) {
                    this.onValueReceived(parsedValue, parsedValues.get(parsedValue), "RenderingControl");
                }
            }
            switch (variable) {
                case "TransportState": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "state"), (State)(this.stateMap.get("TransportState") != null ? new StringType(this.stateMap.get("TransportState")) : UnDefType.UNDEF));
                    if (this.stateMap.get("TransportState").equals("PLAYING")) {
                        this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "control"), (State)PlayPauseType.PLAY);
                    }
                    if (this.stateMap.get("TransportState").equals("STOPPED")) {
                        this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "control"), (State)PlayPauseType.PAUSE);
                    }
                    if (this.stateMap.get("TransportState").equals("PAUSED_PLAYBACK")) {
                        this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "control"), (State)PlayPauseType.PAUSE);
                    }
                    if (!this.isCoordinator()) break;
                    for (String member : this.getOtherZoneGroupMembers()) {
                        ZonePlayerHandler memberHandler = this.getHandlerByName(member);
                        if (memberHandler == null || memberHandler.getThing() == null || !ThingStatus.ONLINE.equals((Object)memberHandler.getThing().getStatus())) continue;
                        memberHandler.onValueReceived("TransportState", value, service);
                    }
                    break;
                }
                case "CurrentLEDState": {
                    UnDefType newState = UnDefType.UNDEF;
                    if (this.stateMap.get("CurrentLEDState") != null) {
                        newState = this.stateMap.get("CurrentLEDState").equals("On") ? OnOffType.ON : OnOffType.OFF;
                    }
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "led"), (State)newState);
                    break;
                }
                case "CurrentZoneName": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "zonename"), (State)(this.stateMap.get("CurrentZoneName") != null ? new StringType(this.stateMap.get("CurrentZoneName")) : UnDefType.UNDEF));
                }
                case "ZoneGroupState": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "zonegroup"), (State)(this.stateMap.get("ZoneGroupState") != null ? new StringType(this.stateMap.get("ZoneGroupState")) : UnDefType.UNDEF));
                    this.updateGroupCoordinator();
                    break;
                }
                case "LocalGroupUUID": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "zonegroupid"), (State)(this.stateMap.get("LocalGroupUUID") != null ? new StringType(this.stateMap.get("LocalGroupUUID")) : UnDefType.UNDEF));
                    break;
                }
                case "GroupCoordinatorIsLocal": {
                    UnDefType newState = UnDefType.UNDEF;
                    if (this.stateMap.get("GroupCoordinatorIsLocal") != null) {
                        newState = this.stateMap.get("GroupCoordinatorIsLocal").equals("On") ? OnOffType.ON : OnOffType.OFF;
                    }
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "localcoordinator"), (State)newState);
                    break;
                }
                case "VolumeMaster": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "volume"), (State)(this.stateMap.get("VolumeMaster") != null ? new PercentType(this.stateMap.get("VolumeMaster")) : UnDefType.UNDEF));
                    break;
                }
                case "MuteMaster": {
                    UnDefType newState = UnDefType.UNDEF;
                    if (this.stateMap.get("MuteMaster") != null) {
                        newState = this.stateMap.get("MuteMaster").equals("On") ? OnOffType.ON : OnOffType.OFF;
                    }
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "mute"), (State)newState);
                    break;
                }
                case "LineInConnected": {
                    UnDefType newState = UnDefType.UNDEF;
                    if (this.stateMap.get("LineInConnected") != null) {
                        newState = this.stateMap.get("LineInConnected").equals("On") ? OnOffType.ON : OnOffType.OFF;
                    }
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "linein"), (State)newState);
                    break;
                }
                case "AlarmRunning": {
                    UnDefType newState = UnDefType.UNDEF;
                    if (this.stateMap.get("AlarmRunning") != null) {
                        newState = this.stateMap.get("AlarmRunning").equals("On") ? OnOffType.ON : OnOffType.OFF;
                    }
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "alarmrunning"), (State)newState);
                    break;
                }
                case "RunningAlarmProperties": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "alarmproperties"), (State)(this.stateMap.get("RunningAlarmProperties") != null ? new StringType(this.stateMap.get("RunningAlarmProperties")) : UnDefType.UNDEF));
                    break;
                }
                case "CurrentURIFormatted": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "currenttrack"), (State)(this.stateMap.get("CurrentURIFormatted") != null ? new StringType(this.stateMap.get("CurrentURIFormatted")) : UnDefType.UNDEF));
                    break;
                }
                case "CurrentTitle": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "currenttitle"), (State)(this.stateMap.get("CurrentTitle") != null ? new StringType(this.stateMap.get("CurrentTitle")) : UnDefType.UNDEF));
                    break;
                }
                case "CurrentArtist": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "currentartist"), (State)(this.stateMap.get("CurrentArtist") != null ? new StringType(this.stateMap.get("CurrentArtist")) : UnDefType.UNDEF));
                    break;
                }
                case "CurrentAlbum": {
                    this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "currentalbum"), (State)(this.stateMap.get("CurrentAlbum") != null ? new StringType(this.stateMap.get("CurrentAlbum")) : UnDefType.UNDEF));
                    break;
                }
                case "CurrentTrackMetaData": {
                    this.updateTrackMetaData();
                    break;
                }
                case "CurrentURI": {
                    this.updateCurrentURIFormatted(value);
                    break;
                }
                case "SleepTimerGeneration": {
                    if (!value.equals("0")) break;
                    this.updateState("sleeptimer", (State)new DecimalType(0L));
                    break;
                }
                case "RemainingSleepTimerDuration": {
                    this.updateState("sleeptimer", (State)(this.stateMap.get("RemainingSleepTimerDuration") != null ? new DecimalType(this.sleepStrTimeToSeconds(this.stateMap.get("RemainingSleepTimerDuration"))) : UnDefType.UNDEF));
                }
            }
        }
    }

    public void channelLinked(ChannelUID channelUID) {
        if (channelUID.getId().equalsIgnoreCase("coordinator")) {
            this.updateGroupCoordinator();
        }
    }

    private boolean shouldIgnoreVariableUpdate(String variable, String value, String oldValue) {
        return !this.hasValueChanged(value, oldValue) && !this.isQueueEvent(variable) && !"CurrentURI".equals(variable) && !"CurrentTrackMetaData".equals(variable);
    }

    private boolean hasValueChanged(String value, String oldValue) {
        return oldValue != null ? !oldValue.equals(value) : value != null;
    }

    private boolean isQueueEvent(String variable) {
        return "LastChange".equals(variable);
    }

    private void updateGroupCoordinator() {
        this.updateState(new ChannelUID(this.getThing().getThingTypeUID(), this.getThing().getUID(), "coordinator"), (State)new StringType(this.getCoordinator()));
        this.coordinatorHandler = this.getHandlerByName(this.getCoordinator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubscription() {
        Object object = this.upnpLock;
        synchronized (object) {
            if (this.service.isRegistered((UpnpIOParticipant)this)) {
                for (String subscription : SERVICE_SUBSCRIPTIONS) {
                    this.service.removeSubscription((UpnpIOParticipant)this, subscription);
                }
                this.service.unregisterParticipant((UpnpIOParticipant)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdate() {
        Object object = this.upnpLock;
        synchronized (object) {
            if (this.service.isRegistered((UpnpIOParticipant)this)) {
                for (String subscription : SERVICE_SUBSCRIPTIONS) {
                    this.service.addSubscription((UpnpIOParticipant)this, subscription, 1800);
                }
                if (this.pollingJob == null || this.pollingJob.isCancelled()) {
                    Configuration config = this.getThing().getConfiguration();
                    int refreshInterval = 60;
                    Object refreshConfig = config.get("refresh");
                    if (refreshConfig != null) {
                        refreshInterval = ((BigDecimal)refreshConfig).intValue();
                    }
                    this.pollingJob = this.scheduler.scheduleAtFixedRate(this.pollingRunnable, 0L, refreshInterval, TimeUnit.SECONDS);
                }
            }
        }
    }

    private void updatePlayerState() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetZoneInfo", null);
        if (result.isEmpty()) {
            this.logger.debug("Sonos player " + (String)this.getThing().getProperties().get("modelId") + " is not available in local network");
            this.updateStatus(ThingStatus.OFFLINE);
        } else if (!ThingStatus.ONLINE.equals((Object)this.getThing().getStatus())) {
            this.logger.debug("Sonos player " + (String)this.getThing().getProperties().get("modelId") + " has been found in local network");
            this.updateStatus(ThingStatus.ONLINE);
        }
    }

    protected void updateMediaInfo() {
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("InstanceID", "0");
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "GetMediaInfo", inputs);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    protected void updateCurrentZoneName() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetZoneAttributes", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "DeviceProperties");
        }
    }

    protected void updateLed() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetLEDState", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "DeviceProperties");
        }
    }

    protected void updateTime() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AlarmClock", "GetTimeNow", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AlarmClock");
        }
    }

    protected void updatePosition() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "GetPositionInfo", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    protected void updateRunningAlarmProperties() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "GetRunningAlarmProperties", null);
        String alarmID = (String)result.get("AlarmID");
        String loggedStartTime = (String)result.get("LoggedStartTime");
        String newStringValue = null;
        newStringValue = alarmID != null && loggedStartTime != null ? String.valueOf(alarmID) + " - " + loggedStartTime : "No running alarm";
        result.put("RunningAlarmProperties", newStringValue);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    protected void updateZoneInfo() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetZoneInfo", null);
        Map result2 = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetZoneAttributes", null);
        result.putAll(result2);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "DeviceProperties");
        }
    }

    public String getCoordinator() {
        if (this.stateMap.get("ZoneGroupState") != null) {
            List<SonosZoneGroup> zoneGroups = SonosXMLParser.getZoneGroupFromXML(this.stateMap.get("ZoneGroupState"));
            for (SonosZoneGroup zg : zoneGroups) {
                if (!zg.getMembers().contains(this.getThing().getConfiguration().get("udn"))) continue;
                return zg.getCoordinator();
            }
        }
        return (String)this.getThing().getConfiguration().get("udn");
    }

    public boolean isCoordinator() {
        return this.getUDN().equals(this.getCoordinator());
    }

    protected void updateTrackMetaData() {
        ZonePlayerHandler coordinatorHandler = this.getCoordinatorHandler();
        SonosMetaData currentTrack = this.getTrackMetadata();
        if (coordinatorHandler != null && coordinatorHandler != this) {
            coordinatorHandler.updateMediaInfo();
            currentTrack = coordinatorHandler.getTrackMetadata();
        }
        String artist = null;
        String title = null;
        String album = null;
        if (currentTrack != null) {
            artist = currentTrack.getAlbumArtist().equals("") ? currentTrack.getCreator() : currentTrack.getAlbumArtist();
            if (!currentTrack.getTitle().contains("x-sonosapi-stream")) {
                title = currentTrack.getTitle();
            }
            album = currentTrack.getAlbum();
        }
        for (String member : this.getZoneGroupMembers()) {
            ZonePlayerHandler memberHandler = this.getHandlerByName(member);
            if (memberHandler == null || memberHandler.getThing() == null || !ThingStatus.ONLINE.equals((Object)memberHandler.getThing().getStatus())) continue;
            memberHandler.onValueReceived("CurrentArtist", artist != null ? artist : "", "AVTransport");
            memberHandler.onValueReceived("CurrentTitle", title != null ? title : "", "AVTransport");
            memberHandler.onValueReceived("CurrentAlbum", album != null ? album : "", "AVTransport");
        }
        this.updateMediaInfo();
    }

    protected void updateCurrentURIFormatted(String URI2) {
        String currentURI = URI2;
        SonosMetaData currentTrack = null;
        ZonePlayerHandler coordinatorHandler = this.getCoordinatorHandler();
        if (coordinatorHandler != null && coordinatorHandler != this) {
            if (currentURI.contains("x-rincon-stream")) {
                coordinatorHandler.updateMediaInfo();
            }
            currentURI = coordinatorHandler.getCurrentURI();
            currentTrack = coordinatorHandler.getTrackMetadata();
        } else {
            currentTrack = this.getTrackMetadata();
        }
        if (currentURI != null) {
            String title = this.stateMap.get("CurrentTitle");
            String resultString = this.stateMap.get("CurrentURIFormatted");
            boolean needsUpdating = false;
            if (this.opmlUrl != null && currentURI.contains("x-sonosapi-stream")) {
                String stationID = StringUtils.substringBetween((String)currentURI, (String)":s", (String)"?sid");
                String previousStationID = this.stateMap.get("StationID");
                Calendar now = Calendar.getInstance();
                now.setTime(new Date());
                now.add(12, -1);
                if (previousStationID == null || !previousStationID.equals(stationID) || this.lastOPMLQuery == null || this.lastOPMLQuery.before(now)) {
                    List<String> fields;
                    this.onValueReceived("StationID", stationID, "AVTransport");
                    String url = this.opmlUrl;
                    url = StringUtils.replace((String)url, (String)"%id", (String)stationID);
                    url = StringUtils.replace((String)url, (String)"%serial", (String)this.getMACAddress());
                    String response = HttpUtil.executeUrl((String)"GET", (String)url, (int)5000);
                    if (this.lastOPMLQuery == null) {
                        this.lastOPMLQuery = Calendar.getInstance();
                    }
                    this.lastOPMLQuery.setTime(new Date());
                    if (response != null && (fields = SonosXMLParser.getRadioTimeFromXML(response)) != null && fields.size() > 0) {
                        resultString = new String();
                        title = fields.get(0);
                        ListIterator<String> listIterator = fields.listIterator();
                        while (listIterator.hasNext()) {
                            String field = (String)listIterator.next();
                            resultString = String.valueOf(resultString) + field;
                            if (!listIterator.hasNext()) continue;
                            resultString = String.valueOf(resultString) + " - ";
                        }
                        needsUpdating = true;
                    }
                }
            }
            if (currentURI.contains("x-rincon-stream") && currentTrack != null) {
                resultString = this.stateMap.get("CurrentTitle");
                needsUpdating = true;
            }
            if (!(currentURI.contains("x-rincon-mp3") || currentURI.contains("x-rincon-stream") || currentURI.contains("x-sonosapi"))) {
                if (currentTrack == null) {
                    resultString = null;
                    title = null;
                } else {
                    resultString = currentTrack.getAlbumArtist().equals("") ? String.valueOf(currentTrack.getCreator()) + " - " + currentTrack.getAlbum() + " - " + currentTrack.getTitle() : String.valueOf(currentTrack.getAlbumArtist()) + " - " + currentTrack.getAlbum() + " - " + currentTrack.getTitle();
                }
                needsUpdating = true;
            }
            if (needsUpdating) {
                for (String member : this.getZoneGroupMembers()) {
                    ZonePlayerHandler memberHandler = this.getHandlerByName(member);
                    if (memberHandler == null || memberHandler.getThing() == null || !ThingStatus.ONLINE.equals((Object)memberHandler.getThing().getStatus())) continue;
                    memberHandler.onValueReceived("CurrentURIFormatted", resultString != null ? resultString : "", "AVTransport");
                    memberHandler.onValueReceived("CurrentTitle", title != null ? title : "", "AVTransport");
                }
            }
        }
    }

    public boolean isGroupCoordinator() {
        String value = this.stateMap.get("GroupCoordinatorIsLocal");
        if (value != null) {
            return value.equals("1");
        }
        return false;
    }

    public String getUDN() {
        return (String)this.getThing().getConfiguration().get("udn");
    }

    public String getCurrentURI() {
        return this.stateMap.get("CurrentURI");
    }

    public SonosMetaData getCurrentURIMetadata() {
        if (this.stateMap.get("CurrentURIMetaData") != null && !this.stateMap.get("CurrentURIMetaData").isEmpty()) {
            return SonosXMLParser.getMetaDataFromXML(this.stateMap.get("CurrentURIMetaData"));
        }
        return null;
    }

    public SonosMetaData getTrackMetadata() {
        if (this.stateMap.get("CurrentTrackMetaData") != null && !this.stateMap.get("CurrentTrackMetaData").isEmpty()) {
            return SonosXMLParser.getMetaDataFromXML(this.stateMap.get("CurrentTrackMetaData"));
        }
        return null;
    }

    public SonosMetaData getEnqueuedTransportURIMetaData() {
        if (this.stateMap.get("EnqueuedTransportURIMetaData") != null && !this.stateMap.get("EnqueuedTransportURIMetaData").isEmpty()) {
            return SonosXMLParser.getMetaDataFromXML(this.stateMap.get("EnqueuedTransportURIMetaData"));
        }
        return null;
    }

    public String getMACAddress() {
        this.updateZoneInfo();
        return this.stateMap.get("MACAddress");
    }

    public String getPosition() {
        this.updatePosition();
        return this.stateMap.get("RelTime");
    }

    public long getCurrenTrackNr() {
        this.updatePosition();
        String value = this.stateMap.get("Track");
        if (value != null) {
            return Long.valueOf(value);
        }
        return -1L;
    }

    public String getVolume() {
        return this.stateMap.get("VolumeMaster");
    }

    public String getTransportState() {
        return this.stateMap.get("TransportState");
    }

    public List<SonosEntry> getArtists(String filter) {
        return this.getEntries("A:", filter);
    }

    public List<SonosEntry> getArtists() {
        return this.getEntries("A:", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getAlbums(String filter) {
        return this.getEntries("A:ALBUM", filter);
    }

    public List<SonosEntry> getAlbums() {
        return this.getEntries("A:ALBUM", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getTracks(String filter) {
        return this.getEntries("A:TRACKS", filter);
    }

    public List<SonosEntry> getTracks() {
        return this.getEntries("A:TRACKS", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getQueue(String filter) {
        return this.getEntries("Q:0", filter);
    }

    public List<SonosEntry> getQueue() {
        return this.getEntries("Q:0", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getPlayLists(String filter) {
        return this.getEntries("SQ:", filter);
    }

    public List<SonosEntry> getPlayLists() {
        return this.getEntries("SQ:", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getFavoriteRadios(String filter) {
        return this.getEntries("R:0/0", filter);
    }

    public List<SonosEntry> getFavoriteRadios() {
        return this.getEntries("R:0/0", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getFavorites() {
        return this.getEntries("FV:2", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    protected List<SonosEntry> getEntries(String type, String filter) {
        long startAt = 0L;
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("ObjectID", type);
        inputs.put("BrowseFlag", "BrowseDirectChildren");
        inputs.put("Filter", filter);
        inputs.put("StartingIndex", Long.toString(startAt));
        inputs.put("RequestedCount", Integer.toString(200));
        inputs.put("SortCriteria", "");
        List<SonosEntry> resultList = null;
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "ContentDirectory", "Browse", inputs);
        long totalMatches = this.getResultEntry(result, "TotalMatches", type, filter);
        long initialNumberReturned = this.getResultEntry(result, "NumberReturned", type, filter);
        String initialResult = (String)result.get("Result");
        resultList = SonosXMLParser.getEntriesFromString(initialResult);
        startAt += initialNumberReturned;
        while (startAt < totalMatches) {
            inputs.put("StartingIndex", Long.toString(startAt));
            result = this.service.invokeAction((UpnpIOParticipant)this, "ContentDirectory", "Browse", inputs);
            String nextResult = (String)result.get("Result");
            long numberReturned = this.getResultEntry(result, "NumberReturned", type, filter);
            resultList.addAll(SonosXMLParser.getEntriesFromString(nextResult));
            startAt += numberReturned;
        }
        return resultList;
    }

    private Long getResultEntry(Map<String, String> resultInput, String requestedKey, String entriesType, String entriesFilter) {
        long result = 0L;
        try {
            result = Long.valueOf(resultInput.get(requestedKey));
        }
        catch (NumberFormatException ex) {
            this.logger.warn("Could not fetch " + requestedKey + " result for type: " + entriesType + " and filter: " + entriesFilter + ". Using default value '0': " + ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveState() {
        Object object = this.stateLock;
        synchronized (object) {
            this.savedState = new SonosZonePlayerState();
            String currentURI = this.getCurrentURI();
            this.savedState.transportState = this.getTransportState();
            this.savedState.volume = this.getVolume();
            if (currentURI != null) {
                if (this.isPlayingStream(currentURI)) {
                    SonosMetaData track = this.getTrackMetadata();
                    SonosMetaData current = this.getCurrentURIMetadata();
                    if (track != null && current != null) {
                        this.savedState.entry = new SonosEntry("", current.getTitle(), "", "", track.getAlbumArtUri(), "", current.getUpnpClass(), currentURI);
                    }
                } else if (currentURI.contains("x-rincon:")) {
                    this.savedState.entry = new SonosEntry("", "", "", "", "", "", "", currentURI);
                } else if (currentURI.contains("x-rincon-stream:")) {
                    this.savedState.entry = new SonosEntry("", "", "", "", "", "", "", currentURI);
                } else if (this.isPlayingQueue(currentURI)) {
                    SonosMetaData queued = this.getEnqueuedTransportURIMetaData();
                    if (queued != null) {
                        this.savedState.track = this.getCurrenTrackNr();
                        if (queued.getUpnpClass().contains("object.container.playlistContainer")) {
                            List<SonosEntry> playLists = this.getPlayLists();
                            for (SonosEntry someList : playLists) {
                                if (!someList.getTitle().equals(queued.getTitle())) continue;
                                this.savedState.entry = new SonosEntry(someList.getId(), someList.getTitle(), someList.getParentId(), "", "", "", someList.getUpnpClass(), someList.getRes());
                                break;
                            }
                        } else if (queued.getUpnpClass().contains("object.container")) {
                            this.logger.debug("Save State for a container of type {}", (Object)queued.getUpnpClass());
                            String existingList = "";
                            List<SonosEntry> playLists = this.getPlayLists();
                            for (SonosEntry someList : playLists) {
                                if (!someList.getTitle().equals("openHAB-" + this.getUDN())) continue;
                                existingList = someList.getId();
                                break;
                            }
                            this.saveQueue("openHAB-" + this.getUDN(), existingList);
                            playLists = this.getPlayLists();
                            for (SonosEntry someList : playLists) {
                                if (!someList.getTitle().equals("openHAB-" + this.getUDN())) continue;
                                this.savedState.entry = new SonosEntry(someList.getId(), someList.getTitle(), someList.getParentId(), "", "", "", someList.getUpnpClass(), someList.getRes());
                                break;
                            }
                        }
                    } else {
                        this.savedState.entry = new SonosEntry("", "", "", "", "", "", "", "x-rincon-queue:" + this.getUDN() + "#0");
                    }
                }
                this.savedState.relTime = this.getPosition();
            } else {
                this.savedState.entry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreState() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.savedState != null) {
                if (this.savedState.volume != null) {
                    this.setVolume((Command)DecimalType.valueOf((String)this.savedState.volume));
                }
                if (this.isCoordinator()) {
                    if (this.savedState.entry != null) {
                        if (this.savedState.entry.getUpnpClass().contains("object.container.playlistContainer")) {
                            this.addURIToQueue(this.savedState.entry.getRes(), SonosXMLParser.compileMetadataString(this.savedState.entry), 0, true);
                            SonosEntry entry = new SonosEntry("", "", "", "", "", "", "", "x-rincon-queue:" + this.getUDN() + "#0");
                            this.setCurrentURI(entry);
                            this.setPositionTrack(this.savedState.track);
                        } else {
                            this.setCurrentURI(this.savedState.entry);
                            this.setPosition(this.savedState.relTime);
                        }
                    }
                    if (this.savedState.transportState != null) {
                        if (this.savedState.transportState.equals("PLAYING")) {
                            this.play();
                        } else if (this.savedState.transportState.equals("STOPPED")) {
                            this.stop();
                        } else if (this.savedState.transportState.equals("PAUSED_PLAYBACK")) {
                            this.pause();
                        }
                    }
                }
            }
        }
    }

    public void saveQueue(String name, String queueID) {
        if (name != null && queueID != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("Title", name);
            inputs.put("ObjectID", queueID);
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "SaveQueue", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void setVolume(Command command) {
        if (command != null && (command instanceof OnOffType || command instanceof IncreaseDecreaseType || command instanceof DecimalType || command instanceof PercentType)) {
            int i;
            HashMap<String, String> inputs = new HashMap<String, String>();
            String newValue = null;
            if (command instanceof IncreaseDecreaseType && command == IncreaseDecreaseType.INCREASE) {
                i = Integer.valueOf(this.getVolume());
                newValue = String.valueOf(Math.min(100, i + 1));
            } else if (command instanceof IncreaseDecreaseType && command == IncreaseDecreaseType.DECREASE) {
                i = Integer.valueOf(this.getVolume());
                newValue = String.valueOf(Math.max(0, i - 1));
            } else if (command instanceof OnOffType && command == OnOffType.ON) {
                newValue = "100";
            } else if (command instanceof OnOffType && command == OnOffType.OFF) {
                newValue = "0";
            } else if (command instanceof DecimalType) {
                newValue = command.toString();
            } else {
                return;
            }
            inputs.put("Channel", "Master");
            inputs.put("DesiredVolume", newValue);
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "RenderingControl", "SetVolume", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "RenderingControl");
            }
        }
    }

    public void setVolumeForGroup(Command command) {
        if (this.isAdHocGroup() || this.isStandalonePlayer()) {
            this.setVolume(command);
        } else {
            this.getCoordinatorHandler().setVolume(command);
        }
    }

    private boolean isAdHocGroup() {
        List<String> zoneGroupMemberNames;
        SonosZoneGroup currentZoneGroup = this.getCurrentZoneGroup();
        if (currentZoneGroup != null && (zoneGroupMemberNames = currentZoneGroup.getMemberZoneNames()) != null) {
            for (String zoneName : zoneGroupMemberNames) {
                if (zoneName.equals(zoneGroupMemberNames.get(0))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStandalonePlayer() {
        return this.getCurrentZoneGroup() != null ? this.getCurrentZoneGroup().getMembers().size() == 1 : true;
    }

    private SonosZoneGroup getCurrentZoneGroup() {
        String zoneGroupState = this.stateMap.get("ZoneGroupState");
        if (zoneGroupState != null) {
            List<SonosZoneGroup> zoneGroups = SonosXMLParser.getZoneGroupFromXML(zoneGroupState);
            for (SonosZoneGroup zoneGroup : zoneGroups) {
                if (!zoneGroup.getMembers().contains(this.getThing().getConfiguration().get("udn"))) continue;
                return zoneGroup;
            }
        }
        this.logger.warn("Could not fetch Sonos group state information");
        return null;
    }

    public void setNotificationSoundVolume(Command command) {
        if (command != null) {
            this.notificationSoundVolume = command.toString();
        }
    }

    public void addURIToQueue(String URI2, String meta, int desiredFirstTrack, boolean enqueueAsNext) {
        if (URI2 != null && meta != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            try {
                inputs.put("InstanceID", "0");
                inputs.put("EnqueuedURI", URI2);
                inputs.put("EnqueuedURIMetaData", meta);
                inputs.put("DesiredFirstTrackNumberEnqueued", Integer.toString(desiredFirstTrack));
                inputs.put("EnqueueAsNext", Boolean.toString(enqueueAsNext));
            }
            catch (NumberFormatException ex) {
                this.logger.error("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "AddURIToQueue", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void setCurrentURI(SonosEntry newEntry) {
        this.setCurrentURI(newEntry.getRes(), SonosXMLParser.compileMetadataString(newEntry));
    }

    public void setCurrentURI(String URI2, String URIMetaData) {
        if (URI2 != null && URIMetaData != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            try {
                inputs.put("InstanceID", "0");
                inputs.put("CurrentURI", URI2);
                inputs.put("CurrentURIMetaData", URIMetaData);
            }
            catch (NumberFormatException ex) {
                this.logger.error("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "SetAVTransportURI", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void setPosition(String relTime) {
        this.seek("REL_TIME", relTime);
    }

    public void setPositionTrack(long tracknr) {
        this.seek("TRACK_NR", Long.toString(tracknr));
    }

    public void setPositionTrack(String tracknr) {
        this.seek("TRACK_NR", tracknr);
    }

    protected void seek(String unit, String target) {
        if (unit != null && target != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            try {
                inputs.put("InstanceID", "0");
                inputs.put("Unit", unit);
                inputs.put("Target", target);
            }
            catch (NumberFormatException ex) {
                this.logger.error("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Seek", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void play() {
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("Speed", "1");
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Play", inputs);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void stop() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Stop", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void pause() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Pause", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void removeAllTracksFromQueue() {
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("InstanceID", "0");
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "RemoveAllTracksFromQueue", inputs);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void playLineIn(Command command) {
        if (command != null && command instanceof StringType) {
            String remotePlayerName = command.toString();
            ZonePlayerHandler coordinatorHandler = this.getCoordinatorHandler();
            ZonePlayerHandler remoteHandler = this.getHandlerByName(remotePlayerName);
            if (coordinatorHandler != null && remoteHandler != null) {
                coordinatorHandler.stop();
                coordinatorHandler.setCurrentURI("x-rincon-stream:" + remoteHandler.getConfig().get("udn"), "");
                coordinatorHandler.setMute((Command)OnOffType.OFF);
                coordinatorHandler.play();
            }
        }
    }

    private ZonePlayerHandler getCoordinatorHandler() {
        if (this.coordinatorHandler == null) {
            this.coordinatorHandler = this.getHandlerByName(this.getCoordinator());
        }
        return this.coordinatorHandler;
    }

    protected List<String> getZoneGroupMembers() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.stateMap.get("ZoneGroupState") != null) {
            List<SonosZoneGroup> zoneGroups = SonosXMLParser.getZoneGroupFromXML(this.stateMap.get("ZoneGroupState"));
            for (SonosZoneGroup zg : zoneGroups) {
                if (!zg.getMembers().contains(this.getThing().getConfiguration().get("udn"))) continue;
                result.addAll(zg.getMembers());
                break;
            }
        }
        return result;
    }

    protected List<String> getOtherZoneGroupMembers() {
        List<String> zoneGroupMembers = this.getZoneGroupMembers();
        zoneGroupMembers.remove(this.getThing().getConfiguration().get("udn"));
        return zoneGroupMembers;
    }

    protected ZonePlayerHandler getHandlerByName(String remotePlayerName) {
        if (this.thingRegistry != null) {
            for (ThingTypeUID supportedThingType : SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS) {
                Thing thing = this.thingRegistry.get(new ThingUID(supportedThingType, remotePlayerName));
                if (thing == null) {
                    Collection allThings = this.thingRegistry.getAll();
                    for (Thing aThing : allThings) {
                        if (!aThing.getThingTypeUID().equals((Object)this.getThing().getThingTypeUID()) || !aThing.getConfiguration().get("udn").equals(remotePlayerName)) continue;
                        thing = aThing;
                        break;
                    }
                }
                if (thing == null) continue;
                return (ZonePlayerHandler)thing.getHandler();
            }
        }
        return null;
    }

    public void setMute(Command command) {
        if (command != null && (command instanceof OnOffType || command instanceof OpenClosedType || command instanceof UpDownType)) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("Channel", "Master");
            if (command.equals(OnOffType.ON) || command.equals(UpDownType.UP) || command.equals(OpenClosedType.OPEN)) {
                inputs.put("DesiredMute", "True");
            } else if (command.equals(OnOffType.OFF) || command.equals(UpDownType.DOWN) || command.equals(OpenClosedType.CLOSED)) {
                inputs.put("DesiredMute", "False");
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "RenderingControl", "SetMute", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "RenderingControl");
            }
        }
    }

    public List<SonosAlarm> getCurrentAlarmList() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AlarmClock", "ListAlarms", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AlarmClock");
        }
        return SonosXMLParser.getAlarmsFromStringResult((String)result.get("CurrentAlarmList"));
    }

    public void updateAlarm(SonosAlarm alarm) {
        if (alarm != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            try {
                inputs.put("ID", Integer.toString(alarm.getID()));
                inputs.put("StartLocalTime", alarm.getStartTime());
                inputs.put("Duration", alarm.getDuration());
                inputs.put("Recurrence", alarm.getRecurrence());
                inputs.put("RoomUUID", alarm.getRoomUUID());
                inputs.put("ProgramURI", alarm.getProgramURI());
                inputs.put("ProgramMetaData", alarm.getProgramMetaData());
                inputs.put("PlayMode", alarm.getPlayMode());
                inputs.put("Volume", Integer.toString(alarm.getVolume()));
                if (alarm.getIncludeLinkedZones()) {
                    inputs.put("IncludeLinkedZones", "1");
                } else {
                    inputs.put("IncludeLinkedZones", "0");
                }
                if (alarm.getEnabled()) {
                    inputs.put("Enabled", "1");
                } else {
                    inputs.put("Enabled", "0");
                }
            }
            catch (NumberFormatException ex) {
                this.logger.error("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AlarmClock", "UpdateAlarm", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AlarmClock");
            }
        }
    }

    public void setAlarm(Command command) {
        if (command instanceof OnOffType || command instanceof OpenClosedType || command instanceof UpDownType) {
            if (command.equals(OnOffType.ON) || command.equals(UpDownType.UP) || command.equals(OpenClosedType.OPEN)) {
                this.setAlarm(true);
            } else if (command.equals(OnOffType.OFF) || command.equals(UpDownType.DOWN) || command.equals(OpenClosedType.CLOSED)) {
                this.setAlarm(false);
            }
        }
    }

    public void setAlarm(boolean alarmSwitch) {
        List<SonosAlarm> sonosAlarms = this.getCurrentAlarmList();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        String currentLocalTime = this.getTime();
        Date currentDateTime = null;
        try {
            currentDateTime = fmt.parse(currentLocalTime);
        }
        catch (ParseException e) {
            this.logger.error("An exception occurred while formatting a date");
            e.printStackTrace();
        }
        if (currentDateTime != null) {
            Calendar currentDateTimeCalendar = Calendar.getInstance();
            currentDateTimeCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            currentDateTimeCalendar.setTime(currentDateTime);
            currentDateTimeCalendar.add(6, 10);
            long shortestDuration = currentDateTimeCalendar.getTimeInMillis() - currentDateTime.getTime();
            SonosAlarm firstAlarm = null;
            for (SonosAlarm anAlarm : sonosAlarms) {
                SimpleDateFormat durationFormat = new SimpleDateFormat("HH:mm:ss");
                durationFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date durationDate = null;
                try {
                    durationDate = durationFormat.parse(anAlarm.getDuration());
                }
                catch (ParseException e) {
                    this.logger.error("An exception occurred while parsing a date : '{}'", (Object)e.getMessage());
                }
                long duration = durationDate.getTime();
                if (duration >= shortestDuration || !anAlarm.getRoomUUID().equals(this.getUDN())) continue;
                shortestDuration = duration;
                firstAlarm = anAlarm;
            }
            if (firstAlarm != null) {
                if (alarmSwitch) {
                    firstAlarm.setEnabled(true);
                } else {
                    firstAlarm.setEnabled(false);
                }
                this.updateAlarm(firstAlarm);
            }
        }
    }

    public String getTime() {
        this.updateTime();
        return this.stateMap.get("CurrentLocalTime");
    }

    public Boolean isAlarmRunning() {
        return this.stateMap.get("AlarmRunning").equals("1");
    }

    public void snoozeAlarm(Command command) {
        if (this.isAlarmRunning().booleanValue() && command instanceof DecimalType) {
            int minutes = ((DecimalType)command).intValue();
            HashMap<String, String> inputs = new HashMap<String, String>();
            Calendar snoozePeriod = Calendar.getInstance();
            snoozePeriod.setTimeZone(TimeZone.getTimeZone("GMT"));
            snoozePeriod.setTimeInMillis(0L);
            snoozePeriod.add(12, minutes);
            SimpleDateFormat pFormatter = new SimpleDateFormat("HH:mm:ss");
            pFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                inputs.put("Duration", pFormatter.format(snoozePeriod.getTime()));
            }
            catch (NumberFormatException ex) {
                this.logger.error("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "SnoozeAlarm", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        } else {
            this.logger.warn("There is no alarm running on {} ", (Object)this);
        }
    }

    public Boolean isLineInConnected() {
        return this.stateMap.get("LineInConnected").equals("1");
    }

    public void becomeStandAlonePlayer() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "BecomeCoordinatorOfStandaloneGroup", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void addMember(Command command) {
        if (command != null && command instanceof StringType) {
            SonosEntry entry = new SonosEntry("", "", "", "", "", "", "", "x-rincon:" + this.getUDN());
            this.getHandlerByName(command.toString()).setCurrentURI(entry);
        }
    }

    public boolean publicAddress() {
        if (this.isLineInConnected().booleanValue()) {
            this.becomeStandAlonePlayer();
            ArrayList<SonosZoneGroup> currentSonosZoneGroups = new ArrayList<SonosZoneGroup>();
            for (SonosZoneGroup grp : SonosXMLParser.getZoneGroupFromXML(this.stateMap.get("ZoneGroupState"))) {
                currentSonosZoneGroups.add((SonosZoneGroup)grp.clone());
            }
            for (SonosZoneGroup group : currentSonosZoneGroups) {
                for (String player : group.getMembers()) {
                    ZonePlayerHandler somePlayer = this.getHandlerByName(player);
                    if (somePlayer == this) continue;
                    somePlayer.becomeStandAlonePlayer();
                    somePlayer.stop();
                    this.addMember((Command)StringType.valueOf((String)somePlayer.getUDN()));
                }
            }
            ZonePlayerHandler coordinator = this.getCoordinatorHandler();
            SonosEntry entry = new SonosEntry("", "", "", "", "", "", "", "x-rincon-stream:" + this.getUDN());
            coordinator.setCurrentURI(entry);
            coordinator.play();
            return true;
        }
        this.logger.warn("Line-in of {} is not connected", (Object)this);
        return false;
    }

    public void playURI(Command command) {
        if (command != null && command instanceof StringType) {
            String url = command.toString();
            ZonePlayerHandler coordinator = this.getCoordinatorHandler();
            coordinator.stop();
            coordinator.removeAllTracksFromQueue();
            if (!url.startsWith("x-") && !url.startsWith("http")) {
                url = "x-file-cifs:" + url;
            }
            coordinator.addURIToQueue(url, "", 0, true);
            coordinator.setCurrentURI("x-rincon-queue:" + this.getUDN() + "#0", "");
            coordinator.setMute((Command)OnOffType.OFF);
            coordinator.play();
        }
    }

    private void scheduleNotificationSound(final Command command) {
        this.scheduler.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ZonePlayerHandler.this.notificationLock;
                synchronized (object) {
                    ZonePlayerHandler.this.playNotificationSoundURI(command);
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playNotificationSoundURI(Command notificationURL) {
        if (notificationURL != null && notificationURL instanceof StringType) {
            ZonePlayerHandler coordinator = this.getCoordinatorHandler();
            String currentURI = coordinator.getCurrentURI();
            if (this.isPlayingStream(currentURI)) {
                this.handleRadioStream(currentURI, notificationURL, coordinator);
            } else if (this.isPlayingQueue(currentURI)) {
                this.handleSharedQueue(notificationURL, coordinator);
            } else if (this.isPlaylistEmpty(coordinator)) {
                this.handleEmptyQueue(notificationURL, coordinator);
            }
        }
        Object object = this.notificationLock;
        synchronized (object) {
            this.notificationLock.notify();
        }
    }

    private boolean isPlaylistEmpty(ZonePlayerHandler coordinator) {
        return coordinator.getQueue().isEmpty();
    }

    private boolean isPlayingQueue(String currentURI) {
        return currentURI.contains("x-rincon-queue:");
    }

    private boolean isPlayingStream(String currentURI) {
        return currentURI.contains("x-sonosapi-stream:");
    }

    private void handleRadioStream(String currentStreamURI, Command notificationURL, ZonePlayerHandler coordinator) {
        String nextAction = coordinator.getTransportState();
        SonosMetaData track = coordinator.getTrackMetadata();
        SonosMetaData currentURI = coordinator.getCurrentURIMetadata();
        if (track != null && currentURI != null) {
            this.handleNotificationSound(notificationURL, coordinator);
            coordinator.setCurrentURI(new SonosEntry("", currentURI.getTitle(), "", "", track.getAlbumArtUri(), "", currentURI.getUpnpClass(), currentStreamURI));
            this.restoreLastTransportState(coordinator, nextAction);
        }
    }

    private void handleSharedQueue(Command notificationURL, ZonePlayerHandler coordinator) {
        String nextAction = coordinator.getTransportState();
        String trackPosition = coordinator.getPosition();
        long currentTrackNumber = coordinator.getCurrenTrackNr();
        this.handleNotificationSound(notificationURL, coordinator);
        coordinator.setPositionTrack(currentTrackNumber);
        coordinator.setPosition(trackPosition);
        this.restoreLastTransportState(coordinator, nextAction);
    }

    private void handleNotificationSound(Command notificationURL, ZonePlayerHandler coordinator) {
        String originalVolume = coordinator.getVolume();
        coordinator.stop();
        this.applyNotificationSoundVolume();
        int notificationPosition = coordinator.getQueue().size() + 1;
        coordinator.setCurrentURI("x-rincon-queue:" + this.getUDN() + "#0", "");
        coordinator.addURIToQueue(notificationURL.toString(), "", notificationPosition, false);
        coordinator.setPositionTrack(notificationPosition);
        coordinator.play();
        this.waitForFinishedNotification();
        this.setVolumeForGroup((Command)DecimalType.valueOf((String)originalVolume));
        coordinator.removeRangeOfTracksFromQueue((Command)new StringType(String.valueOf(Integer.toString(notificationPosition)) + ",1"));
    }

    private void restoreLastTransportState(ZonePlayerHandler coordinator, String nextAction) {
        switch (nextAction) {
            case "PLAYING": {
                coordinator.play();
                this.waitForTransportState("PLAYING");
                break;
            }
            case "PAUSED_PLAYBACK": {
                coordinator.pause();
            }
        }
    }

    private void handleEmptyQueue(Command notificationURL, ZonePlayerHandler coordinator) {
        String originalVolume = coordinator.getVolume();
        coordinator.applyNotificationSoundVolume();
        coordinator.playURI(notificationURL);
        this.waitForFinishedNotification();
        coordinator.removeAllTracksFromQueue();
        coordinator.setVolume((Command)DecimalType.valueOf((String)originalVolume));
    }

    private void applyNotificationSoundVolume() {
        if (this.notificationSoundVolume != null) {
            this.setVolumeForGroup((Command)DecimalType.valueOf((String)this.notificationSoundVolume));
        }
    }

    private void waitForFinishedNotification() {
        this.waitForTransportState("PLAYING");
        String notificationTitle = this.stateMap.get("CurrentTitle");
        long playstart = System.currentTimeMillis();
        while (System.currentTimeMillis() - playstart < 20000L) {
            try {
                Thread.sleep(50L);
                if (this.stateMap.get("CurrentTitle").equals(notificationTitle) && this.stateMap.get("TransportState").equals("PLAYING")) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
                this.logger.error("InterruptedException during playing a notification sound");
            }
        }
    }

    private void waitForTransportState(String state) {
        long start = System.currentTimeMillis();
        while (!this.stateMap.get("TransportState").equals(state)) {
            try {
                Thread.sleep(50L);
                if (System.currentTimeMillis() - start <= 20000L) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
                this.logger.error("InterruptedException during playing a notification sound");
            }
        }
    }

    public void removeRangeOfTracksFromQueue(Command command) {
        if (command != null && command instanceof StringType) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            String[] rangeInputSplit = command.toString().split(",");
            String startIndex = rangeInputSplit[0] != null ? rangeInputSplit[0] : "1";
            String numberOfTracks = rangeInputSplit[1] != null ? rangeInputSplit[1] : "1";
            inputs.put("InstanceID", "0");
            inputs.put("StartingIndex", startIndex);
            inputs.put("NumberOfTracks", numberOfTracks);
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "RemoveTrackRangeFromQueue", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void playQueue(Command command) {
        ZonePlayerHandler coordinator = this.getCoordinatorHandler();
        coordinator.setCurrentURI("x-rincon-queue:" + this.getUDN() + "#0", "");
        coordinator.setMute((Command)OnOffType.OFF);
        coordinator.play();
    }

    public void setLed(Command command) {
        if (command != null && (command instanceof OnOffType || command instanceof OpenClosedType || command instanceof UpDownType)) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            if (command.equals(OnOffType.ON) || command.equals(UpDownType.UP) || command.equals(OpenClosedType.OPEN)) {
                inputs.put("DesiredLEDState", "On");
            } else if (command.equals(OnOffType.OFF) || command.equals(UpDownType.DOWN) || command.equals(OpenClosedType.CLOSED)) {
                inputs.put("DesiredLEDState", "Off");
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "SetLEDState", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "DeviceProperties");
            }
        }
    }

    public void removeMember(Command command) {
        if (command != null && command instanceof StringType) {
            ZonePlayerHandler oldmemberHandler = this.getHandlerByName(command.toString());
            oldmemberHandler.becomeStandAlonePlayer();
            SonosEntry entry = new SonosEntry("", "", "", "", "", "", "", "x-rincon-queue:" + oldmemberHandler.getUDN() + "#0");
            oldmemberHandler.setCurrentURI(entry);
        }
    }

    public void previous() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Previous", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void next() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Next", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void playRadio(Command command) {
        List<SonosEntry> stations = this.getFavoriteRadios();
        SonosEntry theEntry = null;
        if (command instanceof StringType) {
            String station = command.toString();
            for (SonosEntry someStation : stations) {
                if (!someStation.getTitle().equals(station)) continue;
                theEntry = someStation;
                break;
            }
            if (theEntry != null) {
                ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                coordinator.setCurrentURI(theEntry);
                coordinator.play();
            }
        }
    }

    public void playFavorite(Command command) {
        if (command instanceof StringType) {
            String favorite = command.toString();
            List<SonosEntry> favorites = this.getFavorites();
            SonosEntry theEntry = null;
            for (SonosEntry entry : favorites) {
                if (!entry.getTitle().equals(favorite)) continue;
                theEntry = entry;
                break;
            }
            if (theEntry != null) {
                ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                if (theEntry.getResourceMetaData() != null && theEntry.getResourceMetaData().getUpnpClass().equals("object.container.playlistContainer")) {
                    String firstTrackNumberEnqueued;
                    coordinator.removeAllTracksFromQueue();
                    coordinator.addURIToQueue(theEntry);
                    coordinator.setCurrentURI("x-rincon-queue:" + coordinator.getUDN() + "#0", "");
                    if (this.stateMap != null && (firstTrackNumberEnqueued = this.stateMap.get("FirstTrackNumberEnqueued")) != null) {
                        coordinator.seek("TRACK_NR", firstTrackNumberEnqueued);
                    }
                } else {
                    coordinator.setCurrentURI(theEntry);
                }
                coordinator.play();
            }
        }
    }

    public void playTrack(Command command) {
        if (command != null && command instanceof DecimalType) {
            ZonePlayerHandler coordinator = this.getCoordinatorHandler();
            String trackNumber = command.toString();
            this.setPositionTrack(trackNumber);
            coordinator.setMute((Command)OnOffType.OFF);
            coordinator.play();
        }
    }

    public void playPlayList(Command command) {
        List<SonosEntry> playlists = this.getPlayLists();
        SonosEntry theEntry = null;
        if (command != null && command instanceof StringType) {
            String playlist = command.toString();
            for (SonosEntry somePlaylist : playlists) {
                if (!somePlaylist.getTitle().equals(playlist)) continue;
                theEntry = somePlaylist;
                break;
            }
            if (theEntry != null) {
                String firstTrackNumberEnqueued;
                ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                coordinator.addURIToQueue(theEntry);
                if (this.stateMap != null && (firstTrackNumberEnqueued = this.stateMap.get("FirstTrackNumberEnqueued")) != null) {
                    coordinator.seek("TRACK_NR", firstTrackNumberEnqueued);
                }
                coordinator.play();
            }
        }
    }

    public void addURIToQueue(SonosEntry newEntry) {
        this.addURIToQueue(newEntry.getRes(), SonosXMLParser.compileMetadataString(newEntry), 1, true);
    }

    public String getZoneName() {
        return this.stateMap.get("ZoneName");
    }

    public String getZoneGroupID() {
        return this.stateMap.get("LocalGroupUUID");
    }

    public String getRunningAlarmProperties() {
        this.updateRunningAlarmProperties();
        return this.stateMap.get("RunningAlarmProperties");
    }

    public String getMute() {
        return this.stateMap.get("MuteMaster");
    }

    public boolean getLed() {
        return this.stateMap.get("CurrentLEDState").equals("On");
    }

    public String getCurrentZoneName() {
        this.updateCurrentZoneName();
        return this.stateMap.get("CurrentZoneName");
    }

    public String getCurrentURIFormatted() {
        this.updateCurrentURIFormatted(this.getCurrentURI());
        return this.stateMap.get("CurrentURIFormatted");
    }

    public void onStatusChanged(boolean status) {
    }

    public Collection<ThingUID> removeOlderResults(DiscoveryService source, long timestamp, Collection<ThingTypeUID> thingTypeUIDs) {
        return null;
    }

    private String getModelNameFromDescriptor() {
        URL descriptor = this.service.getDescriptorURL((UpnpIOParticipant)this);
        if (descriptor != null) {
            String sonosModelDescription = SonosXMLParser.parseModelDescription(this.service.getDescriptorURL((UpnpIOParticipant)this));
            return SonosXMLParser.extractModelName(sonosModelDescription);
        }
        return null;
    }

    private boolean migrateThingType() {
        String modelName;
        if (this.getThing().getThingTypeUID().equals((Object)SonosBindingConstants.ZONEPLAYER_THING_TYPE_UID) && this.isSupportedModel(modelName = this.getModelNameFromDescriptor())) {
            this.updateSonosThingType(modelName);
            return true;
        }
        return false;
    }

    private boolean isSupportedModel(String modelName) {
        for (ThingTypeUID thingTypeUID : SonosBindingConstants.SUPPORTED_KNOWN_THING_TYPES_UIDS) {
            if (!thingTypeUID.getId().equalsIgnoreCase(modelName)) continue;
            return true;
        }
        return false;
    }

    private void updateSonosThingType(String newThingTypeID) {
        this.changeThingType(new ThingTypeUID("sonos", newThingTypeID), this.getConfig());
    }

    public void setSleepTimer(Command command) {
        if (command != null && command instanceof DecimalType) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("InstanceID", "0");
            inputs.put("NewSleepTimerDuration", this.sleepSecondsToTimeStr(Integer.parseInt(command.toString())));
            this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "ConfigureSleepTimer", inputs);
        }
    }

    protected void updateSleepTimerDuration() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "GetRemainingSleepTimerDuration", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "DeviceProperties");
        }
    }

    private String sleepSecondsToTimeStr(long sleepSeconds) {
        if (sleepSeconds == 0L) {
            return "";
        }
        if (sleepSeconds < 68400L) {
            long hours = TimeUnit.SECONDS.toHours(sleepSeconds);
            long minutes = TimeUnit.SECONDS.toMinutes(sleepSeconds -= TimeUnit.HOURS.toSeconds(hours));
            long seconds = TimeUnit.SECONDS.toSeconds(sleepSeconds -= TimeUnit.MINUTES.toSeconds(minutes));
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        this.logger.error("Sonos SleepTimer: Invalid sleep time set. sleep time must be >=0 and < 68400s (24h)");
        return "ERR";
    }

    private long sleepStrTimeToSeconds(String sleepTime) {
        String[] units = sleepTime.split(":");
        int hours = Integer.parseInt(units[0]);
        int minutes = Integer.parseInt(units[1]);
        int seconds = Integer.parseInt(units[2]);
        return 3600 * hours + 60 * minutes + seconds;
    }
}

