/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonos.internal;

import java.util.Dictionary;
import org.eclipse.smarthome.binding.sonos.SonosBindingConstants;
import org.eclipse.smarthome.binding.sonos.handler.ZonePlayerHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonosHandlerFactory
extends BaseThingHandlerFactory {
    private Logger logger = LoggerFactory.getLogger(SonosHandlerFactory.class);
    private UpnpIOService upnpIOService;
    private DiscoveryServiceRegistry discoveryServiceRegistry;
    private String opmlUrl = null;

    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext);
        Dictionary properties = componentContext.getProperties();
        this.opmlUrl = (String)properties.get("opmlUrl");
    }

    public Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID) {
        if (SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID)) {
            ThingUID sonosDeviceUID = this.getPlayerUID(thingTypeUID, thingUID, configuration);
            this.logger.debug("Creating a sonos thing with ID '{}'", (Object)sonosDeviceUID);
            return super.createThing(thingTypeUID, configuration, sonosDeviceUID, null);
        }
        throw new IllegalArgumentException("The thing type " + thingTypeUID + " is not supported by the sonos binding.");
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID)) {
            this.logger.debug("Creating a ZonePlayerHandler for thing '{}' with UDN '{}'", (Object)thing.getUID(), thing.getConfiguration().get("udn"));
            return new ZonePlayerHandler(thing, this.upnpIOService, this.discoveryServiceRegistry, this.opmlUrl);
        }
        return null;
    }

    private ThingUID getPlayerUID(ThingTypeUID thingTypeUID, ThingUID thingUID, Configuration configuration) {
        String udn = (String)configuration.get("udn");
        if (thingUID == null) {
            thingUID = new ThingUID(thingTypeUID, udn);
        }
        return thingUID;
    }

    protected void setUpnpIOService(UpnpIOService upnpIOService) {
        this.upnpIOService = upnpIOService;
    }

    protected void unsetUpnpIOService(UpnpIOService upnpIOService) {
        this.upnpIOService = null;
    }

    protected void setDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = discoveryServiceRegistry;
    }

    protected void unsetDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = null;
    }
}

