/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.handler;

import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.wemo.WemoBindingConstants;
import org.eclipse.smarthome.binding.wemo.handler.WemoBridgeHandler;
import org.eclipse.smarthome.binding.wemo.internal.http.WemoHttpCall;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOParticipant;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WemoLightHandler
extends BaseThingHandler
implements UpnpIOParticipant {
    private final Logger logger = LoggerFactory.getLogger(WemoLightHandler.class);
    private UpnpIOService service;
    private WemoBridgeHandler wemoBridgeHandler;
    private String wemoLightID;
    private int currentBrightness;
    private static final int DIM_STEPSIZE = 5;
    protected static final int SUBSCRIPTION_DURATION = 600;
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(WemoBindingConstants.THING_TYPE_MZ100);
    private int DEFAULT_REFRESH_INTERVAL = 60;
    private ScheduledFuture<?> refreshJob;
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                WemoLightHandler.this.getDeviceState();
            }
            catch (Exception e) {
                WemoLightHandler.this.logger.debug("Exception during poll : {}", (Throwable)e);
            }
        }
    };

    public WemoLightHandler(Thing thing, UpnpIOService upnpIOService) {
        super(thing);
        if (upnpIOService != null) {
            this.logger.debug("UPnPIOService '{}'", (Object)upnpIOService);
            this.service = upnpIOService;
        } else {
            this.logger.debug("upnpIOService not set.");
        }
    }

    public void initialize() {
        this.logger.debug("Initializing WemoLightHandler");
        String configLightId = (String)this.getConfig().get("deviceID");
        if ("deviceID" != null) {
            this.wemoLightID = configLightId;
            this.logger.debug("Initializing WemoLightHandler for LightID '{}'", (Object)this.wemoLightID);
            WemoBridgeHandler handler = this.getWemoBridgeHandler();
            if (handler != null) {
                this.updateStatus(ThingStatus.ONLINE);
            } else {
                this.updateStatus(ThingStatus.OFFLINE);
                this.logger.debug("No WemoBridgeHandler found for LightID '{}'", (Object)this.wemoLightID);
            }
        }
    }

    public void bridgeHandlerInitialized(ThingHandler thingHandler, Bridge bridge) {
        if (thingHandler instanceof WemoBridgeHandler) {
            this.wemoBridgeHandler = (WemoBridgeHandler)thingHandler;
            this.updateStatus(ThingStatus.ONLINE);
            this.logger.debug("bridgeHandlerInitialized for WeMo LED {}", (Object)this.wemoLightID);
            if (SUPPORTED_THING_TYPES.contains(this.getThing().getThingTypeUID())) {
                this.logger.debug("Initialize Thing {}", (Object)this.getThing().getThingTypeUID());
                this.onSubscription();
                this.onUpdate();
            }
        }
    }

    public void bridgeHandlerDisposed(ThingHandler thingHandler, Bridge bridge) {
        this.wemoBridgeHandler = null;
        if (this.refreshJob != null && !this.refreshJob.isCancelled()) {
            this.refreshJob.cancel(true);
            this.refreshJob = null;
        }
    }

    public void bridgeStatusChanged(ThingStatusInfo bridgeStatusInfo) {
        if (bridgeStatusInfo.equals((Object)ThingStatus.ONLINE)) {
            this.updateStatus(ThingStatus.ONLINE);
            this.onSubscription();
            this.onUpdate();
        } else {
            this.updateStatus(ThingStatus.OFFLINE);
            if (this.refreshJob != null && !this.refreshJob.isCancelled()) {
                this.refreshJob.cancel(true);
                this.refreshJob = null;
            }
        }
    }

    public void dispose() {
        this.logger.debug("WeMoLightHandler disposed.");
        this.removeSubscription();
        if (this.refreshJob != null && !this.refreshJob.isCancelled()) {
            this.refreshJob.cancel(true);
            this.refreshJob = null;
        }
    }

    private synchronized WemoBridgeHandler getWemoBridgeHandler() {
        if (this.wemoBridgeHandler == null) {
            Bridge bridge = this.getBridge();
            if (bridge == null) {
                this.logger.error("Required bridge not defined for device {}.", (Object)this.wemoLightID);
                return null;
            }
            ThingHandler handler = bridge.getHandler();
            if (handler instanceof WemoBridgeHandler) {
                this.wemoBridgeHandler = (WemoBridgeHandler)handler;
            } else {
                this.logger.debug("No available bridge handler found for {} bridge {} .", (Object)this.wemoLightID, (Object)bridge.getUID());
                return null;
            }
        }
        return this.wemoBridgeHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleCommand(ChannelUID channelUID, Command command) {
        Configuration configuration = this.getConfig();
        configuration.get("deviceID");
        WemoBridgeHandler wemoBridge = this.getWemoBridgeHandler();
        if (wemoBridge == null) {
            this.logger.debug("wemoBridgeHandler not found, cannot handle command");
            return;
        }
        String devUDN = "uuid:" + wemoBridge.getThing().getConfiguration().get("udn").toString();
        this.logger.trace("WeMo Bridge to send command to : {}", (Object)devUDN);
        String value = null;
        String capability = null;
        switch (channelUID.getId()) {
            case "brightness": {
                capability = "10008";
                if (command instanceof PercentType) {
                    int newBrightness = ((PercentType)command).intValue();
                    this.logger.trace("wemoLight received Value {}", (Object)newBrightness);
                    int value1 = Math.round(newBrightness * 255 / 100);
                    value = String.valueOf(value1) + ":0";
                    this.currentBrightness = newBrightness;
                    break;
                }
                if (command instanceof OnOffType) {
                    switch (command.toString()) {
                        case "ON": {
                            value = "255:0";
                            break;
                        }
                        case "OFF": {
                            value = "0:0";
                            break;
                        }
                    }
                    break;
                }
                if (!(command instanceof IncreaseDecreaseType)) break;
                switch (command.toString()) {
                    case "INCREASE": {
                        this.currentBrightness += 5;
                        int newBrightness = Math.round(this.currentBrightness * 255 / 100);
                        if (newBrightness > 255) {
                            newBrightness = 255;
                        }
                        value = String.valueOf(newBrightness) + ":0";
                        break;
                    }
                    case "DECREASE": {
                        this.currentBrightness -= 5;
                        int newBrightness = Math.round(this.currentBrightness * 255 / 100);
                        if (newBrightness < 0) {
                            newBrightness = 0;
                        }
                        value = String.valueOf(newBrightness) + ":0";
                        break;
                    }
                }
                break;
            }
            case "state": {
                capability = "10006";
                switch (command.toString()) {
                    case "ON": {
                        value = "1";
                        break;
                    }
                    case "OFF": {
                        value = "0";
                    }
                }
                break;
            }
        }
        try {
            String soapHeader = "\"urn:Belkin:service:bridge:1#SetDeviceStatus\"";
            String content = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:SetDeviceStatus xmlns:u=\"urn:Belkin:service:bridge:1\"><DeviceStatusList>&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;&lt;DeviceStatus&gt;&lt;DeviceID&gt;" + this.wemoLightID + "&lt;/DeviceID&gt;&lt;IsGroupAction&gt;NO&lt;/IsGroupAction&gt;&lt;CapabilityID&gt;" + capability + "&lt;/CapabilityID&gt;&lt;CapabilityValue&gt;" + value + "&lt;/CapabilityValue&gt;&lt;/DeviceStatus&gt;" + "</DeviceStatusList>" + "</u:SetDeviceStatus>" + "</s:Body>" + "</s:Envelope>";
            String wemoURL = this.getWemoURL();
            if (wemoURL == null) return;
            String wemoCallResponse = WemoHttpCall.executeCall(wemoURL, soapHeader, content);
            if (wemoCallResponse == null) return;
            if (capability == null) return;
            if (!capability.equals("10008")) return;
            if (value == null) return;
            OnOffType binaryState = null;
            binaryState = value.equals("0") ? OnOffType.OFF : OnOffType.ON;
            if (binaryState == null) return;
            this.updateState("state", (State)binaryState);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not send command to WeMo Bridge", e);
        }
    }

    public String getUDN() {
        WemoBridgeHandler wemoBridge = this.getWemoBridgeHandler();
        if (wemoBridge == null) {
            this.logger.debug("wemoBridgeHandler not found");
            return null;
        }
        return (String)wemoBridge.getThing().getConfiguration().get("udn");
    }

    public void getDeviceState() {
        this.logger.debug("Request actual state for LightID '{}'", (Object)this.wemoLightID);
        try {
            String wemoCallResponse;
            String soapHeader = "\"urn:Belkin:service:bridge:1#GetDeviceStatus\"";
            String content = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:GetDeviceStatus xmlns:u=\"urn:Belkin:service:bridge:1\"><DeviceIDs>" + this.wemoLightID + "</DeviceIDs>" + "</u:GetDeviceStatus>" + "</s:Body>" + "</s:Envelope>";
            String wemoURL = this.getWemoURL();
            if (wemoURL != null && (wemoCallResponse = WemoHttpCall.executeCall(wemoURL, soapHeader, content)) != null) {
                String[] splitBrightness;
                wemoCallResponse = StringEscapeUtils.unescapeXml((String)wemoCallResponse);
                String response = StringUtils.substringBetween((String)wemoCallResponse, (String)"<CapabilityValue>", (String)"</CapabilityValue>");
                this.logger.trace("wemoNewLightState = {}", (Object)response);
                String[] splitResponse = response.split(",");
                if (splitResponse[0] != null) {
                    OnOffType binaryState = null;
                    OnOffType onOffType = binaryState = splitResponse[0].equals("0") ? OnOffType.OFF : OnOffType.ON;
                    if (binaryState != null) {
                        this.updateState("state", (State)binaryState);
                    }
                }
                if (splitResponse[1] != null && (splitBrightness = splitResponse[1].split(":"))[0] != null) {
                    int newBrightnessValue = Integer.valueOf(splitBrightness[0]);
                    int newBrightness = Math.round(newBrightnessValue * 100 / 255);
                    this.logger.trace("newBrightness = {}", (Object)newBrightness);
                    PercentType newBrightnessState = new PercentType(newBrightness);
                    this.updateState("brightness", (State)newBrightnessState);
                    this.currentBrightness = newBrightness;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve new Wemo light state", e);
        }
    }

    public void onValueReceived(String variable, String value, String service) {
        this.logger.trace("Received pair '{}':'{}' (service '{}') for thing '{}'", new Object[]{variable, value, service, this.getThing().getUID()});
        String capabilityId = StringUtils.substringBetween((String)value, (String)"<CapabilityId>", (String)"</CapabilityId>");
        String newValue = StringUtils.substringBetween((String)value, (String)"<Value>", (String)"</Value>");
        switch (capabilityId) {
            case "10006": {
                OnOffType binaryState = null;
                OnOffType onOffType = binaryState = newValue.equals("0") ? OnOffType.OFF : OnOffType.ON;
                if (binaryState == null) break;
                this.updateState("state", (State)binaryState);
                break;
            }
            case "10008": {
                String[] splitValue = newValue.split(":");
                if (splitValue[0] == null) break;
                int newBrightnessValue = Integer.valueOf(splitValue[0]);
                int newBrightness = Math.round(newBrightnessValue * 100 / 255);
                PercentType newBrightnessState = new PercentType(newBrightness);
                this.updateState("brightness", (State)newBrightnessState);
                this.currentBrightness = newBrightness;
            }
        }
    }

    public void onStatusChanged(boolean status) {
    }

    private synchronized void onSubscription() {
        if (this.service.isRegistered((UpnpIOParticipant)this)) {
            this.logger.debug("Setting up WeMo GENA subscription for '{}'", (Object)this);
            this.service.addSubscription((UpnpIOParticipant)this, "bridge1", 600);
        }
    }

    private synchronized void removeSubscription() {
        this.logger.debug("Removing WeMo GENA subscription for '{}'", (Object)this);
        if (this.service.isRegistered((UpnpIOParticipant)this)) {
            this.service.removeSubscription((UpnpIOParticipant)this, "bridge1");
            this.service.unregisterParticipant((UpnpIOParticipant)this);
        }
    }

    private synchronized void onUpdate() {
        if (this.service.isRegistered((UpnpIOParticipant)this) && (this.refreshJob == null || this.refreshJob.isCancelled())) {
            int refreshInterval = this.DEFAULT_REFRESH_INTERVAL;
            this.logger.trace("Start polling job for LightID '{}'", (Object)this.wemoLightID);
            this.refreshJob = this.scheduler.scheduleAtFixedRate(this.refreshRunnable, 15L, refreshInterval, TimeUnit.SECONDS);
        }
    }

    public String getWemoURL() {
        URL descriptorURL = this.service.getDescriptorURL((UpnpIOParticipant)this);
        String wemoURL = null;
        if (descriptorURL != null) {
            String deviceURL = StringUtils.substringBefore((String)descriptorURL.toString(), (String)"/setup.xml");
            wemoURL = String.valueOf(deviceURL) + "/upnp/control/bridge1";
            return wemoURL;
        }
        return null;
    }
}

