/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.osgi;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.core.thing.BundleProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncBundleProcessor
implements BundleProcessor {
    private final Logger logger = LoggerFactory.getLogger(AbstractAsyncBundleProcessor.class);
    private Thread thread;
    private final Queue<Bundle> queue = new ConcurrentLinkedQueue<Bundle>();
    private static final Set<AbstractAsyncBundleProcessor> ALL_PROCESSORS = new CopyOnWriteArraySet<AbstractAsyncBundleProcessor>();
    private Set<BundleProcessor.BundleProcessorListener> listeners = new CopyOnWriteArraySet<BundleProcessor.BundleProcessorListener>();
    private final Runnable processorRunnable = new Runnable(){

        @Override
        public void run() {
            AbstractAsyncBundleProcessor.this.logger.trace("Bundle processor thread started");
            while (!AbstractAsyncBundleProcessor.this.queue.isEmpty()) {
                Bundle bundle = null;
                bundle = (Bundle)AbstractAsyncBundleProcessor.this.queue.peek();
                if (bundle != null) {
                    try {
                        AbstractAsyncBundleProcessor.this.processBundle(bundle);
                    }
                    catch (Exception e) {
                        AbstractAsyncBundleProcessor.this.logger.error("Exception processing bundle " + bundle.getSymbolicName(), (Throwable)e);
                    }
                }
                if (bundle == null) continue;
                AbstractAsyncBundleProcessor.this.queue.remove(bundle);
                AbstractAsyncBundleProcessor.this.informListeners(bundle);
            }
            AbstractAsyncBundleProcessor.this.logger.trace("Terminating gracefully");
            ALL_PROCESSORS.remove(this);
        }
    };

    protected Collection<URL> filterPatches(Enumeration<URL> xmlDocumentPaths, Bundle bundle) {
        ArrayList<URL> hostResources = new ArrayList<URL>();
        ArrayList<URL> fragmentResources = new ArrayList<URL>();
        while (xmlDocumentPaths.hasMoreElements()) {
            URL path = xmlDocumentPaths.nextElement();
            if (bundle.getEntry(path.getPath()) != null && bundle.getEntry(path.getPath()).equals(path)) {
                hostResources.add(path);
                continue;
            }
            fragmentResources.add(path);
        }
        if (!fragmentResources.isEmpty()) {
            HashMap<String, URL> helper = new HashMap<String, URL>();
            for (URL url : hostResources) {
                helper.put(url.getPath(), url);
            }
            for (URL url : fragmentResources) {
                helper.put(url.getPath(), url);
            }
            return helper.values();
        }
        return hostResources;
    }

    protected boolean isBundleRelevant(Bundle bundle) {
        return true;
    }

    protected final boolean isResourcePresent(Bundle bundle, String path) {
        return bundle.getResource(path) != null;
    }

    protected abstract void processBundle(Bundle var1);

    public void addingBundle(Bundle bundle) {
        if (!this.isBundleRelevant(bundle)) {
            return;
        }
        this.queue.add(bundle);
        this.startThread();
    }

    private void startThread() {
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(this.processorRunnable, "Bundle processor thread");
            this.thread.start();
            ALL_PROCESSORS.add(this);
        }
    }

    public Bundle isFinishedLoading(Object object) {
        Bundle bundle = this.getBundle(object.getClass());
        if (this.queue.contains(bundle)) {
            this.logger.trace("Bundle {} is still loading", (Object)bundle.getSymbolicName());
            return bundle;
        }
        this.logger.trace("Bundle {} is not currently loading", (Object)bundle.getSymbolicName());
        return null;
    }

    private Bundle getBundle(final Class<?> classFromBundle) {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return classFromBundle.getClassLoader();
            }
        });
        if (classLoader instanceof BundleReference) {
            Bundle bundle = ((BundleReference)classLoader).getBundle();
            this.logger.trace("Bundle of {} is {}", classFromBundle, (Object)bundle.getSymbolicName());
            return bundle;
        }
        return null;
    }

    public static boolean isBundleFinishedLoading(Bundle bundle) {
        for (AbstractAsyncBundleProcessor processor : ALL_PROCESSORS) {
            if (!processor.queue.contains(bundle)) continue;
            return false;
        }
        return true;
    }

    public void removeBundle(Bundle bundle) {
        this.queue.remove(bundle);
    }

    private void informListeners(Bundle bundle) {
        for (BundleProcessor.BundleProcessorListener listener : this.listeners) {
            listener.bundleFinished((BundleProcessor)this, bundle);
        }
    }

    public void registerListener(BundleProcessor.BundleProcessorListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(BundleProcessor.BundleProcessorListener listener) {
        this.listeners.remove(listener);
    }
}

