/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ConverterAttributeMapValidator {
    private Map<String, Boolean> validationMaskTemplate;

    public ConverterAttributeMapValidator(String[][] validationMaskTemplate) {
        if (validationMaskTemplate != null) {
            this.validationMaskTemplate = new HashMap<String, Boolean>(validationMaskTemplate.length);
            String[][] stringArray = validationMaskTemplate;
            int n = validationMaskTemplate.length;
            int n2 = 0;
            while (n2 < n) {
                String[] validationProperty = stringArray[n2];
                this.validationMaskTemplate.put(validationProperty[0], Boolean.parseBoolean(validationProperty[1]));
                ++n2;
            }
        }
    }

    public ConverterAttributeMapValidator(Map<String, Boolean> validationMaskTemplate) {
        this.validationMaskTemplate = validationMaskTemplate;
    }

    public Map<String, String> readValidatedAttributes(HierarchicalStreamReader reader) throws ConversionException {
        return ConverterAttributeMapValidator.readValidatedAttributes(reader, this.validationMaskTemplate);
    }

    public static Map<String, String> readValidatedAttributes(HierarchicalStreamReader reader, Map<String, Boolean> validationMaskTemplate) throws ConversionException {
        HashMap<String, String> attributeMap = new HashMap<String, String>(reader.getAttributeCount());
        HashMap<String, Boolean> validationMask = null;
        if (validationMaskTemplate != null) {
            validationMask = new HashMap<String, Boolean>(validationMaskTemplate);
        }
        int index = 0;
        while (index < reader.getAttributeCount()) {
            String attributeName = reader.getAttributeName(index);
            if (validationMask == null || validationMask.containsKey(attributeName)) {
                attributeMap.put(attributeName, reader.getAttribute(index));
                if (validationMask != null) {
                    validationMask.remove(attributeName);
                }
            } else {
                throw new ConversionException("The attribute '" + attributeName + "' of the node '" + reader.getNodeName() + "' is not supported or exists multiple times!");
            }
            ++index;
        }
        if (validationMask != null && validationMask.size() > 0) {
            for (Map.Entry entry : validationMask.entrySet()) {
                String attributeName = (String)entry.getKey();
                boolean attributeRequired = (Boolean)entry.getValue();
                if (!attributeRequired) continue;
                throw new ConversionException("The attribute '" + attributeName + "' of the node '" + reader.getNodeName() + "' is missing!");
            }
        }
        return attributeMap;
    }
}

