/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.rule.runtime.internal.engine;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.rule.rules.Rule;
import org.eclipse.smarthome.model.rule.rules.RuleModel;
import org.eclipse.smarthome.model.rule.runtime.internal.RuleRuntimeActivator;
import org.eclipse.smarthome.model.rule.runtime.internal.engine.RuleContextHelper;
import org.eclipse.smarthome.model.script.engine.Script;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.smarthome.model.script.engine.ScriptExecutionException;
import org.eclipse.xtext.xbase.XExpression;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteRuleJob
implements Job {
    private final Logger logger = LoggerFactory.getLogger(ExecuteRuleJob.class);
    public static final String JOB_DATA_RULEMODEL = "model";
    public static final String JOB_DATA_RULENAME = "rule";
    @Inject
    private Injector injector;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String modelName = (String)context.getJobDetail().getJobDataMap().get((Object)JOB_DATA_RULEMODEL);
        String ruleName = (String)context.getJobDetail().getJobDataMap().get((Object)JOB_DATA_RULENAME);
        ModelRepository modelRepository = (ModelRepository)RuleRuntimeActivator.modelRepositoryTracker.getService();
        ScriptEngine scriptEngine = (ScriptEngine)RuleRuntimeActivator.scriptEngineTracker.getService();
        if (modelRepository != null && scriptEngine != null) {
            EObject model = modelRepository.getModel(modelName);
            if (model instanceof RuleModel) {
                RuleModel ruleModel = (RuleModel)model;
                Rule rule = this.getRule(ruleModel, ruleName);
                if (rule != null) {
                    Script script = scriptEngine.newScriptFromXExpression((XExpression)rule.getScript());
                    this.logger.debug("Executing scheduled rule '{}'", (Object)rule.getName());
                    try {
                        script.execute(RuleContextHelper.getContext(rule, this.injector));
                    }
                    catch (ScriptExecutionException e) {
                        this.logger.error("Error during the execution of rule {}", (Object)rule.getName(), (Object)e.getCause());
                    }
                } else {
                    this.logger.debug("Scheduled rule '{}' does not exist", (Object)ruleName);
                }
            } else {
                this.logger.debug("Rule file '{}' does not exist", (Object)modelName);
            }
        }
    }

    private Rule getRule(RuleModel ruleModel, String ruleName) {
        for (Rule rule : ruleModel.getRules()) {
            if (!rule.getName().equals(ruleName)) continue;
            return rule;
        }
        return null;
    }
}

