/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.runtime.internal.engine;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.smarthome.model.script.engine.Script;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.smarthome.model.script.engine.ScriptExecutionException;
import org.eclipse.smarthome.model.script.engine.ScriptParsingException;
import org.eclipse.smarthome.model.script.runtime.ScriptRuntime;
import org.eclipse.smarthome.model.script.runtime.internal.ScriptRuntimeStandaloneSetup;
import org.eclipse.smarthome.model.script.runtime.internal.engine.ScriptImpl;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XExpression;

public class ScriptEngineImpl
implements ScriptEngine {
    protected XtextResourceSet resourceSet;
    private ScriptRuntime scriptRuntime;

    public void activate() {
    }

    private XtextResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = (XtextResourceSet)ScriptRuntimeStandaloneSetup.getInjector().getInstance(XtextResourceSet.class);
            this.resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.FALSE);
        }
        return this.resourceSet;
    }

    public void deactivate() {
        this.resourceSet = null;
    }

    protected void setScriptRuntime(ScriptRuntime scriptRuntime) {
        this.scriptRuntime = scriptRuntime;
    }

    protected void unsetScriptRuntime(ScriptRuntime scriptRuntime) {
        this.scriptRuntime = null;
    }

    public Script newScriptFromString(String scriptAsString) throws ScriptParsingException {
        return this.newScriptFromXExpression(this.parseScriptIntoXTextEObject(scriptAsString));
    }

    public Script newScriptFromXExpression(XExpression expression) {
        ScriptImpl script = (ScriptImpl)ScriptRuntimeStandaloneSetup.getInjector().getInstance(ScriptImpl.class);
        script.setXExpression(expression);
        return script;
    }

    public Object executeScript(String scriptAsString) throws ScriptParsingException, ScriptExecutionException {
        return this.newScriptFromString(scriptAsString).execute();
    }

    private XExpression parseScriptIntoXTextEObject(String scriptAsString) throws ScriptParsingException {
        XtextResourceSet resourceSet = this.getResourceSet();
        Resource resource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet));
        try {
            resource.load((InputStream)new StringInputStream(scriptAsString), resourceSet.getLoadOptions());
        }
        catch (IOException e) {
            throw new ScriptParsingException("Unexpected IOException; from close() of a String-based ByteArrayInputStream, no real I/O; how is that possible???", scriptAsString, (Throwable)e);
        }
        EList errors = resource.getErrors();
        if (errors.size() != 0) {
            throw new ScriptParsingException("Failed to parse expression (due to managed SyntaxError/s)", scriptAsString).addDiagnosticErrors((List)errors);
        }
        EList contents = resource.getContents();
        if (!contents.isEmpty()) {
            Iterable<Issue> validationErrors = this.getValidationErrors((EObject)contents.get(0));
            if (!validationErrors.iterator().hasNext()) {
                return (XExpression)contents.get(0);
            }
            throw new ScriptParsingException("Failed to parse expression (due to managed ValidationError/s)", scriptAsString).addValidationIssues(validationErrors);
        }
        return null;
    }

    protected URI computeUnusedUri(ResourceSet resourceSet) {
        String name = "__synthetic";
        int i = 0;
        while (i < 1000) {
            URI syntheticUri = URI.createURI((String)(String.valueOf(name) + Math.random() + "." + "script"));
            if (resourceSet.getResource(syntheticUri, false) == null) {
                return syntheticUri;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    protected List<Issue> validate(EObject model) {
        IResourceValidator validator = ((XtextResource)model.eResource()).getResourceServiceProvider().getResourceValidator();
        return validator.validate(model.eResource(), CheckMode.ALL, CancelIndicator.NullImpl);
    }

    protected Iterable<Issue> getValidationErrors(EObject model) {
        List<Issue> validate = this.validate(model);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                return Severity.ERROR == input.getSeverity();
            }
        });
        return issues;
    }
}

