/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.scale.internal;

import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smarthome.core.transform.AbstractFileTransformationService;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.transform.scale.internal.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleTransformationService
extends AbstractFileTransformationService<Map<Range, String>> {
    private final Logger logger = LoggerFactory.getLogger(ScaleTransformationService.class);
    private static final Pattern LIMITS_PATTERN = Pattern.compile("(\\[|\\])(.*)\\.\\.(.*)(\\[|\\])");

    protected String internalTransform(Map<Range, String> data, String source) throws TransformationException {
        try {
            BigDecimal value = new BigDecimal(source);
            for (Range range : data.keySet()) {
                if (!range.contains(value)) continue;
                return data.get(range);
            }
            throw new TransformationException("No matching range for '" + source + "'");
        }
        catch (NumberFormatException numberFormatException) {
            throw new TransformationException("Scale can only be used with numeric inputs");
        }
    }

    protected Map<Range, String> internalLoadTransform(String filename) throws TransformationException {
        try {
            Properties properties = new Properties();
            properties.load(new FileReader(filename));
            HashMap<Range, String> data = new HashMap<Range, String>();
            for (Map.Entry<Object, Object> f : properties.entrySet()) {
                String key = (String)f.getKey();
                String value = properties.getProperty(key);
                Matcher matcher = LIMITS_PATTERN.matcher(key);
                if (matcher.matches() && matcher.groupCount() == 4) {
                    BigDecimal highValue;
                    BigDecimal lowValue;
                    boolean lowerInclusive = !matcher.group(1).equals("]");
                    boolean upperInclusive = !matcher.group(4).equals("[");
                    String lowLimit = matcher.group(2);
                    String highLimit = matcher.group(3);
                    try {
                        lowValue = lowLimit.isEmpty() ? null : new BigDecimal(lowLimit);
                        highValue = highLimit.isEmpty() ? null : new BigDecimal(highLimit);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TransformationException("Error parsing bounds: " + lowLimit + ".." + highLimit);
                    }
                    Range range = Range.range(lowValue, lowerInclusive, highValue, upperInclusive);
                    data.put(range, value);
                    continue;
                }
                this.logger.warn("Scale transform entry does not comply with syntax : '{}', '{}'", (Object)key, (Object)value);
            }
            return data;
        }
        catch (IOException ex) {
            throw new TransformationException("An error occured while opening file.", (Throwable)ex);
        }
    }
}

