/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.dto;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.dto.ConditionDTO;
import org.eclipse.smarthome.automation.dto.ModuleDTOMapper;
import org.eclipse.smarthome.config.core.Configuration;

public class ConditionDTOMapper
extends ModuleDTOMapper {
    public static ConditionDTO map(Condition condition) {
        ConditionDTO conditionDto = new ConditionDTO();
        ConditionDTOMapper.fillProperties(condition, conditionDto);
        conditionDto.inputs = condition.getInputs();
        return conditionDto;
    }

    public static Condition mapDto(ConditionDTO conditionDto) {
        Condition condition = new Condition(conditionDto.id, conditionDto.type, new Configuration(conditionDto.configuration), conditionDto.inputs);
        condition.setLabel(conditionDto.label);
        condition.setDescription(conditionDto.description);
        return condition;
    }

    public static List<ConditionDTO> map(List<Condition> conditions) {
        if (conditions == null) {
            return null;
        }
        ArrayList<ConditionDTO> dtos = new ArrayList<ConditionDTO>(conditions.size());
        for (Condition action : conditions) {
            dtos.add(ConditionDTOMapper.map(action));
        }
        return dtos;
    }

    public static List<Condition> mapDto(List<ConditionDTO> dtos) {
        if (dtos == null) {
            return null;
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>(dtos.size());
        for (ConditionDTO dto : dtos) {
            conditions.add(ConditionDTOMapper.mapDto(dto));
        }
        return conditions;
    }
}

