/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.events;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.dto.RuleDTO;
import org.eclipse.smarthome.automation.dto.RuleDTOMapper;
import org.eclipse.smarthome.automation.events.RuleAddedEvent;
import org.eclipse.smarthome.automation.events.RuleRemovedEvent;
import org.eclipse.smarthome.automation.events.RuleStatusInfoEvent;
import org.eclipse.smarthome.automation.events.RuleUpdatedEvent;
import org.eclipse.smarthome.core.events.AbstractEventFactory;
import org.eclipse.smarthome.core.events.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEventFactory
extends AbstractEventFactory {
    private final Logger logger = LoggerFactory.getLogger(RuleEventFactory.class);
    private static final String RULE_STATE_EVENT_TOPIC = "smarthome/rules/{ruleID}/state";
    private static final String RULE_ADDED_EVENT_TOPIC = "smarthome/rules/{ruleID}/added";
    private static final String RULE_REMOVED_EVENT_TOPIC = "smarthome/rules/{ruleID}/removed";
    private static final String RULE_UPDATED_EVENT_TOPIC = "smarthome/rules/{ruleID}/updated";
    private static final Set<String> SUPPORTED_TYPES = new HashSet<String>();

    static {
        SUPPORTED_TYPES.add(RuleAddedEvent.TYPE);
        SUPPORTED_TYPES.add(RuleRemovedEvent.TYPE);
        SUPPORTED_TYPES.add(RuleStatusInfoEvent.TYPE);
        SUPPORTED_TYPES.add(RuleUpdatedEvent.TYPE);
    }

    public RuleEventFactory() {
        super(SUPPORTED_TYPES);
    }

    protected Event createEventByType(String eventType, String topic, String payload, String source) throws Exception {
        this.logger.trace("creating ruleEvent of type: {}", (Object)eventType);
        if (eventType == null) {
            return null;
        }
        if (eventType.equals(RuleAddedEvent.TYPE)) {
            return this.createRuleAddedEvent(topic, payload, source);
        }
        if (eventType.equals(RuleRemovedEvent.TYPE)) {
            return this.createRuleRemovedEvent(topic, payload, source);
        }
        if (eventType.equals(RuleStatusInfoEvent.TYPE)) {
            return this.createRuleStatusInfoEvent(topic, payload, source);
        }
        if (eventType.equals(RuleUpdatedEvent.TYPE)) {
            return this.createRuleUpdatedEvent(topic, payload, source);
        }
        return null;
    }

    private Event createRuleUpdatedEvent(String topic, String payload, String source) {
        RuleDTO[] ruleDTO = (RuleDTO[])RuleEventFactory.deserializePayload((String)payload, RuleDTO[].class);
        if (ruleDTO.length != 2) {
            throw new IllegalArgumentException("Creation of RuleUpdatedEvent failed: invalid payload: " + payload);
        }
        return new RuleUpdatedEvent(topic, payload, source, ruleDTO[0], ruleDTO[1]);
    }

    private Event createRuleStatusInfoEvent(String topic, String payload, String source) {
        RuleStatusInfo statusInfo = (RuleStatusInfo)RuleEventFactory.deserializePayload((String)payload, RuleStatusInfo.class);
        return new RuleStatusInfoEvent(topic, payload, source, statusInfo, this.getRuleId(topic));
    }

    private Event createRuleRemovedEvent(String topic, String payload, String source) {
        RuleDTO ruleDTO = (RuleDTO)RuleEventFactory.deserializePayload((String)payload, RuleDTO.class);
        return new RuleRemovedEvent(topic, payload, source, ruleDTO);
    }

    private Event createRuleAddedEvent(String topic, String payload, String source) {
        RuleDTO ruleDTO = (RuleDTO)RuleEventFactory.deserializePayload((String)payload, RuleDTO.class);
        return new RuleAddedEvent(topic, payload, source, ruleDTO);
    }

    private String getRuleId(String topic) {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length != 4) {
            throw new IllegalArgumentException("Event creation failed, invalid topic: " + topic);
        }
        return topicElements[2];
    }

    public static RuleUpdatedEvent createRuleUpdatedEvent(Rule rule, Rule oldRule, String source) {
        String topic = RuleEventFactory.buildTopic(RULE_UPDATED_EVENT_TOPIC, rule);
        RuleDTO ruleDto = RuleDTOMapper.map(rule);
        RuleDTO oldRuleDto = RuleDTOMapper.map(oldRule);
        LinkedList<RuleDTO> rules = new LinkedList<RuleDTO>();
        rules.add(ruleDto);
        rules.add(oldRuleDto);
        String payload = RuleEventFactory.serializePayload(rules);
        return new RuleUpdatedEvent(topic, payload, source, ruleDto, oldRuleDto);
    }

    public static RuleStatusInfoEvent createRuleStatusInfoEvent(RuleStatusInfo statusInfo, String ruleUID, String source) {
        String topic = RuleEventFactory.buildTopic(RULE_STATE_EVENT_TOPIC, ruleUID);
        String payload = RuleEventFactory.serializePayload((Object)statusInfo);
        return new RuleStatusInfoEvent(topic, payload, source, statusInfo, ruleUID);
    }

    public static RuleRemovedEvent createRuleRemovedEvent(Rule rule, String source) {
        String topic = RuleEventFactory.buildTopic(RULE_REMOVED_EVENT_TOPIC, rule);
        RuleDTO ruleDto = RuleDTOMapper.map(rule);
        String payload = RuleEventFactory.serializePayload((Object)ruleDto);
        return new RuleRemovedEvent(topic, payload, source, ruleDto);
    }

    public static RuleAddedEvent createRuleAddedEvent(Rule rule, String source) {
        String topic = RuleEventFactory.buildTopic(RULE_ADDED_EVENT_TOPIC, rule);
        RuleDTO ruleDto = RuleDTOMapper.map(rule);
        String payload = RuleEventFactory.serializePayload((Object)ruleDto);
        return new RuleAddedEvent(topic, payload, source, ruleDto);
    }

    private static String buildTopic(String topic, String ruleUID) {
        return topic.replace("{ruleID}", ruleUID);
    }

    private static String buildTopic(String topic, Rule rule) {
        return RuleEventFactory.buildTopic(topic, rule.getUID());
    }
}

