/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.timer.handler;

import java.text.ParseException;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseTriggerModuleHandler;
import org.eclipse.smarthome.automation.handler.RuleEngineCallback;
import org.eclipse.smarthome.core.scheduler.CronExpression;
import org.eclipse.smarthome.core.scheduler.Expression;
import org.eclipse.smarthome.core.scheduler.ExpressionThreadPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericCronTriggerHandler
extends BaseTriggerModuleHandler
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(GenericCronTriggerHandler.class);
    public static final String MODULE_TYPE_ID = "timer.GenericCronTrigger";
    public static final String CALLBACK_CONTEXT_NAME = "CALLBACK";
    public static final String MODULE_CONTEXT_NAME = "MODULE";
    private static final String CFG_CRON_EXPRESSION = "cronExpression";
    private final ExpressionThreadPoolManager.ExpressionThreadPoolExecutor scheduler;
    private Expression expression;

    public GenericCronTriggerHandler(Trigger module) {
        super(module);
        String cronExpressionString = (String)module.getConfiguration().get(CFG_CRON_EXPRESSION);
        try {
            this.expression = new CronExpression(cronExpressionString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("'" + cronExpressionString + "' parameter is not in valid cron expression.", e);
        }
        this.scheduler = ExpressionThreadPoolManager.getExpressionScheduledPool((String)"ruletimer");
    }

    public synchronized void setRuleEngineCallback(RuleEngineCallback ruleCallback) {
        super.setRuleEngineCallback(ruleCallback);
        this.scheduleJob();
    }

    private void scheduleJob() {
        this.scheduler.schedule((Runnable)this, this.expression);
        this.logger.debug("Scheduled cron job '{}' for trigger '{}'.", ((Trigger)this.module).getConfiguration().get(CFG_CRON_EXPRESSION), (Object)((Trigger)this.module).getId());
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.scheduler.remove((Runnable)this)) {
            this.logger.debug("cancelled job for trigger '{}'.", (Object)((Trigger)this.module).getId());
        } else {
            this.logger.debug("Failed cancelling job for trigger '{}' - maybe it was never scheduled?", (Object)((Trigger)this.module).getId());
        }
    }

    @Override
    public void run() {
        this.ruleEngineCallback.triggered((Trigger)this.module, null);
    }
}

