/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.parser.gson.internal;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.smarthome.config.core.Configuration;

public class ConfigurationDeserializer
implements JsonDeserializer<Configuration> {
    public Configuration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Configuration configuration = new Configuration();
        JsonObject jo = (JsonObject)json;
        for (Map.Entry e : jo.entrySet()) {
            JsonPrimitive value = ((JsonElement)e.getValue()).getAsJsonPrimitive();
            if (value.isString()) {
                configuration.put((String)e.getKey(), (Object)value.getAsString());
                continue;
            }
            if (value.isNumber()) {
                configuration.put((String)e.getKey(), (Object)value.getAsBigDecimal());
                continue;
            }
            if (!value.isBoolean()) continue;
            configuration.put((String)e.getKey(), (Object)value.getAsBoolean());
        }
        return configuration;
    }
}

