/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.parser.gson.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Set;
import org.eclipse.smarthome.config.core.Configuration;

public class ConfigurationSerializer
implements JsonSerializer<Configuration> {
    public JsonElement serialize(Configuration src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = null;
        if (src != null) {
            Set kyes = src.keySet();
            result = new JsonObject();
            if (kyes.size() > 0) {
                for (String propName : kyes) {
                    Object value = src.get(propName);
                    if (value instanceof String) {
                        result.addProperty(propName, (String)value);
                        continue;
                    }
                    if (value instanceof Number) {
                        result.addProperty(propName, (Number)value);
                        continue;
                    }
                    if (!(value instanceof Boolean)) continue;
                    result.addProperty(propName, (Boolean)value);
                }
            }
        }
        return result;
    }
}

