/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.calc;

import java.math.BigDecimal;
import java.util.Calendar;
import org.eclipse.smarthome.binding.astro.internal.model.Eclipse;
import org.eclipse.smarthome.binding.astro.internal.model.Moon;
import org.eclipse.smarthome.binding.astro.internal.model.MoonDistance;
import org.eclipse.smarthome.binding.astro.internal.model.MoonPhase;
import org.eclipse.smarthome.binding.astro.internal.model.MoonPhaseName;
import org.eclipse.smarthome.binding.astro.internal.model.Position;
import org.eclipse.smarthome.binding.astro.internal.model.Range;
import org.eclipse.smarthome.binding.astro.internal.model.Zodiac;
import org.eclipse.smarthome.binding.astro.internal.model.ZodiacSign;
import org.eclipse.smarthome.binding.astro.internal.util.DateTimeUtils;

public class MoonCalc {
    private static final double NEW_MOON = 0.0;
    private static final double FULL_MOON = 0.5;
    private static final double FIRST_QUARTER = 0.25;
    private static final double LAST_QUARTER = 0.75;
    private static final double ECLIPSE_TYPE_MOON = 0.5;
    protected static final double ECLIPSE_TYPE_SUN = 0.0;
    protected static final int ECLIPSE_MODE_PARTIAL = 0;
    protected static final int ECLIPSE_MODE_TOTAL = 1;
    protected static final int ECLIPSE_MODE_RING = 2;

    public Moon getMoonInfo(Calendar calendar, double latitude, double longitude) {
        Moon moon = new Moon();
        double julianDate = DateTimeUtils.dateToJulianDate(calendar);
        double julianDateMidnight = DateTimeUtils.midnightDateToJulianDate(calendar);
        double[] riseSet = this.getRiseSet(calendar, latitude, longitude);
        Calendar rise = DateTimeUtils.timeToCalendar(calendar, riseSet[0]);
        Calendar set = DateTimeUtils.timeToCalendar(calendar, riseSet[1]);
        if (rise == null || set == null) {
            Calendar tomorrow = (Calendar)calendar.clone();
            tomorrow.add(5, 1);
            double[] riseSeTomorrow = this.getRiseSet(tomorrow, latitude, longitude);
            if (rise == null) {
                rise = DateTimeUtils.timeToCalendar(tomorrow, riseSeTomorrow[0]);
            }
            if (set == null) {
                set = DateTimeUtils.timeToCalendar(tomorrow, riseSeTomorrow[1]);
            }
        }
        moon.setRise(new Range(rise, rise));
        moon.setSet(new Range(set, set));
        MoonPhase phase = moon.getPhase();
        phase.setNew(DateTimeUtils.toCalendar(this.getNextPhase(calendar, julianDateMidnight, 0.0)));
        phase.setFirstQuarter(DateTimeUtils.toCalendar(this.getNextPhase(calendar, julianDateMidnight, 0.25)));
        phase.setFull(DateTimeUtils.toCalendar(this.getNextPhase(calendar, julianDateMidnight, 0.5)));
        phase.setThirdQuarter(DateTimeUtils.toCalendar(this.getNextPhase(calendar, julianDateMidnight, 0.75)));
        Eclipse eclipse = moon.getEclipse();
        double eclipseJd = this.getEclipse(calendar, 0.5, julianDateMidnight, 0);
        eclipse.setPartial(DateTimeUtils.toCalendar(eclipseJd));
        eclipseJd = this.getEclipse(calendar, 0.5, julianDateMidnight, 1);
        eclipse.setTotal(DateTimeUtils.toCalendar(eclipseJd));
        double decimalYear = DateTimeUtils.getDecimalYear(calendar);
        MoonDistance apogee = moon.getApogee();
        double apogeeJd = this.getApogee(julianDate, decimalYear);
        apogee.setDate(DateTimeUtils.toCalendar(apogeeJd));
        apogee.setKilometer(this.getDistance(apogeeJd));
        MoonDistance perigee = moon.getPerigee();
        double perigeeJd = this.getPerigee(julianDate, decimalYear);
        perigee.setDate(DateTimeUtils.toCalendar(perigeeJd));
        perigee.setKilometer(this.getDistance(perigeeJd));
        return moon;
    }

    public void setPositionalInfo(Calendar calendar, double latitude, double longitude, Moon moon) {
        double julianDate = DateTimeUtils.dateToJulianDate(calendar);
        this.setMoonPhase(calendar, moon);
        this.setAzimuthElevationZodiac(julianDate, latitude, longitude, moon);
        MoonDistance distance = moon.getDistance();
        distance.setDate(Calendar.getInstance());
        distance.setKilometer(this.getDistance(julianDate));
    }

    private void setMoonPhase(Calendar calendar, Moon moon) {
        boolean isWaxing;
        MoonPhase phase = moon.getPhase();
        double julianDateEndOfDay = DateTimeUtils.endOfDayDateToJulianDate(calendar);
        double parentNewMoon = this.getPreviousPhase(calendar, julianDateEndOfDay, 0.0);
        double age = Math.abs(parentNewMoon - julianDateEndOfDay);
        phase.setAge((int)age);
        phase.setIllumination(this.getIllumination(DateTimeUtils.dateToJulianDate(calendar)));
        int illumination = (int)phase.getIllumination();
        boolean bl = isWaxing = age < 14.7652944265;
        if (DateTimeUtils.isSameDay(calendar, phase.getNew())) {
            phase.setName(MoonPhaseName.NEW);
        } else if (DateTimeUtils.isSameDay(calendar, phase.getFirstQuarter())) {
            phase.setName(MoonPhaseName.FIRST_QUARTER);
        } else if (DateTimeUtils.isSameDay(calendar, phase.getThirdQuarter())) {
            phase.setName(MoonPhaseName.THIRD_QUARTER);
        } else if (DateTimeUtils.isSameDay(calendar, phase.getFull())) {
            phase.setName(MoonPhaseName.FULL);
        } else if (illumination >= 0 && illumination < 50) {
            phase.setName(isWaxing ? MoonPhaseName.WAXING_CRESCENT : MoonPhaseName.WANING_CRESCENT);
        } else if (illumination >= 50 && illumination < 100) {
            phase.setName(isWaxing ? MoonPhaseName.WAXING_GIBBOUS : MoonPhaseName.WANING_GIBBOUS);
        }
    }

    private double[] getRiseSet(Calendar calendar, double latitude, double longitude) {
        double lambda = this.prepareCoordinate(longitude, 180.0);
        if (longitude > 0.0) {
            lambda *= -1.0;
        }
        double phi = this.prepareCoordinate(latitude, 90.0);
        if (latitude < 0.0) {
            phi *= -1.0;
        }
        double moonJd = Math.floor(DateTimeUtils.midnightDateToJulianDate(calendar)) - 2400000.0;
        moonJd -= (double)(calendar.get(15) + calendar.get(16)) / 60000.0 / 1440.0;
        double sphi = this.SN(phi);
        double cphi = this.CS(phi);
        double sinho = this.SN(0.13333333333333333);
        int hour = 1;
        double utrise = -1.0;
        double utset = -1.0;
        do {
            double yplus;
            double yo;
            double yminus;
            double[] quadRet;
            if ((quadRet = this.QUAD(yminus = this.SINALT(moonJd, hour - 1, lambda, cphi, sphi) - sinho, yo = this.SINALT(moonJd, hour, lambda, cphi, sphi) - sinho, yplus = this.SINALT(moonJd, hour + 1, lambda, cphi, sphi) - sinho))[3] == 1.0) {
                if (yminus < 0.0) {
                    utrise = (double)hour + quadRet[1];
                } else {
                    utset = (double)hour + quadRet[1];
                }
            }
            if (quadRet[3] == 2.0) {
                if (quadRet[0] < 0.0) {
                    utrise = (double)hour + quadRet[2];
                    utset = (double)hour + quadRet[1];
                } else {
                    utrise = (double)hour + quadRet[1];
                    utset = (double)hour + quadRet[2];
                }
            }
            yminus = yplus;
        } while ((hour += 2) < 25 && (utrise == -1.0 || utset == -1.0));
        double rise = this.prepareTime(utrise);
        double set = this.prepareTime(utset);
        return new double[]{rise, set};
    }

    private double prepareCoordinate(double coordinate, double system) {
        double c = Math.abs(coordinate);
        if (c - Math.floor(c) >= 0.599) {
            c = Math.floor(c) + (c - Math.floor(c)) / 1.0 * 0.6;
        }
        if (c > system) {
            c = Math.floor(c) % system + (c - Math.floor(c));
        }
        return (double)Math.round(c * 100.0) / 100.0;
    }

    private double prepareTime(double riseSet) {
        double rounded;
        if (riseSet == -1.0) {
            return riseSet;
        }
        double riseMinute = (riseSet - Math.floor(riseSet)) * 60.0 / 100.0;
        if (riseMinute >= 0.595) {
            riseMinute = 0.0;
            rounded = riseSet + 1.0;
        } else {
            rounded = riseSet;
        }
        rounded = Math.floor(rounded) + riseMinute;
        BigDecimal bd = new BigDecimal(Double.toString(rounded));
        bd = bd.setScale(2, 4);
        return bd.doubleValue();
    }

    private double calcMoonPhase(double k, double mode) {
        double k_mod = Math.floor(k) + mode;
        double t = k_mod / 1236.85;
        double e = this.var_e(t);
        double m = this.var_m(k_mod, t);
        double m1 = this.var_m1(k_mod, t);
        double f = this.var_f(k_mod, t);
        double o = this.var_o(k_mod, t);
        double jd = this.var_jde(k_mod, t);
        if (mode == 0.0) {
            jd += -0.4072 * this.SN(m1) + 0.17241 * e * this.SN(m) + 0.01608 * this.SN(2.0 * m1) + 0.01039 * this.SN(2.0 * f) + 0.00739 * e * this.SN(m1 - m) - 0.00514 * e * this.SN(m1 + m) + 0.00208 * e * e * this.SN(2.0 * m) - 0.00111 * this.SN(m1 - 2.0 * f) - 5.7E-4 * this.SN(m1 + 2.0 * f);
            jd += 5.6E-4 * e * this.SN(2.0 * m1 + m) - 4.2E-4 * this.SN(3.0 * m1) + 4.2E-4 * e * this.SN(m + 2.0 * f) + 3.8E-4 * e * this.SN(m - 2.0 * f) - 2.4E-4 * e * this.SN(2.0 * m1 - m) - 1.7E-4 * this.SN(o) - 7.0E-5 * this.SN(m1 + 2.0 * m) + 4.0E-5 * this.SN(2.0 * m1 - 2.0 * f);
            jd += 4.0E-5 * this.SN(3.0 * m) + 3.0E-5 * this.SN(m1 + m - 2.0 * f) + 3.0E-5 * this.SN(2.0 * m1 + 2.0 * f) - 3.0E-5 * this.SN(m1 + m + 2.0 * f) + 3.0E-5 * this.SN(m1 - m + 2.0 * f) - 2.0E-5 * this.SN(m1 - m - 2.0 * f) - 2.0E-5 * this.SN(3.0 * m1 + m);
            jd += 2.0E-5 * this.SN(4.0 * m1);
        } else if (mode == 0.5) {
            jd += -0.40614 * this.SN(m1) + 0.17302 * e * this.SN(m) + 0.01614 * this.SN(2.0 * m1) + 0.01043 * this.SN(2.0 * f) + 0.00734 * e * this.SN(m1 - m) - 0.00515 * e * this.SN(m1 + m) + 0.00209 * e * e * this.SN(2.0 * m) - 0.00111 * this.SN(m1 - 2.0 * f) - 5.7E-4 * this.SN(m1 + 2.0 * f);
            jd += 5.6E-4 * e * this.SN(2.0 * m1 + m) - 4.2E-4 * this.SN(3.0 * m1) + 4.2E-4 * e * this.SN(m + 2.0 * f) + 3.8E-4 * e * this.SN(m - 2.0 * f) - 2.4E-4 * e * this.SN(2.0 * m1 - m) - 1.7E-4 * this.SN(o) - 7.0E-5 * this.SN(m1 + 2.0 * m) + 4.0E-5 * this.SN(2.0 * m1 - 2.0 * f);
            jd += 4.0E-5 * this.SN(3.0 * m) + 3.0E-5 * this.SN(m1 + m - 2.0 * f) + 3.0E-5 * this.SN(2.0 * m1 + 2.0 * f) - 3.0E-5 * this.SN(m1 + m + 2.0 * f) + 3.0E-5 * this.SN(m1 - m + 2.0 * f) - 2.0E-5 * this.SN(m1 - m - 2.0 * f) - 2.0E-5 * this.SN(3.0 * m1 + m);
            jd += 2.0E-5 * this.SN(4.0 * m1);
        } else {
            jd += -0.62801 * this.SN(m1) + 0.17172 * e * this.SN(m) - 0.01183 * e * this.SN(m1 + m) + 0.00862 * this.SN(2.0 * m1) + 0.00804 * this.SN(2.0 * f) + 0.00454 * e * this.SN(m1 - m) + 0.00204 * e * e * this.SN(2.0 * m) - 0.0018 * this.SN(m1 - 2.0 * f) - 7.0E-4 * this.SN(m1 + 2.0 * f);
            jd += -4.0E-4 * this.SN(3.0 * m1) - 3.4E-4 * e * this.SN(2.0 * m1 - m) + 3.2E-4 * e * this.SN(m + 2.0 * f) + 3.2E-4 * e * this.SN(m - 2.0 * f) - 2.8E-4 * e * e * this.SN(m1 + 2.0 * m) + 2.7E-4 * e * this.SN(2.0 * m1 + m) - 1.7E-4 * this.SN(o);
            jd += -5.0E-5 * this.SN(m1 - m - 2.0 * f) + 4.0E-5 * this.SN(2.0 * m1 + 2.0 * f) - 4.0E-5 * this.SN(m1 + m + 2.0 * f) + 4.0E-5 * this.SN(m1 - 2.0 * m) + 3.0E-5 * this.SN(m1 + m - 2.0 * f) + 3.0E-5 * this.SN(3.0 * m) + 2.0E-5 * this.SN(2.0 * m1 - 2.0 * f);
            jd += 2.0E-5 * this.SN(m1 - m + 2.0 * f) - 2.0E-5 * this.SN(3.0 * m1 + m);
            double w = 0.00306 - 3.8E-4 * e * this.CS(m) + 2.6E-4 * this.CS(m1) - 2.0E-5 * this.CS(m1 - m) + 2.0E-5 * this.CS(m1 + m) + 2.0E-5 * this.CS(2.0 * f);
            jd += mode == 0.25 ? w : -w;
        }
        return this.moonCorrection(jd, t, k_mod);
    }

    private double getEclipse(double k, double typ, int mode) {
        double k_mod = Math.floor(k) + typ;
        double t = k_mod / 1236.85;
        double f = this.var_f(k_mod, t);
        double jd = 0.0;
        double ringTest = 0.0;
        if (this.SN(Math.abs(f)) <= 0.36) {
            double o = this.var_o(k_mod, t);
            double f1 = f - 0.02665 * this.SN(o);
            double a1 = 299.77 + 0.107408 * k_mod - 0.009173 * t * t;
            double e = this.var_e(t);
            double m = this.var_m(k_mod, t);
            double m1 = this.var_m1(k_mod, t);
            double p = 0.207 * e * this.SN(m) + 0.0024 * e * this.SN(2.0 * m) - 0.0392 * this.SN(m1) + 0.0116 * this.SN(2.0 * m1) - 0.0073 * e * this.SN(m1 + m) + 0.0067 * e * this.SN(m1 - m) + 0.0118 * this.SN(2.0 * f1);
            double q = 5.2207 - 0.0048 * e * this.CS(m) + 0.002 * e * this.CS(2.0 * m) - 0.3299 * this.CS(m1) - 0.006 * e * this.CS(m1 + m) + 0.0041 * e * this.CS(m1 - m);
            double g = (p * this.CS(f1) + q * this.SN(f1)) * (1.0 - 0.0048 * this.CS(Math.abs(f1)));
            double u = 0.0059 + 0.0046 * e * this.CS(m) - 0.0182 * this.CS(m1) + 4.0E-4 * this.CS(2.0 * m1) - 5.0E-4 * this.CS(m + m1);
            jd = this.var_jde(k_mod, t);
            jd += typ == 0.5 ? -0.4065 * this.SN(m1) + 0.1727 * e * this.SN(m) : -0.4075 * this.SN(m1) + 0.1721 * e * this.SN(m);
            jd += 0.0161 * this.SN(2.0 * m1) - 0.0097 * this.SN(2.0 * f1) + 0.0073 * e * this.SN(m1 - m) - 0.005 * e * this.SN(m1 + m) - 0.0023 * this.SN(m1 - 2.0 * f1) + 0.0021 * e * this.SN(2.0 * m);
            jd += 0.0012 * this.SN(m1 + 2.0 * f1) + 6.0E-4 * e * this.SN(2.0 * m1 + m) - 4.0E-4 * this.SN(3.0 * m1) - 3.0E-4 * e * this.SN(m + 2.0 * f1) + 3.0E-4 * this.SN(a1) - 2.0E-4 * e * this.SN(m - 2.0 * f1) - 2.0E-4 * e * this.SN(2.0 * m1 - m) - 2.0E-4 * this.SN(o);
            if (typ == 0.5) {
                if ((1.0248 - u - Math.abs(g)) / 0.545 <= 0.0) {
                    jd = 0.0;
                }
                if (mode == 0 && (1.0128 - u - Math.abs(g)) / 0.545 > 0.0 && (0.4678 - u) * (0.4678 - u) - g * g > 0.0) {
                    jd = 0.0;
                }
                if (mode == 1 && (1.0128 - u - Math.abs(g)) / 0.545 <= 0.0 != (0.4678 - u) * (0.4678 - u) - g * g <= 0.0) {
                    jd = 0.0;
                }
            } else {
                if (Math.abs(g) > 1.5433 + u) {
                    jd = 0.0;
                }
                if (mode == 0 && (g >= -0.9972 && g <= 0.9972 || Math.abs(g) >= 0.9972 && Math.abs(g) < 0.9972 + Math.abs(u))) {
                    jd = 0.0;
                }
                if (mode > 0) {
                    if (g < -0.9972 || g > 0.9972 || Math.abs(g) < 0.9972 && Math.abs(g) > 0.9972 + Math.abs(u)) {
                        jd = 0.0;
                    }
                    if (u > 0.0047 || u >= 0.00464 * Math.sqrt(1.0 - g * g)) {
                        ringTest = 1.0;
                    }
                    if (ringTest == 1.0 && mode == 1) {
                        jd = 0.0;
                    }
                    if (ringTest == 0.0 && mode == 2) {
                        jd = 0.0;
                    }
                }
            }
        }
        return jd;
    }

    private double getIllumination(double jd) {
        double t = (jd - 2451545.0) / 36525.0;
        double d = 297.8502042 + 445267.11151686 * t - 0.00163 * t * t + t * t * t / 545868.0 - t * t * t * t / 1.13065E8;
        double m = 357.5291092 + 35999.0502909 * t - 1.536E-4 * t * t + t * t * t / 2.449E7;
        double m1 = 134.9634114 + 477198.8676313 * t + 0.008997 * t * t + t * t * t / 69699.0 - t * t * t * t / 1.4712E7;
        double i = 180.0 - d - 6.289 * this.SN(m1) + 2.1 * this.SN(m) - 1.274 * this.SN(2.0 * d - m1) - 0.658 * this.SN(2.0 * d) - 0.241 * this.SN(2.0 * m1) - 0.11 * this.SN(d);
        return (1.0 + this.CS(i)) / 2.0 * 100.0;
    }

    private double getNextPhase(Calendar cal, double midnightJd, double mode) {
        double k;
        double tz = 0.0;
        double phaseJd = 0.0;
        do {
            k = this.var_k(cal, tz);
            tz += 1.0;
        } while ((phaseJd = this.calcMoonPhase(k, mode)) <= midnightJd);
        return phaseJd;
    }

    public double getPreviousPhase(Calendar cal, double jd, double mode) {
        double k;
        double tz = 0.0;
        double phaseJd = 0.0;
        do {
            k = this.var_k(cal, tz);
            tz -= 1.0;
        } while ((phaseJd = this.calcMoonPhase(k, mode)) > jd);
        return phaseJd;
    }

    protected double getEclipse(Calendar cal, double type, double midnightJd, int mode) {
        double k;
        double tz = 0.0;
        double eclipseJd = 0.0;
        do {
            k = this.var_k(cal, tz);
            tz += 1.0;
        } while ((eclipseJd = this.getEclipse(k, type, mode)) <= midnightJd);
        return eclipseJd;
    }

    private double getApogee(double julianDate, double decimalYear) {
        double f;
        double m;
        double d;
        double k = Math.floor((decimalYear - 1999.97) * 13.2555) + 0.5;
        double jd = 0.0;
        do {
            double t = k / 1325.55;
            d = 171.9179 + 335.9106046 * k - 0.010025 * t * t - 1.156E-5 * t * t * t + 5.5E-8 * t * t * t * t;
            m = 347.3477 + 27.1577721 * k - 8.323E-4 * t * t - 1.0E-6 * t * t * t;
            f = 316.6109 + 364.5287911 * k - 0.0125131 * t * t - 1.48E-5 * t * t * t;
            jd = 2451534.6698 + 27.55454988 * k - 6.886E-4 * t * t - 1.098E-6 * t * t * t + 5.2E-9 * t * t + 0.4392 * this.SN(2.0 * d) + 0.0684 * this.SN(4.0 * d) + (0.0456 - 1.1E-4 * t) * this.SN(m) + (0.0426 - 1.1E-4 * t) * this.SN(2.0 * d - m) + 0.0212 * this.SN(2.0 * f);
            jd += -0.0189 * this.SN(d) + 0.0144 * this.SN(6.0 * d) + 0.0113 * this.SN(4.0 * d - m) + 0.0047 * this.SN(2.0 * d + 2.0 * f) + 0.0036 * this.SN(d + m) + 0.0035 * this.SN(8.0 * d) + 0.0034 * this.SN(6.0 * d - m) - 0.0034 * this.SN(2.0 * d - 2.0 * f) + 0.0022 * this.SN(2.0 * d - 2.0 * m) - 0.0017 * this.SN(3.0 * d);
            jd += 0.0013 * this.SN(4.0 * d + 2.0 * f) + 0.0011 * this.SN(8.0 * d - m) + 0.001 * this.SN(4.0 * d - 2.0 * m) + 9.0E-4 * this.SN(10.0 * d) + 7.0E-4 * this.SN(3.0 * d + m) + 6.0E-4 * this.SN(2.0 * m) + 5.0E-4 * this.SN(2.0 * d + m) + 5.0E-4 * this.SN(2.0 * d + 2.0 * m) + 4.0E-4 * this.SN(6.0 * d + 2.0 * f);
            k += 1.0;
        } while ((jd += 4.0E-4 * this.SN(6.0 * d - 2.0 * m) + 4.0E-4 * this.SN(10.0 * d - m) - 4.0E-4 * this.SN(5.0 * d) - 4.0E-4 * this.SN(4.0 * d - 2.0 * f) + 3.0E-4 * this.SN(2.0 * f + m) + 3.0E-4 * this.SN(12.0 * d) + 3.0E-4 * this.SN(2.0 * d + 2.0 * f - m) - 3.0E-4 * this.SN(d - m)) < julianDate);
        return jd;
    }

    private double getPerigee(double julianDate, double decimalYear) {
        double d;
        double f;
        double m;
        double k = Math.floor((decimalYear - 1999.97) * 13.2555);
        double jd = 0.0;
        do {
            double t = k / 1325.55;
            d = 171.9179 + 335.9106046 * k - 0.010025 * t * t - 1.156E-5 * t * t * t + 5.5E-8 * t * t * t * t;
            m = 347.3477 + 27.1577721 * k - 8.323E-4 * t * t - 1.0E-6 * t * t * t;
            f = 316.6109 + 364.5287911 * k - 0.0125131 * t * t - 1.48E-5 * t * t * t;
            jd = 2451534.6698 + 27.55454988 * k - 6.886E-4 * t * t - 1.098E-6 * t * t * t + 5.2E-9 * t * t - 1.6769 * this.SN(2.0 * d) + 0.4589 * this.SN(4.0 * d) - 0.1856 * this.SN(6.0 * d) + 0.0883 * this.SN(8.0 * d);
            jd += -(0.0773 + 1.9E-4 * t) * this.SN(2.0 * d - m) + (0.0502 - 1.3E-4 * t) * this.SN(m) - 0.046 * this.SN(10.0 * d) + (0.0422 - 1.1E-4 * t) * this.SN(4.0 * d - m) - 0.0256 * this.SN(6.0 * d - m) + 0.0253 * this.SN(12.0 * d) + 0.0237 * this.SN(d);
            jd += 0.0162 * this.SN(8.0 * d - m) - 0.0145 * this.SN(14.0 * d) + 0.0129 * this.SN(2.0 * f) - 0.0112 * this.SN(3.0 * d) - 0.0104 * this.SN(10.0 * d - m) + 0.0086 * this.SN(16.0 * d) + 0.0069 * this.SN(12.0 * d - m) + 0.0066 * this.SN(5.0 * d) - 0.0053 * this.SN(2.0 * d + 2.0 * f);
            jd += -0.0052 * this.SN(18.0 * d) - 0.0046 * this.SN(14.0 * d - m) - 0.0041 * this.SN(7.0 * d) + 0.004 * this.SN(2.0 * d + m) + 0.0032 * this.SN(20.0 * d) - 0.0032 * this.SN(d + m) + 0.0031 * this.SN(16.0 * d - m);
            jd += -0.0029 * this.SN(4.0 * d + m) - 0.0027 * this.SN(2.0 * d - 2.0 * m) + 0.0024 * this.SN(4.0 * d - 2.0 * m) - 0.0021 * this.SN(6.0 * d - 2.0 * m) - 0.0021 * this.SN(22.0 * d) - 0.0021 * this.SN(18.0 * d - m);
            jd += 0.0019 * this.SN(6.0 * d + m) - 0.0018 * this.SN(11.0 * d) - 0.0014 * this.SN(8.0 * d + m) - 0.0014 * this.SN(4.0 * d - 2.0 * f) - 0.0014 * this.SN(6.0 * d - 2.0 * f) + 0.0014 * this.SN(3.0 * d + m) - 0.0014 * this.SN(5.0 * d + m) + 0.0013 * this.SN(13.0 * d);
            jd += 0.0013 * this.SN(20.0 * d - m) + 0.0011 * this.SN(3.0 * d + 2.0 * m) - 0.0011 * this.SN(4.0 * d + 2.0 * f - 2.0 * m) - 0.001 * this.SN(d + 2.0 * m) - 9.0E-4 * this.SN(22.0 * d - m) - 8.0E-4 * this.SN(4.0 * f) + 8.0E-4 * this.SN(6.0 * d - 2.0 * f) + 8.0E-4 * this.SN(2.0 * d - 2.0 * f + m);
            k += 1.0;
        } while ((jd += 7.0E-4 * this.SN(2.0 * m) + 7.0E-4 * this.SN(2.0 * f - m) + 7.0E-4 * this.SN(2.0 * d + 4.0 * f) - 6.0E-4 * this.SN(2.0 * f - 2.0 * m) - 6.0E-4 * this.SN(2.0 * d - 2.0 * f + 2.0 * m) + 6.0E-4 * this.SN(24.0 * d) + 5.0E-4 * this.SN(4.0 * d - 4.0 * f) + 5.0E-4 * this.SN(2.0 * d + 2.0 * m) - 4.0E-4 * this.SN(d - m) + 0.0027 * this.SN(9.0 * d) + 0.0027 * this.SN(4.0 * d + 2.0 * f)) < julianDate);
        return jd;
    }

    private double getDistance(double jd) {
        double t = (jd - 2451545.0) / 36525.0;
        double d = 297.8502042 + 445267.11151686 * t - 0.00163 * t * t + t * t * t / 545868.0 - t * t * t * t / 1.13065E8;
        double m = 357.5291092 + 35999.0502909 * t - 1.536E-4 * t * t + t * t * t / 2.449E7;
        double m1 = 134.9634114 + 477198.8676313 * t + 0.008997 * t * t + t * t * t / 69699.0 - t * t * t * t / 1.4712E7;
        double f = 93.2720993 + 483202.0175273 * t - 0.0034029 * t * t - t * t * t / 3526000.0 + t * t * t * t / 8.6331E8;
        double sr = 385000.56 + this.getCoefficient(d, m, m1, f) / 1000.0;
        return sr;
    }

    public double[] calcMoon(double t) {
        double p2 = 6.283185307;
        double arc = 206264.8062;
        double coseps = 0.91748;
        double sineps = 0.39778;
        double lo = this.FRAK(0.606433 + 1336.855225 * t);
        double l = p2 * this.FRAK(0.374897 + 1325.55241 * t);
        double ls = p2 * this.FRAK(0.993133 + 99.997361 * t);
        double d = p2 * this.FRAK(0.827361 + 1236.853086 * t);
        double f = p2 * this.FRAK(0.259086 + 1342.227825 * t);
        double dl = 22640.0 * Math.sin(l) - 4586.0 * Math.sin(l - 2.0 * d) + 2370.0 * Math.sin(2.0 * d) + 769.0 * Math.sin(2.0 * l) - 668.0 * Math.sin(ls) - 412.0 * Math.sin(2.0 * f) - 212.0 * Math.sin(2.0 * l - 2.0 * d) - 206.0 * Math.sin(l + ls - 2.0 * d) + 192.0 * Math.sin(l + 2.0 * d) - 165.0 * Math.sin(ls - 2.0 * d) - 125.0 * Math.sin(d) - 110.0 * Math.sin(l + ls) + 148.0 * Math.sin(l - ls) - 55.0 * Math.sin(2.0 * f - 2.0 * d);
        double s = f + (dl + 412.0 * Math.sin(2.0 * f) + 541.0 * Math.sin(ls)) / arc;
        double h = f - 2.0 * d;
        double n = -526.0 * Math.sin(h) + 44.0 * Math.sin(l + h) - 31.0 * Math.sin(-l + h) - 23.0 * Math.sin(ls + h) + 11.0 * Math.sin(-ls + h) - 25.0 * Math.sin(-2.0 * l + f) + 21.0 * Math.sin(-l + f);
        double lmoon = p2 * this.FRAK(lo + dl / 1296000.0);
        double bmoon = (18520.0 * Math.sin(s) + n) / arc;
        double cb = Math.cos(bmoon);
        double x = cb * Math.cos(lmoon);
        double v = cb * Math.sin(lmoon);
        double w = Math.sin(bmoon);
        double y = coseps * v - sineps * w;
        double z = sineps * v + coseps * w;
        double rho = Math.sqrt(1.0 - z * z);
        double dec = 360.0 / p2 * Math.atan(z / rho);
        double ra = 48.0 / p2 * Math.atan(y / (x + rho));
        if (ra < 0.0) {
            ra += 24.0;
        }
        return new double[]{dec, ra};
    }

    private double CS(double x) {
        return Math.cos(x * (Math.PI / 180));
    }

    private double SN(double x) {
        return Math.sin(x * (Math.PI / 180));
    }

    private double SINALT(double moonJd, int hour, double lambda, double cphi, double sphi) {
        double jdo = moonJd + (double)hour / 24.0;
        double t = (jdo - 51544.5) / 36525.0;
        double[] decra = this.calcMoon(t);
        double tau = 15.0 * (this.LMST(jdo, lambda) - decra[1]);
        return sphi * this.SN(decra[0]) + cphi * this.CS(decra[0]) * this.CS(tau);
    }

    private double LMST(double moonJd, double lambda) {
        double moonJdo = Math.floor(moonJd);
        double ut = (moonJd - moonJdo) * 24.0;
        double t = (moonJdo - 51544.5) / 36525.0;
        double gmst = 6.697374558 + 1.0027379093 * ut + (8640184.812866 + (0.093104 - 6.2E-6 * t) * t) * t / 3600.0;
        return 24.0 * this.FRAK((gmst - lambda / 15.0) / 24.0);
    }

    private double FRAK(double x) {
        double ret = x - (double)((int)x);
        if (ret < 0.0) {
            ret += 1.0;
        }
        return ret;
    }

    private double[] QUAD(double yminus, double yo, double yplus) {
        double nz = 0.0;
        double a = 0.5 * (yminus + yplus) - yo;
        double b = 0.5 * (yplus - yminus);
        double c = yo;
        double xe = -b / (2.0 * a);
        double ye = (a * xe + b) * xe + c;
        double dis = b * b - 4.0 * a * c;
        double zero1 = 0.0;
        double zero2 = 0.0;
        if (dis >= 0.0) {
            double dx = 0.5 * Math.sqrt(dis) / Math.abs(a);
            zero1 = xe - dx;
            zero2 = xe + dx;
            if (Math.abs(zero1) <= 1.0) {
                nz += 1.0;
            }
            if (Math.abs(zero2) <= 1.0) {
                nz += 1.0;
            }
            if (zero1 < -1.0) {
                zero1 = zero2;
            }
        }
        return new double[]{ye, zero1, zero2, nz};
    }

    private double var_o(double k, double t) {
        return 124.7746 - 1.5637558 * k + 0.0020691 * t * t + 2.15E-6 * t * t * t;
    }

    private double var_f(double k, double t) {
        return 160.7108 + 390.67050274 * k - 0.0016341 * t * t - 2.27E-6 * t * t * t + 1.1E-8 * t * t * t * t;
    }

    private double var_m1(double k, double t) {
        return 201.5643 + 385.81693528 * k + 0.1017438 * t * t + 1.239E-5 * t * t * t - 5.8E-8 * t * t * t * t;
    }

    private double var_m(double k, double t) {
        return 2.5534 + 29.10535669 * k - 2.18E-5 * t * t - 1.1E-7 * t * t * t;
    }

    private double var_e(double t) {
        return 1.0 - 0.002516 * t - 7.4E-6 * t * t;
    }

    private double var_jde(double k, double t) {
        return 2451550.09765 + 29.530588853 * k + 1.337E-4 * t * t - 1.5E-7 * t * t * t + 7.3E-10 * t * t * t * t;
    }

    private double var_k(Calendar cal, double tz) {
        return ((double)cal.get(1) + ((double)cal.get(6) + tz) / 365.0 - 2000.0) * 12.3685;
    }

    private double moonCorrection(double jd, double t, double k) {
        double ret = jd;
        ret += 3.25E-4 * this.SN(299.77 + 0.107408 * k - 0.009173 * t * t) + 1.65E-4 * this.SN(251.88 + 0.016321 * k) + 1.64E-4 * this.SN(251.83 + 26.651886 * k) + 1.26E-4 * this.SN(349.42 + 36.412478 * k) + 1.1E-4 * this.SN(84.66 + 18.206239 * k);
        ret += 6.2E-5 * this.SN(141.74 + 53.303771 * k) + 6.0E-5 * this.SN(207.14 + 2.453732 * k) + 5.6E-5 * this.SN(154.84 + 7.30686 * k) + 4.7E-5 * this.SN(34.52 + 27.261239 * k) + 4.2E-5 * this.SN(207.19 + 0.121824 * k) + 4.0E-5 * this.SN(291.34 + 1.844379 * k);
        return ret += 3.7E-5 * this.SN(161.72 + 24.198154 * k) + 3.5E-5 * this.SN(239.56 + 25.513099 * k) + 2.3E-5 * this.SN(331.55 + 3.592518 * k);
    }

    private double getCoefficient(double d, double m, double m1, double f) {
        int[] nArray = new int[60];
        nArray[1] = 2;
        nArray[2] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[11] = 1;
        nArray[13] = 2;
        nArray[16] = 4;
        nArray[18] = 4;
        nArray[19] = 2;
        nArray[20] = 2;
        nArray[21] = 1;
        nArray[22] = 1;
        nArray[23] = 2;
        nArray[24] = 2;
        nArray[25] = 4;
        nArray[26] = 2;
        nArray[28] = 2;
        nArray[29] = 2;
        nArray[30] = 1;
        nArray[31] = 2;
        nArray[34] = 2;
        nArray[35] = 2;
        nArray[36] = 2;
        nArray[37] = 4;
        nArray[39] = 3;
        nArray[40] = 2;
        nArray[41] = 4;
        nArray[43] = 2;
        nArray[44] = 2;
        nArray[45] = 2;
        nArray[46] = 4;
        nArray[48] = 4;
        nArray[49] = 1;
        nArray[50] = 2;
        nArray[52] = 1;
        nArray[53] = 3;
        nArray[54] = 4;
        nArray[55] = 2;
        nArray[57] = 1;
        nArray[58] = 2;
        nArray[59] = 2;
        int[] kd = nArray;
        int[] nArray2 = new int[60];
        nArray2[4] = 1;
        nArray2[7] = -1;
        nArray2[9] = -1;
        nArray2[10] = 1;
        nArray2[12] = 1;
        nArray2[19] = 1;
        nArray2[20] = 1;
        nArray2[22] = 1;
        nArray2[23] = -1;
        nArray2[27] = 1;
        nArray2[29] = -1;
        nArray2[31] = -2;
        nArray2[32] = 1;
        nArray2[33] = 2;
        nArray2[34] = -2;
        nArray2[37] = -1;
        nArray2[40] = 1;
        nArray2[41] = -1;
        nArray2[42] = 2;
        nArray2[43] = 2;
        nArray2[44] = 1;
        nArray2[45] = -1;
        nArray2[48] = -1;
        nArray2[50] = 1;
        nArray2[52] = 1;
        nArray2[55] = -1;
        nArray2[56] = 2;
        nArray2[57] = 1;
        int[] km = nArray2;
        int[] nArray3 = new int[60];
        nArray3[0] = 1;
        nArray3[1] = -1;
        nArray3[3] = 2;
        nArray3[6] = -2;
        nArray3[7] = -1;
        nArray3[8] = 1;
        nArray3[10] = -1;
        nArray3[12] = 1;
        nArray3[14] = 1;
        nArray3[15] = 1;
        nArray3[16] = -1;
        nArray3[17] = 3;
        nArray3[18] = -2;
        nArray3[19] = -1;
        nArray3[21] = -1;
        nArray3[23] = 1;
        nArray3[24] = 2;
        nArray3[26] = -3;
        nArray3[27] = -2;
        nArray3[28] = -1;
        nArray3[29] = -2;
        nArray3[30] = 1;
        nArray3[32] = 2;
        nArray3[34] = -1;
        nArray3[35] = 1;
        nArray3[37] = -1;
        nArray3[38] = 2;
        nArray3[39] = -1;
        nArray3[40] = 1;
        nArray3[41] = -2;
        nArray3[42] = -1;
        nArray3[43] = -1;
        nArray3[44] = -2;
        nArray3[46] = 1;
        nArray3[47] = 4;
        nArray3[49] = -2;
        nArray3[51] = 2;
        nArray3[52] = 1;
        nArray3[53] = -2;
        nArray3[54] = -3;
        nArray3[55] = 2;
        nArray3[56] = 1;
        nArray3[57] = -1;
        nArray3[58] = 3;
        nArray3[59] = -1;
        int[] km1 = nArray3;
        int[] nArray4 = new int[60];
        nArray4[5] = 2;
        nArray4[13] = -2;
        nArray4[14] = 2;
        nArray4[15] = -2;
        nArray4[28] = 2;
        nArray4[35] = -2;
        nArray4[36] = 2;
        nArray4[38] = 2;
        nArray4[45] = -2;
        nArray4[50] = -2;
        nArray4[51] = -2;
        nArray4[59] = -2;
        int[] kf = nArray4;
        int[] nArray5 = new int[60];
        nArray5[0] = -20905355;
        nArray5[1] = -3699111;
        nArray5[2] = -2955968;
        nArray5[3] = -569925;
        nArray5[4] = 48888;
        nArray5[5] = -3149;
        nArray5[6] = 246158;
        nArray5[7] = -152138;
        nArray5[8] = -170733;
        nArray5[9] = -204586;
        nArray5[10] = -129620;
        nArray5[11] = 108743;
        nArray5[12] = 104755;
        nArray5[13] = 10321;
        nArray5[15] = 79661;
        nArray5[16] = -34782;
        nArray5[17] = -23210;
        nArray5[18] = -21636;
        nArray5[19] = 24208;
        nArray5[20] = 30824;
        nArray5[21] = -8379;
        nArray5[22] = -16675;
        nArray5[23] = -12831;
        nArray5[24] = -10445;
        nArray5[25] = -11650;
        nArray5[26] = 14403;
        nArray5[27] = -7003;
        nArray5[29] = 10056;
        nArray5[30] = 6322;
        nArray5[31] = -9884;
        nArray5[32] = 5751;
        nArray5[34] = -4950;
        nArray5[35] = 4130;
        nArray5[37] = -3958;
        nArray5[39] = 3258;
        nArray5[40] = 2616;
        nArray5[41] = -1897;
        nArray5[42] = -2117;
        nArray5[43] = 2354;
        nArray5[46] = -1423;
        nArray5[47] = -1117;
        nArray5[48] = -1571;
        nArray5[49] = -1739;
        nArray5[51] = -4421;
        nArray5[56] = 1165;
        nArray5[59] = 8752;
        int[] kr = nArray5;
        double sr = 0.0;
        int t = 0;
        while (t < 60) {
            sr += (double)kr[t] * this.CS((double)kd[t] * d + (double)km[t] * m + (double)km1[t] * m1 + (double)kf[t] * f);
            ++t;
        }
        return sr;
    }

    private void setAzimuthElevationZodiac(double julianDate, double latitude, double longitude, Moon moon) {
        double lat = latitude * (Math.PI / 180);
        double lon = longitude * (Math.PI / 180);
        double gmst = this.toGMST(julianDate);
        double lmst = this.toLMST(gmst, lon) * 15.0 * (Math.PI / 180);
        double d = julianDate - 2447891.5;
        double anomalyMean = 0.017202791632524146 * d + 4.87650757829735 - 4.935239984568769;
        double nu = anomalyMean + 0.033426 * Math.sin(anomalyMean);
        double sunLon = this.mod2Pi(nu + 4.935239984568769);
        double l0 = 5.556284436750021;
        double p0 = 0.6342598060246725;
        double n0 = 5.559050068029439;
        double i = 0.08980410151894615;
        double l = 0.22997150421858628 * d + l0;
        double mMoon = l - 0.0019443683452210149 * d - p0;
        double n = n0 - 9.242199067718253E-4 * d;
        double c = l - sunLon;
        double ev = 0.022233749341155764 * Math.sin(2.0 * c - mMoon);
        double ae = 0.003242821750205464 * Math.sin(anomalyMean);
        double a3 = 0.006457718232379019 * Math.sin(anomalyMean);
        double mMoon2 = mMoon + ev - ae - a3;
        double ec = 0.10975677534091541 * Math.sin(mMoon2);
        double a4 = 0.003735004599267865 * Math.sin(2.0 * mMoon2);
        double l2 = l + ev + ec - ae + a4;
        double v = 0.011489502465878671 * Math.sin(2.0 * (l2 - sunLon));
        double l3 = l2 + v;
        double n2 = n - 0.0027925268031909274 * Math.sin(anomalyMean);
        double moonLon = this.mod2Pi(n2 + Math.atan2(Math.sin(l3 - n2) * Math.cos(i), Math.cos(l3 - n2)));
        double moonLat = Math.asin(Math.sin(l3 - n2) * Math.sin(i));
        double[] raDec = this.ecl2Equ(moonLat, moonLon, julianDate);
        double distance = 0.99698599 / (1.0 + 0.0549 * Math.cos(mMoon2 + ec)) * 384401.0;
        double[] raDecTopo = this.geoEqu2TopoEqu(raDec, distance, lat, lmst);
        double[] azAlt = this.equ2AzAlt(raDecTopo[0], raDecTopo[1], lat, lmst);
        Position position = moon.getPosition();
        position.setAzimuth(azAlt[0] * 57.29577951308232);
        position.setElevation(azAlt[1] * 57.29577951308232 + this.refraction(azAlt[1]));
        double idxd = Math.floor(moonLon * 57.29577951308232 / 30.0);
        int idx = 0;
        idx = idxd < 0.0 ? (int)Math.ceil(idxd) : (int)Math.floor(idxd);
        if (idx >= 0 || idx <= ZodiacSign.values().length) {
            moon.setZodiac(new Zodiac(ZodiacSign.values()[idx]));
        }
    }

    private double mod2Pi(double x) {
        return this.mod(x, Math.PI * 2);
    }

    private double mod(double a, double b) {
        return a - Math.floor(a / b) * b;
    }

    private double[] equ2AzAlt(double ra, double dec, double geolat, double lmst) {
        double cosdec = Math.cos(dec);
        double sindec = Math.sin(dec);
        double lha = lmst - ra;
        double coslha = Math.cos(lha);
        double sinlha = Math.sin(lha);
        double coslat = Math.cos(geolat);
        double sinlat = Math.sin(geolat);
        double n = -cosdec * sinlha;
        double d = sindec * coslat - cosdec * coslha * sinlat;
        double az = this.mod2Pi(Math.atan2(n, d));
        double alt = Math.asin(sindec * sinlat + cosdec * coslha * coslat);
        return new double[]{az, alt};
    }

    private double[] ecl2Equ(double lat, double lon, double jd) {
        double t = (jd - 2451545.0) / 36525.0;
        double eps = (23.439291666666666 + t * (-46.815 + t * (-6.0E-4 + t * 0.00181)) / 3600.0) * (Math.PI / 180);
        double coseps = Math.cos(eps);
        double sineps = Math.sin(eps);
        double sinlon = Math.sin(lon);
        double ra = this.mod2Pi(Math.atan2(sinlon * coseps - Math.tan(lat) * sineps, Math.cos(lon)));
        double dec = Math.asin(Math.sin(lat) * coseps + Math.cos(lat) * sineps * sinlon);
        return new double[]{ra, dec};
    }

    private double[] geoEqu2TopoEqu(double[] raDec, double distance, double observerLat, double lmst) {
        double cosdec = Math.cos(raDec[1]);
        double sindec = Math.sin(raDec[1]);
        double coslst = Math.cos(lmst);
        double sinlst = Math.sin(lmst);
        double coslat = Math.cos(observerLat);
        double sinlat = Math.sin(observerLat);
        double rho = this.getCenterDistance(observerLat);
        double x = distance * cosdec * Math.cos(raDec[0]) - rho * coslat * coslst;
        double y = distance * cosdec * Math.sin(raDec[0]) - rho * coslat * sinlst;
        double z = distance * sindec - rho * sinlat;
        double distanceTopocentric = Math.sqrt(x * x + y * y + z * z);
        double raTopo = this.mod2Pi(Math.atan2(y, x));
        double decTopo = Math.asin(z / distanceTopocentric);
        return new double[]{raTopo, decTopo};
    }

    private double toGMST(double jd) {
        double ut = (jd - 0.5 - Math.floor(jd - 0.5)) * 24.0;
        double jd_mod = Math.floor(jd - 0.5) + 0.5;
        double t = (jd_mod - 2451545.0) / 36525.0;
        double t0 = 6.697374558 + t * (2400.051336 + t * 2.5862E-5);
        return this.mod(t0 + ut * 1.002737909, 24.0);
    }

    private double toLMST(double gmst, double lon) {
        return this.mod(gmst + 57.29577951308232 * lon / 15.0, 24.0);
    }

    private double getCenterDistance(double lat) {
        double co = Math.cos(lat);
        double si = Math.sin(lat);
        double fl = 0.9966471893352525;
        fl *= fl;
        si *= si;
        double u = 1.0 / Math.sqrt(co * co + fl * si);
        double a = 6378.137 * u;
        double b = 6378.137 * fl * u;
        return Math.sqrt(a * a * co * co + b * b * si);
    }

    private double refraction(double alt) {
        int pressure = 1015;
        int temperature = 10;
        double altdeg = alt * 57.29577951308232;
        if (altdeg < -2.0 || altdeg >= 90.0) {
            return 0.0;
        }
        if (altdeg > 15.0) {
            return 0.00452 * (double)pressure / ((double)(273 + temperature) * Math.tan(alt));
        }
        double y = alt;
        double d = 0.0;
        double p = ((double)pressure - 80.0) / 930.0;
        double q = 0.0048 * ((double)temperature - 10.0);
        double y0 = y;
        double d0 = d;
        double n = 0.0;
        int i = 0;
        while (i < 3) {
            n = y + 7.31 / (y + 4.4);
            n = 1.0 / Math.tan(n * (Math.PI / 180));
            d = n * p / (60.0 + q * (n + 39.0));
            n = y - y0;
            y0 = d - d0 - n;
            n = n != 0.0 && y0 != 0.0 ? y - n * (alt + d - y) / y0 : alt + d;
            y0 = y;
            d0 = d;
            y = n;
            ++i;
        }
        return d;
    }
}

