/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.core.i18n.ConfigI18nLocalizationService;
import org.eclipse.smarthome.config.xml.AbstractXmlConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.internal.ConfigDescriptionReader;
import org.eclipse.smarthome.config.xml.internal.ConfigDescriptionXmlProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentBundleTracker;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProviderFactory;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.service.ReadyService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConfigDescriptionProvider.class}, immediate=true, property={"esh.scope=core.xml.config"})
public class ConfigXmlConfigDescriptionProvider
extends AbstractXmlConfigDescriptionProvider
implements XmlDocumentProviderFactory<List<ConfigDescription>> {
    private static final String XML_DIRECTORY = "/ESH-INF/config/";
    public static final String READY_MARKER = "esh.xmlConfig";
    private XmlDocumentBundleTracker<List<ConfigDescription>> configDescriptionTracker;
    private ConfigI18nLocalizationService configI18nLocalizerService;
    private ReadyService readyService;
    private ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"xml-processing");
    private Future<?> trackerJob;

    @Activate
    public void activate(ComponentContext componentContext) {
        ConfigDescriptionReader configDescriptionReader = new ConfigDescriptionReader();
        this.configDescriptionTracker = new XmlDocumentBundleTracker<List<ConfigDescription>>(componentContext.getBundleContext(), XML_DIRECTORY, configDescriptionReader, this, READY_MARKER, this.readyService);
        this.trackerJob = this.scheduler.submit(() -> this.configDescriptionTracker.open());
    }

    @Deactivate
    public void deactivate() {
        if (this.trackerJob != null && !this.trackerJob.isDone()) {
            this.trackerJob.cancel(true);
            this.trackerJob = null;
        }
        this.configDescriptionTracker.close();
        this.configDescriptionTracker = null;
    }

    @Reference
    public void setConfigI18nLocalizerService(ConfigI18nLocalizationService configI18nLocalizerService) {
        this.configI18nLocalizerService = configI18nLocalizerService;
    }

    public void unsetConfigI18nLocalizerService(ConfigI18nLocalizationService configI18nLocalizerService) {
        this.configI18nLocalizerService = null;
    }

    @Reference
    public void setReadyService(ReadyService readyService) {
        this.readyService = readyService;
    }

    public void unsetReadyService(ReadyService readyService) {
        this.readyService = null;
    }

    @Override
    protected ConfigI18nLocalizationService getConfigI18nLocalizerService() {
        return this.configI18nLocalizerService;
    }

    @Override
    public XmlDocumentProvider<List<ConfigDescription>> createDocumentProvider(Bundle bundle) {
        return new ConfigDescriptionXmlProvider(bundle, this);
    }
}

