/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.webaudio.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.core.audio.AudioFormat;
import org.eclipse.smarthome.core.audio.AudioHTTPServer;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.core.audio.FixedLengthAudioStream;
import org.eclipse.smarthome.core.audio.URLAudioStream;
import org.eclipse.smarthome.core.audio.UnsupportedAudioFormatException;
import org.eclipse.smarthome.core.audio.UnsupportedAudioStreamException;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.io.webaudio.internal.PlayURLEvent;
import org.eclipse.smarthome.io.webaudio.internal.WebAudioEventFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEAudioSink
implements AudioSink {
    private final Logger logger = LoggerFactory.getLogger(SSEAudioSink.class);
    private static final HashSet<AudioFormat> SUPPORTED_AUDIO_FORMATS = new HashSet();
    private static final HashSet<Class<? extends AudioStream>> SUPPORTED_AUDIO_STREAMS = new HashSet();
    private AudioHTTPServer audioHTTPServer;
    private EventPublisher eventPublisher;

    static {
        SUPPORTED_AUDIO_FORMATS.add(AudioFormat.WAV);
        SUPPORTED_AUDIO_FORMATS.add(AudioFormat.MP3);
        SUPPORTED_AUDIO_STREAMS.add(URLAudioStream.class);
        SUPPORTED_AUDIO_STREAMS.add(FixedLengthAudioStream.class);
    }

    public void process(AudioStream audioStream) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException {
        this.logger.debug("Received audio stream of format {}", (Object)audioStream.getFormat());
        if (audioStream instanceof URLAudioStream) {
            URLAudioStream urlAudioStream = (URLAudioStream)audioStream;
            this.sendEvent(urlAudioStream.getURL());
            IOUtils.closeQuietly((InputStream)audioStream);
        } else if (audioStream instanceof FixedLengthAudioStream) {
            String url = this.audioHTTPServer.serve((FixedLengthAudioStream)audioStream, 10).toString();
            this.sendEvent(url);
        } else {
            IOUtils.closeQuietly((InputStream)audioStream);
            throw new UnsupportedAudioStreamException("Web audio sink can only handle FixedLengthAudioStreams and URLAudioStreams.", audioStream.getClass());
        }
    }

    private void sendEvent(String url) {
        PlayURLEvent event = WebAudioEventFactory.createPlayURLEvent(url);
        this.eventPublisher.post((Event)event);
    }

    public Set<AudioFormat> getSupportedFormats() {
        return SUPPORTED_AUDIO_FORMATS;
    }

    public Set<Class<? extends AudioStream>> getSupportedStreams() {
        return SUPPORTED_AUDIO_STREAMS;
    }

    public String getId() {
        return "webaudio";
    }

    public String getLabel(Locale locale) {
        return "Web Audio";
    }

    public PercentType getVolume() throws IOException {
        return PercentType.HUNDRED;
    }

    public void setVolume(PercentType volume) throws IOException {
        throw new IOException("Web Audio sink does not support volume level changes.");
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void setAudioHTTPServer(AudioHTTPServer audioHTTPServer) {
        this.audioHTTPServer = audioHTTPServer;
    }

    protected void unsetAudioHTTPServer(AudioHTTPServer audioHTTPServer) {
        this.audioHTTPServer = null;
    }
}

