/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.rule.runtime.internal.engine;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemRegistryChangeListener;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.events.ChannelTriggeredEvent;
import org.eclipse.smarthome.core.thing.events.ThingStatusInfoChangedEvent;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.rule.RulesStandaloneSetup;
import org.eclipse.smarthome.model.rule.rules.Rule;
import org.eclipse.smarthome.model.rule.rules.RuleModel;
import org.eclipse.smarthome.model.rule.runtime.RuleEngine;
import org.eclipse.smarthome.model.rule.runtime.internal.RuleRuntimeActivator;
import org.eclipse.smarthome.model.rule.runtime.internal.engine.RuleContextHelper;
import org.eclipse.smarthome.model.rule.runtime.internal.engine.RuleEvaluationContext;
import org.eclipse.smarthome.model.rule.runtime.internal.engine.RuleTriggerManager;
import org.eclipse.smarthome.model.script.engine.Script;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.smarthome.model.script.engine.ScriptExecutionException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EventSubscriber.class, RuleEngine.class})
public class RuleEngineImpl
implements ItemRegistryChangeListener,
StateChangeListener,
ModelRepositoryChangeListener,
RuleEngine,
EventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(RuleEngineImpl.class);
    protected final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)RuleEngine.class.getSimpleName());
    private ItemRegistry itemRegistry;
    private ModelRepository modelRepository;
    private ScriptEngine scriptEngine;
    private RuleTriggerManager triggerManager;
    private Injector injector;
    private ScheduledFuture<?> startupJob;
    private boolean starting = true;
    private final Set<String> subscribedEventTypes = ImmutableSet.of((Object)ItemStateEvent.TYPE, (Object)ItemCommandEvent.TYPE, (Object)ChannelTriggeredEvent.TYPE, (Object)ThingStatusInfoChangedEvent.TYPE);

    @Activate
    public void activate() {
        this.injector = RulesStandaloneSetup.getInjector();
        this.triggerManager = (RuleTriggerManager)this.injector.getInstance(RuleTriggerManager.class);
        if (!this.isEnabled()) {
            this.logger.info("Rule engine is disabled.");
            return;
        }
        this.logger.debug("Started rule engine");
        Iterable ruleModelNames = this.modelRepository.getAllModelNamesOfType("rules");
        ArrayList clonedList = Lists.newArrayList((Iterable)ruleModelNames);
        for (String ruleModelName : clonedList) {
            EObject model = this.modelRepository.getModel(ruleModelName);
            if (!(model instanceof RuleModel)) continue;
            RuleModel ruleModel = (RuleModel)model;
            this.triggerManager.addRuleModel(ruleModel);
        }
        this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
        this.modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        for (Item item : this.itemRegistry.getItems()) {
            this.internalItemAdded(item);
        }
        this.scheduleStartupRules();
    }

    @Deactivate
    public void deactivate() {
        for (Item item : this.itemRegistry.getItems()) {
            this.internalItemRemoved(item);
        }
        this.modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.executeRules(this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.SHUTDOWN));
        this.triggerManager.clearAll();
        this.triggerManager = null;
    }

    @Reference
    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        this.modelRepository = null;
    }

    @Reference
    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void unsetScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = null;
    }

    @Reference
    protected void setRuleRuntimeActivator(RuleRuntimeActivator ruleRuntimeActivator) {
    }

    protected void unsetRuleRuntimeActivator(RuleRuntimeActivator ruleRuntimeActivator) {
    }

    public void allItemsChanged(Collection<String> oldItemNames) {
        Collection items = this.itemRegistry.getItems();
        for (Item item : items) {
            this.internalItemAdded(item);
        }
        this.scheduleStartupRules();
    }

    public void added(Item item) {
        this.internalItemAdded(item);
        this.scheduleStartupRules();
    }

    public void removed(Item item) {
        this.internalItemRemoved(item);
    }

    public void stateChanged(Item item, State oldState, State newState) {
        if (!this.starting && this.triggerManager != null) {
            Iterable<Rule> rules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.CHANGE, item, oldState, newState);
            this.executeRules(rules, item, oldState);
        }
    }

    public void stateUpdated(Item item, State state) {
        if (!this.starting && this.triggerManager != null) {
            Iterable<Rule> rules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.UPDATE, item, state);
            this.executeRules(rules, item);
        }
    }

    private void receiveCommand(ItemCommandEvent commandEvent) {
        if (!this.starting && this.triggerManager != null && this.itemRegistry != null) {
            String itemName = commandEvent.getItemName();
            Command command = commandEvent.getItemCommand();
            try {
                Item item = this.itemRegistry.getItem(itemName);
                Iterable<Rule> rules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.COMMAND, item, command);
                this.executeRules(rules, item, command);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    private void receiveThingTrigger(ChannelTriggeredEvent event) {
        String triggerEvent = event.getEvent();
        String channel = event.getChannel().getAsString();
        Iterable<Rule> rules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.TRIGGER, channel, triggerEvent);
        this.executeRules(rules, event);
    }

    private void receiveThingStatus(ThingStatusInfoChangedEvent event) {
        String thingUid = event.getThingUID().getAsString();
        ThingStatus oldStatus = event.getOldStatusInfo().getStatus();
        ThingStatus newStatus = event.getStatusInfo().getStatus();
        Iterable<Rule> rules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.THINGUPDATE, thingUid, newStatus);
        this.executeRules(rules);
        if (oldStatus != newStatus) {
            rules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.THINGCHANGE, thingUid, oldStatus, newStatus);
            this.executeRules(rules, oldStatus);
        }
    }

    private void internalItemAdded(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.addStateChangeListener((StateChangeListener)this);
        }
    }

    private void internalItemRemoved(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.removeStateChangeListener((StateChangeListener)this);
        }
    }

    public void modelChanged(String modelName, EventType type) {
        if (this.triggerManager != null && this.isEnabled() && modelName.endsWith("rules")) {
            RuleModel model = (RuleModel)this.modelRepository.getModel(modelName);
            if (type == EventType.REMOVED || type == EventType.MODIFIED) {
                this.triggerManager.removeRuleModel(model);
            }
            if (model != null && (type == EventType.ADDED || type == EventType.MODIFIED)) {
                this.triggerManager.addRuleModel(model);
                this.scheduleStartupRules();
            }
        }
    }

    private void scheduleStartupRules() {
        if (this.startupJob != null && !this.startupJob.isCancelled() && !this.startupJob.isDone()) {
            this.startupJob.cancel(true);
        }
        this.startupJob = this.scheduler.schedule(() -> this.runStartupRules(), 5L, TimeUnit.SECONDS);
    }

    private void runStartupRules() {
        if (this.triggerManager != null) {
            Iterable<Rule> startupRules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.STARTUP);
            for (Rule rule : startupRules) {
                this.scheduler.execute(() -> {
                    try {
                        Script script = this.scriptEngine.newScriptFromXExpression((XExpression)rule.getScript());
                        this.logger.debug("Executing startup rule '{}'", (Object)rule.getName());
                        RuleEvaluationContext context = new RuleEvaluationContext();
                        context.setGlobalContext(RuleContextHelper.getContext(rule, this.injector));
                        script.execute((IEvaluationContext)context);
                        this.triggerManager.removeRule(RuleTriggerManager.TriggerTypes.STARTUP, rule);
                    }
                    catch (ScriptExecutionException e) {
                        if (!e.getMessage().contains("cannot be resolved to an item or type")) {
                            this.logger.error("Error during the execution of startup rule '{}': {}", (Object)rule.getName(), (Object)e.getCause().getMessage());
                            this.triggerManager.removeRule(RuleTriggerManager.TriggerTypes.STARTUP, rule);
                        }
                        this.logger.debug("Execution of startup rule '{}' has been postponed as items are still missing: {}", (Object)rule.getName(), (Object)e.getMessage());
                    }
                });
            }
            this.starting = false;
            this.triggerManager.startTimerRuleExecution();
        }
    }

    protected synchronized void executeRule(Rule rule, RuleEvaluationContext context) {
        this.scheduler.execute(() -> {
            Script script = this.scriptEngine.newScriptFromXExpression((XExpression)rule.getScript());
            this.logger.debug("Executing rule '{}'", (Object)rule.getName());
            context.setGlobalContext(RuleContextHelper.getContext(rule, this.injector));
            try {
                script.execute((IEvaluationContext)context);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null) {
                    this.logger.error("Rule '{}'", (Object)rule.getName(), (Object)e.getCause());
                }
                this.logger.error("Rule '{}': {}", (Object)rule.getName(), (Object)msg);
            }
        });
    }

    protected synchronized void executeRules(Iterable<Rule> rules) {
        for (Rule rule : rules) {
            RuleEvaluationContext context = new RuleEvaluationContext();
            this.executeRule(rule, context);
        }
    }

    protected synchronized void executeRules(Iterable<Rule> rules, ChannelTriggeredEvent event) {
        for (Rule rule : rules) {
            RuleEvaluationContext context = new RuleEvaluationContext();
            context.newValue(QualifiedName.create((String)"receivedEvent"), event);
            this.executeRule(rule, context);
        }
    }

    protected synchronized void executeRules(Iterable<Rule> rules, Item item) {
        for (Rule rule : rules) {
            RuleEvaluationContext context = new RuleEvaluationContext();
            context.newValue(QualifiedName.create((String)"triggeringItem"), item);
            this.executeRule(rule, context);
        }
    }

    protected synchronized void executeRules(Iterable<Rule> rules, Item item, Command command) {
        for (Rule rule : rules) {
            RuleEvaluationContext context = new RuleEvaluationContext();
            context.newValue(QualifiedName.create((String)"triggeringItem"), item);
            context.newValue(QualifiedName.create((String)"receivedCommand"), command);
            this.executeRule(rule, context);
        }
    }

    protected synchronized void executeRules(Iterable<Rule> rules, Item item, State oldState) {
        for (Rule rule : rules) {
            RuleEvaluationContext context = new RuleEvaluationContext();
            context.newValue(QualifiedName.create((String)"triggeringItem"), item);
            context.newValue(QualifiedName.create((String)"previousState"), oldState);
            this.executeRule(rule, context);
        }
    }

    protected synchronized void executeRules(Iterable<Rule> rules, ThingStatus oldThingStatus) {
        for (Rule rule : rules) {
            RuleEvaluationContext context = new RuleEvaluationContext();
            context.newValue(QualifiedName.create((String)"previousState"), oldThingStatus.toString());
            this.executeRule(rule, context);
        }
    }

    private boolean isEnabled() {
        return !"true".equalsIgnoreCase(System.getProperty("noRules"));
    }

    public void updated(Item oldItem, Item item) {
        this.removed(oldItem);
        this.added(item);
    }

    public Set<String> getSubscribedEventTypes() {
        return this.subscribedEventTypes;
    }

    public EventFilter getEventFilter() {
        return null;
    }

    public void receive(Event event) {
        if (event instanceof ItemCommandEvent) {
            this.receiveCommand((ItemCommandEvent)event);
        } else if (event instanceof ChannelTriggeredEvent) {
            this.receiveThingTrigger((ChannelTriggeredEvent)event);
        } else if (event instanceof ThingStatusInfoChangedEvent) {
            this.receiveThingStatus((ThingStatusInfoChangedEvent)event);
        }
    }
}

