/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.storage.json.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.smarthome.config.core.Configuration;

public class ConfigurationDeserializer
implements JsonDeserializer<Configuration> {
    public Configuration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Configuration configuration = new Configuration();
        JsonObject configurationObject = json.getAsJsonObject();
        if (configurationObject.get("properties") != null) {
            JsonObject propertiesObject = configurationObject.get("properties").getAsJsonObject();
            for (Map.Entry entry : propertiesObject.entrySet()) {
                JsonElement value = (JsonElement)entry.getValue();
                String key = (String)entry.getKey();
                if (value.isJsonPrimitive()) {
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    configuration.put(key, this.deserialize(primitive));
                    continue;
                }
                if (value.isJsonArray()) {
                    JsonArray array = value.getAsJsonArray();
                    configuration.put(key, this.deserialize(array));
                    continue;
                }
                throw new IllegalArgumentException("Configuration parameters must be primitives or arrays of primities only but was " + value);
            }
        }
        return configuration;
    }

    private Object deserialize(JsonPrimitive primitive) {
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        if (primitive.isNumber()) {
            return primitive.getAsBigDecimal();
        }
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        throw new IllegalArgumentException("Unsupported primitive: " + primitive);
    }

    private Object deserialize(JsonArray array) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (JsonElement element : array) {
            if (element.isJsonPrimitive()) {
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                list.add(this.deserialize(primitive));
                continue;
            }
            throw new IllegalArgumentException("Multiples must only contain primitives but was " + element);
        }
        return list;
    }
}

